/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.connector.classloader;

import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.classloader.ClassLoaderSafeConnectorPageSink;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorMetadata;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorSplitManager;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeNodePartitioningProvider;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestClassLoaderSafeWrappers {
    @Test
    public void testAllMethodsOverridden() {
        TestClassLoaderSafeWrappers.assertAllMethodsOverridden(ConnectorMetadata.class, ClassLoaderSafeConnectorMetadata.class);
        TestClassLoaderSafeWrappers.assertAllMethodsOverridden(ConnectorPageSink.class, ClassLoaderSafeConnectorPageSink.class);
        TestClassLoaderSafeWrappers.assertAllMethodsOverridden(ConnectorPageSinkProvider.class, ClassLoaderSafeConnectorPageSinkProvider.class);
        TestClassLoaderSafeWrappers.assertAllMethodsOverridden(ConnectorPageSourceProvider.class, ClassLoaderSafeConnectorPageSourceProvider.class);
        TestClassLoaderSafeWrappers.assertAllMethodsOverridden(ConnectorSplitManager.class, ClassLoaderSafeConnectorSplitManager.class);
        TestClassLoaderSafeWrappers.assertAllMethodsOverridden(ConnectorNodePartitioningProvider.class, ClassLoaderSafeNodePartitioningProvider.class);
    }

    private static <I, C extends I> void assertAllMethodsOverridden(Class<I> iface, Class<C> clazz) {
        Assert.assertEquals((Set)ImmutableSet.copyOf((Object[])clazz.getInterfaces()), (Set)ImmutableSet.of(iface));
        for (Method method : iface.getMethods()) {
            try {
                Method override = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                Assert.assertEquals(override.getReturnType(), method.getReturnType());
            }
            catch (NoSuchMethodException e) {
                Assert.fail((String)String.format("%s does not override [%s]", clazz.getName(), method));
            }
        }
    }
}

