/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.Base64;
import java.util.Objects;

public final class TestingBlockJsonSerde {
    private TestingBlockJsonSerde() {
    }

    public static class Deserializer
    extends JsonDeserializer<Block> {
        private final BlockEncodingSerde blockEncodingSerde;

        public Deserializer(BlockEncodingSerde blockEncodingSerde) {
            this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        }

        public Block deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            byte[] decoded = Base64.getDecoder().decode((String)jsonParser.readValueAs(String.class));
            BasicSliceInput input = Slices.wrappedBuffer((byte[])decoded).getInput();
            BlockEncoding blockEncoding = this.blockEncodingSerde.readBlockEncoding((SliceInput)input);
            return blockEncoding.readBlock((SliceInput)input);
        }
    }

    public static class Serializer
    extends JsonSerializer<Block> {
        private final BlockEncodingSerde blockEncodingSerde;

        public Serializer(BlockEncodingSerde blockEncodingSerde) {
            this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        }

        public void serialize(Block block, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            DynamicSliceOutput output = new DynamicSliceOutput(64);
            BlockEncoding encoding = block.getEncoding();
            this.blockEncodingSerde.writeBlockEncoding((SliceOutput)output, encoding);
            encoding.writeBlock((SliceOutput)output, block);
            String encoded = Base64.getEncoder().encodeToString(output.slice().getBytes());
            jsonGenerator.writeString(encoded);
        }
    }
}

