/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.VariableWidthBlockEncoding;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.util.Locale;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestVariableWidthBlockEncoding {
    private static final ConnectorSession SESSION = new ConnectorSession(){

        public String getQueryId() {
            return "test_query_id";
        }

        public Identity getIdentity() {
            return new Identity("user", Optional.empty());
        }

        public TimeZoneKey getTimeZoneKey() {
            return TimeZoneKey.UTC_KEY;
        }

        public Locale getLocale() {
            return Locale.ENGLISH;
        }

        public long getStartTime() {
            return 0L;
        }

        public <T> T getProperty(String name, Class<T> type) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown session property " + name);
        }
    };

    @Test
    public void testRoundTrip() {
        BlockBuilder expectedBlockBuilder = VarcharType.VARCHAR.createBlockBuilder(new BlockBuilderStatus(), 4);
        VarcharType.VARCHAR.writeString(expectedBlockBuilder, "alice");
        VarcharType.VARCHAR.writeString(expectedBlockBuilder, "bob");
        VarcharType.VARCHAR.writeString(expectedBlockBuilder, "charlie");
        VarcharType.VARCHAR.writeString(expectedBlockBuilder, "dave");
        Block expectedBlock = expectedBlockBuilder.build();
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1024);
        VariableWidthBlockEncoding blockEncoding = new VariableWidthBlockEncoding();
        blockEncoding.writeBlock((SliceOutput)sliceOutput, expectedBlock);
        Block actualBlock = blockEncoding.readBlock((SliceInput)sliceOutput.slice().getInput());
        TestVariableWidthBlockEncoding.assertBlockEquals((Type)VarcharType.VARCHAR, actualBlock, expectedBlock);
    }

    private static void assertBlockEquals(Type type, Block actual, Block expected) {
        for (int position = 0; position < actual.getPositionCount(); ++position) {
            Assert.assertEquals((Object)type.getObjectValue(SESSION, actual, position), (Object)type.getObjectValue(SESSION, expected, position));
        }
    }
}

