/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.InterleavedBlockBuilder;
import com.facebook.presto.spi.block.PageBuilderStatus;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestInterleavedBlockBuilder {
    private static final int VARCHAR_VALUE_SIZE = 7;
    private static final int INT_VARCHAR_ENTRY_SIZE = 21;
    private static final int EXPECTED_ENTRY_COUNT = 100;

    @Test
    public void testArrayBlockIsFull() throws Exception {
        this.testIsFull(new PageBuilderStatus(1050, 10240));
        this.testIsFull(new PageBuilderStatus(10240, 1050));
    }

    private void testIsFull(PageBuilderStatus pageBuilderStatus) {
        InterleavedBlockBuilder blockBuilder = new InterleavedBlockBuilder((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR), pageBuilderStatus.createBlockBuilderStatus(), 100);
        Assert.assertTrue((boolean)pageBuilderStatus.isEmpty());
        while (!pageBuilderStatus.isFull()) {
            BigintType.BIGINT.writeLong((BlockBuilder)blockBuilder, 12L);
            VarcharType.VARCHAR.writeSlice((BlockBuilder)blockBuilder, Slices.allocate((int)7));
        }
        Assert.assertEquals((int)blockBuilder.getPositionCount(), (int)100);
        Assert.assertEquals((boolean)pageBuilderStatus.isFull(), (boolean)true);
    }
}

