/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.DictionaryBlockEncoding;
import com.facebook.presto.spi.block.VariableWidthBlockEncoding;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.util.Locale;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDictionaryBlockEncoding {
    private static final ConnectorSession SESSION = new ConnectorSession(){

        public String getQueryId() {
            return "test_query_id";
        }

        public Identity getIdentity() {
            return new Identity("user", Optional.empty());
        }

        public TimeZoneKey getTimeZoneKey() {
            return TimeZoneKey.UTC_KEY;
        }

        public Locale getLocale() {
            return Locale.ENGLISH;
        }

        public long getStartTime() {
            return 0L;
        }

        public <T> T getProperty(String name, Class<T> type) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown session property " + name);
        }
    };

    @Test
    public void testRoundTrip() {
        int positionCount = 40;
        BlockBuilder dictionaryBuilder = VarcharType.VARCHAR.createBlockBuilder(new BlockBuilderStatus(), 4);
        VarcharType.VARCHAR.writeString(dictionaryBuilder, "alice");
        VarcharType.VARCHAR.writeString(dictionaryBuilder, "bob");
        VarcharType.VARCHAR.writeString(dictionaryBuilder, "charlie");
        VarcharType.VARCHAR.writeString(dictionaryBuilder, "dave");
        Block dictionary = dictionaryBuilder.build();
        int[] ids = new int[positionCount];
        for (int i = 0; i < 40; ++i) {
            ids[i] = i % 4;
        }
        DictionaryBlockEncoding blockEncoding = new DictionaryBlockEncoding((BlockEncoding)new VariableWidthBlockEncoding());
        DictionaryBlock dictionaryBlock = new DictionaryBlock(positionCount, dictionary, ids);
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1024);
        blockEncoding.writeBlock((SliceOutput)sliceOutput, (Block)dictionaryBlock);
        Block actualBlock = blockEncoding.readBlock((SliceInput)sliceOutput.slice().getInput());
        Assert.assertTrue((boolean)(actualBlock instanceof DictionaryBlock));
        DictionaryBlock actualDictionaryBlock = (DictionaryBlock)actualBlock;
        TestDictionaryBlockEncoding.assertBlockEquals((Type)VarcharType.VARCHAR, actualDictionaryBlock.getDictionary(), dictionary);
        for (int position = 0; position < actualDictionaryBlock.getPositionCount(); ++position) {
            Assert.assertEquals((int)actualDictionaryBlock.getId(position), (int)ids[position]);
        }
        Assert.assertEquals((Object)actualDictionaryBlock.getDictionarySourceId(), (Object)dictionaryBlock.getDictionarySourceId());
    }

    private static void assertBlockEquals(Type type, Block actual, Block expected) {
        for (int position = 0; position < actual.getPositionCount(); ++position) {
            Assert.assertEquals((Object)type.getObjectValue(SESSION, actual, position), (Object)type.getObjectValue(SESSION, expected, position));
        }
    }
}

