/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.ArrayBlockBuilder;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.FixedWidthBlockBuilder;
import com.facebook.presto.spi.block.LongArrayBlockBuilder;
import com.facebook.presto.spi.block.PageBuilderStatus;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestArrayBlockBuilder {
    private static final int THREE_INTS_ENTRY_SIZE = 32;
    private static final int EXPECTED_ENTRY_COUNT = 100;

    @Test
    public void testArrayBlockIsFull() throws Exception {
        this.testIsFull(new PageBuilderStatus(3200, 10240));
        this.testIsFull(new PageBuilderStatus(10240, 3200));
    }

    private void testIsFull(PageBuilderStatus pageBuilderStatus) {
        ArrayBlockBuilder blockBuilder = new ArrayBlockBuilder((Type)BigintType.BIGINT, pageBuilderStatus.createBlockBuilderStatus(), 100);
        Assert.assertTrue((boolean)pageBuilderStatus.isEmpty());
        while (!pageBuilderStatus.isFull()) {
            BlockBuilder elementBuilder = blockBuilder.beginBlockEntry();
            BigintType.BIGINT.writeLong(elementBuilder, 12L);
            elementBuilder.appendNull();
            BigintType.BIGINT.writeLong(elementBuilder, 34L);
            blockBuilder.closeEntry();
        }
        Assert.assertEquals((int)blockBuilder.getPositionCount(), (int)100);
        Assert.assertEquals((boolean)pageBuilderStatus.isFull(), (boolean)true);
    }

    @Test
    public void testRetainedSizeInBytes() {
        int expectedEntries = 1000;
        ArrayBlockBuilder arrayBlockBuilder = new ArrayBlockBuilder((Type)BigintType.BIGINT, new BlockBuilderStatus(), expectedEntries);
        long initialRetainedSize = arrayBlockBuilder.getRetainedSizeInBytes();
        for (int i = 0; i < expectedEntries; ++i) {
            BlockBuilder arrayElementBuilder = arrayBlockBuilder.beginBlockEntry();
            BigintType.BIGINT.writeLong(arrayElementBuilder, (long)i);
            arrayBlockBuilder.closeEntry();
        }
        Assert.assertTrue(((long)arrayBlockBuilder.getRetainedSizeInBytes() >= (long)(expectedEntries * 8 + ClassLayout.parseClass(LongArrayBlockBuilder.class).instanceSize()) + initialRetainedSize ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="Expected current entry to be closed but was opened")
    public void testConcurrentWriting() {
        ArrayBlockBuilder blockBuilder = new ArrayBlockBuilder((Type)BigintType.BIGINT, new BlockBuilderStatus(), 100);
        BlockBuilder elementBlockWriter = blockBuilder.beginBlockEntry();
        elementBlockWriter.writeLong(45L).closeEntry();
        blockBuilder.writeObject((Object)new FixedWidthBlockBuilder(8, 4).writeLong(123L).closeEntry().build()).closeEntry();
    }
}

