/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.ErrorType;

public enum SparkErrorCode implements ErrorCodeSupplier
{
    GENERIC_SPARK_ERROR(0, ErrorType.INTERNAL_ERROR),
    SPARK_EXECUTOR_OOM(1, ErrorType.INTERNAL_ERROR),
    SPARK_EXECUTOR_LOST(2, ErrorType.INTERNAL_ERROR),
    EXCEEDED_SPARK_DRIVER_MAX_RESULT_SIZE(3, ErrorType.INSUFFICIENT_RESOURCES),
    UNSUPPORTED_STORAGE_TYPE(4, ErrorType.INTERNAL_ERROR),
    STORAGE_ERROR(5, ErrorType.EXTERNAL),
    MALFORMED_QUERY_FILE(6, ErrorType.EXTERNAL);

    private final ErrorCode errorCode;
    public static final int ERROR_CODE_MASK = 196608;

    private SparkErrorCode(int code, ErrorType type) {
        this.errorCode = new ErrorCode(code + 196608, this.name(), type);
    }

    public ErrorCode toErrorCode() {
        return this.errorCode;
    }
}

