/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.classloader_interface;

import com.facebook.airlift.units.Duration;
import com.google.common.base.Ticker;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public class PrestoSparkBootstrapTimer {
    private final Ticker ticker;
    private final boolean isExecutor;
    private final AtomicReference<Long> beginRunnerServiceCreation = new AtomicReference();
    private final AtomicReference<Duration> endRunnerServiceCreation = new AtomicReference();
    private final AtomicReference<Long> beginPrestoSparkServiceCreation = new AtomicReference();
    private final AtomicReference<Duration> endPrestoSparkServiceCreation = new AtomicReference();
    private final AtomicReference<Long> beginInjectorCreation = new AtomicReference();
    private final AtomicReference<Duration> endInjectorCreation = new AtomicReference();
    private final AtomicReference<Long> beginInjectorInitialization = new AtomicReference();
    private final AtomicReference<Duration> endInjectorInitialization = new AtomicReference();
    private final AtomicReference<Long> beginSharedModulesLoading = new AtomicReference();
    private final AtomicReference<Duration> endSharedModulesLoading = new AtomicReference();
    private final AtomicReference<Long> beginNonTestingModulesLoading = new AtomicReference();
    private final AtomicReference<Duration> endNonTestingModulesLoading = new AtomicReference();
    private final AtomicReference<Long> beginDriverModulesLoading = new AtomicReference();
    private final AtomicReference<Duration> endDriverModulesLoading = new AtomicReference();

    public PrestoSparkBootstrapTimer(Ticker ticker, boolean isExecutor) {
        this.ticker = Objects.requireNonNull(ticker, "PrestoSparkBootstrapTimer ticker is null");
        this.isExecutor = isExecutor;
    }

    public Map<String, Long> exportBootstrapDurations() {
        HashMap<String, Long> output = new HashMap<String, Long>();
        output.put("PrestoSparkServiceCreationDurationMS", this.endPrestoSparkServiceCreation.get() != null ? this.endPrestoSparkServiceCreation.get().toMillis() : 0L);
        output.put("RunnerServiceCreationDurationMS", this.endRunnerServiceCreation.get() != null ? this.endRunnerServiceCreation.get().toMillis() : 0L);
        output.put("InjectorCreationDurationMS", this.endInjectorCreation.get() != null ? this.endInjectorCreation.get().toMillis() : 0L);
        output.put("InjectorInitializationDurationMS", this.endInjectorInitialization.get() != null ? this.endInjectorCreation.get().toMillis() : 0L);
        output.put("SharedModulesLoadingDurationMS", this.endSharedModulesLoading.get() != null ? this.endSharedModulesLoading.get().toMillis() : 0L);
        output.put("NonTestingModulesLoadingDurationMS", this.endNonTestingModulesLoading.get() != null ? this.endNonTestingModulesLoading.get().toMillis() : 0L);
        output.put("DriverModulesLoadingDurationMS", this.endDriverModulesLoading.get() != null ? this.endDriverModulesLoading.get().toMillis() : 0L);
        return output;
    }

    public boolean isExecutorBootstrap() {
        return this.isExecutor;
    }

    private static Duration nanosSince(AtomicReference<Long> start, long end) {
        Long startNanos = start.get();
        if (startNanos == null) {
            throw new IllegalStateException("Start time not set");
        }
        return PrestoSparkBootstrapTimer.nanosSince(startNanos, end);
    }

    private static Duration nanosSince(long start, long now) {
        return Duration.succinctNanos((long)Math.max(0L, now - start));
    }

    public void beginRunnerServiceCreation() {
        this.beginRunnerServiceCreation.compareAndSet(null, this.ticker.read());
    }

    public void endRunnerServiceCreation() {
        this.endRunnerServiceCreation.compareAndSet(null, PrestoSparkBootstrapTimer.nanosSince(this.beginRunnerServiceCreation, this.ticker.read()));
    }

    public void beginPrestoSparkServiceCreation() {
        this.beginPrestoSparkServiceCreation.compareAndSet(null, this.ticker.read());
    }

    public void endPrestoSparkServiceCreation() {
        this.endPrestoSparkServiceCreation.compareAndSet(null, PrestoSparkBootstrapTimer.nanosSince(this.beginPrestoSparkServiceCreation, this.ticker.read()));
    }

    public void beginInjectorCreation() {
        this.beginInjectorCreation.compareAndSet(null, this.ticker.read());
    }

    public void endInjectorCreation() {
        this.endInjectorCreation.compareAndSet(null, PrestoSparkBootstrapTimer.nanosSince(this.beginInjectorCreation, this.ticker.read()));
    }

    public void beginInjectorInitialization() {
        this.beginInjectorInitialization.compareAndSet(null, this.ticker.read());
    }

    public void endInjectorInitialization() {
        this.endInjectorInitialization.compareAndSet(null, PrestoSparkBootstrapTimer.nanosSince(this.beginInjectorInitialization, this.ticker.read()));
    }

    public void beginSharedModulesLoading() {
        this.beginSharedModulesLoading.compareAndSet(null, this.ticker.read());
    }

    public void endSharedModulesLoading() {
        this.endSharedModulesLoading.compareAndSet(null, PrestoSparkBootstrapTimer.nanosSince(this.beginSharedModulesLoading, this.ticker.read()));
    }

    public void beginNonTestingModulesLoading() {
        this.beginNonTestingModulesLoading.compareAndSet(null, this.ticker.read());
    }

    public void endNonTestingModulesLoading() {
        this.endNonTestingModulesLoading.compareAndSet(null, PrestoSparkBootstrapTimer.nanosSince(this.beginNonTestingModulesLoading, this.ticker.read()));
    }

    public void beginDriverModulesLoading() {
        this.beginDriverModulesLoading.compareAndSet(null, this.ticker.read());
    }

    public void endDriverModulesLoading() {
        this.endDriverModulesLoading.compareAndSet(null, PrestoSparkBootstrapTimer.nanosSince(this.beginDriverModulesLoading, this.ticker.read()));
    }
}

