/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.classloader_interface;

import com.facebook.presto.spark.classloader_interface.MutablePartitionId;
import com.facebook.presto.spark.classloader_interface.PrestoSparkMutableRow;
import com.facebook.presto.spark.classloader_interface.PrestoSparkTaskOutput;
import com.facebook.presto.spark.classloader_interface.PrestoSparkTaskProcessor;
import com.facebook.presto.spark.classloader_interface.PrestoSparkTaskSourceRdd;
import com.facebook.presto.spark.classloader_interface.ScalaUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.ZippedPartitionsBaseRDD;
import org.apache.spark.rdd.ZippedPartitionsPartition;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

public class PrestoSparkTaskRdd<T extends PrestoSparkTaskOutput>
extends ZippedPartitionsBaseRDD<Tuple2<MutablePartitionId, T>> {
    private List<RDD<Tuple2<MutablePartitionId, PrestoSparkMutableRow>>> shuffleInputRdds;
    private List<String> shuffleInputFragmentIds;
    private PrestoSparkTaskSourceRdd taskSourceRdd;
    private PrestoSparkTaskProcessor<T> taskProcessor;

    public static <T extends PrestoSparkTaskOutput> PrestoSparkTaskRdd<T> create(SparkContext context, Optional<PrestoSparkTaskSourceRdd> taskSourceRdd, Map<String, RDD<Tuple2<MutablePartitionId, PrestoSparkMutableRow>>> shuffleInputRddMap, PrestoSparkTaskProcessor<T> taskProcessor) {
        Objects.requireNonNull(context, "context is null");
        Objects.requireNonNull(taskSourceRdd, "taskSourceRdd is null");
        Objects.requireNonNull(shuffleInputRddMap, "shuffleInputRdds is null");
        Objects.requireNonNull(taskProcessor, "taskProcessor is null");
        ArrayList<String> shuffleInputFragmentIds = new ArrayList<String>();
        ArrayList<RDD<Tuple2<MutablePartitionId, PrestoSparkMutableRow>>> shuffleInputRdds = new ArrayList<RDD<Tuple2<MutablePartitionId, PrestoSparkMutableRow>>>();
        for (Map.Entry<String, RDD<Tuple2<MutablePartitionId, PrestoSparkMutableRow>>> entry : shuffleInputRddMap.entrySet()) {
            shuffleInputFragmentIds.add(entry.getKey());
            shuffleInputRdds.add(entry.getValue());
        }
        return new PrestoSparkTaskRdd<T>(context, taskSourceRdd, shuffleInputFragmentIds, shuffleInputRdds, taskProcessor);
    }

    protected PrestoSparkTaskRdd(SparkContext context, Optional<PrestoSparkTaskSourceRdd> taskSourceRdd, List<String> shuffleInputFragmentIds, List<RDD<Tuple2<MutablePartitionId, PrestoSparkMutableRow>>> shuffleInputRdds, PrestoSparkTaskProcessor<T> taskProcessor) {
        super(context, PrestoSparkTaskRdd.getRDDSequence(taskSourceRdd, shuffleInputRdds), false, PrestoSparkTaskRdd.fakeClassTag());
        this.shuffleInputFragmentIds = shuffleInputFragmentIds;
        this.shuffleInputRdds = shuffleInputRdds;
        this.taskSourceRdd = taskSourceRdd.orElse(null);
        this.taskProcessor = (PrestoSparkTaskProcessor)context.clean(taskProcessor, true);
    }

    private static Seq<RDD<?>> getRDDSequence(Optional<PrestoSparkTaskSourceRdd> taskSourceRdd, List<RDD<Tuple2<MutablePartitionId, PrestoSparkMutableRow>>> shuffleInputRdds) {
        ArrayList<RDD<Tuple2<MutablePartitionId, PrestoSparkMutableRow>>> list = new ArrayList<RDD<Tuple2<MutablePartitionId, PrestoSparkMutableRow>>>(shuffleInputRdds);
        taskSourceRdd.ifPresent(list::add);
        return JavaConversions.asScalaBuffer(list).toSeq();
    }

    private static <T> ClassTag<T> fakeClassTag() {
        return ClassTag$.MODULE$.apply(Tuple2.class);
    }

    public Iterator<Tuple2<MutablePartitionId, T>> compute(Partition split, TaskContext context) {
        List partitions = JavaConversions.seqAsJavaList((Seq)((ZippedPartitionsPartition)split).partitions());
        int expectedPartitionsSize = (this.taskSourceRdd != null ? 1 : 0) + this.shuffleInputRdds.size();
        if (partitions.size() != expectedPartitionsSize) {
            throw new IllegalArgumentException(String.format("Unexpected partitions size. Expected: %s. Actual: %s.", expectedPartitionsSize, partitions.size()));
        }
        HashMap<String, Iterator> shuffleInputIterators = new HashMap<String, Iterator>();
        for (int inputIndex = 0; inputIndex < this.shuffleInputRdds.size(); ++inputIndex) {
            shuffleInputIterators.put(this.shuffleInputFragmentIds.get(inputIndex), this.shuffleInputRdds.get(inputIndex).iterator((Partition)partitions.get(inputIndex), context));
        }
        Iterator taskSourceIterator = this.taskSourceRdd != null ? this.taskSourceRdd.iterator((Partition)partitions.get(partitions.size() - 1), context) : ScalaUtils.emptyScalaIterator();
        return this.taskProcessor.process(taskSourceIterator, Collections.unmodifiableMap(shuffleInputIterators));
    }

    public void clearDependencies() {
        super.clearDependencies();
        this.shuffleInputFragmentIds = null;
        this.shuffleInputRdds = null;
        this.taskSourceRdd = null;
        this.taskProcessor = null;
    }

    public List<RDD<Tuple2<MutablePartitionId, PrestoSparkMutableRow>>> getShuffleInputRdds() {
        return this.shuffleInputRdds;
    }

    public PrestoSparkTaskSourceRdd getTaskSourceRdd() {
        return this.taskSourceRdd;
    }

    public List<String> getShuffleInputFragmentIds() {
        return this.shuffleInputFragmentIds;
    }

    public PrestoSparkTaskProcessor<T> getTaskProcessor() {
        return this.taskProcessor;
    }
}

