/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.classloader_interface;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.spark_project.guava.base.Preconditions;

public class PrestoSparkShuffleStats
implements Serializable {
    private final int fragmentId;
    private final int taskId;
    private final Operation operation;
    private final long processedRows;
    private final long processedRowBatches;
    private final long processedBytes;
    private final long elapsedWallTimeMills;

    public PrestoSparkShuffleStats(int fragmentId, int taskId, Operation operation, long processedRows, long processedRowBatches, long processedBytes, long elapsedWallTimeMills) {
        this.fragmentId = fragmentId;
        this.taskId = taskId;
        this.operation = Objects.requireNonNull(operation, "operation is null");
        Preconditions.checkArgument((processedRows >= 0L ? 1 : 0) != 0, (String)"processedRows must be greater than or equal to zero: %s", (Object[])new Object[]{processedRows});
        this.processedRows = processedRows;
        Preconditions.checkArgument((processedRowBatches >= 0L ? 1 : 0) != 0, (String)"processedRowBatches must be greater than or equal to zero: %s", (Object[])new Object[]{processedRowBatches});
        this.processedRowBatches = processedRowBatches;
        Preconditions.checkArgument((processedBytes >= 0L ? 1 : 0) != 0, (String)"processedBytes must be greater than or equal to zero: %s", (Object[])new Object[]{processedBytes});
        this.processedBytes = processedBytes;
        Preconditions.checkArgument((elapsedWallTimeMills >= 0L ? 1 : 0) != 0, (String)"elapsedWallTimeMills must be greater than or equal to zero: %s", (Object[])new Object[]{elapsedWallTimeMills});
        this.elapsedWallTimeMills = elapsedWallTimeMills;
    }

    public int getFragmentId() {
        return this.fragmentId;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public long getProcessedRows() {
        return this.processedRows;
    }

    public long getProcessedRowBatches() {
        return this.processedRowBatches;
    }

    public long getProcessedBytes() {
        return this.processedBytes;
    }

    public long getElapsedWallTimeMills() {
        return this.elapsedWallTimeMills;
    }

    public String toString() {
        return String.format("%s.%s:%s:%sM:%sMB:%smin", this.fragmentId, this.taskId, Character.valueOf(this.operation.toString().charAt(0)), this.processedRows / 1000L / 1000L, this.processedBytes / 1024L / 1024L, TimeUnit.MILLISECONDS.toMinutes(this.elapsedWallTimeMills));
    }

    public static enum Operation {
        READ,
        WRITE;

    }
}

