/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.classloader_interface;

import com.facebook.presto.spark.classloader_interface.MutablePartitionId;
import com.facebook.presto.spark.classloader_interface.PrestoSparkMutableRow;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.spark.serializer.DeserializationStream;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerInstance;
import scala.Tuple2;
import scala.collection.AbstractIterator;
import scala.collection.Iterator;
import scala.reflect.ClassTag;

public class PrestoSparkShuffleSerializer
extends Serializer
implements Serializable {
    public SerializerInstance newInstance() {
        return new PrestoSparkShuffleSerializerInstance();
    }

    public boolean supportsRelocationOfSerializedObjects() {
        return true;
    }

    public static class PrestoSparkShuffleDeserializationStream
    extends DeserializationStream {
        private final DataInputStream inputStream;
        private final MutablePartitionId mutablePartitionId = new MutablePartitionId();
        private final PrestoSparkMutableRow row = new PrestoSparkMutableRow();
        private final Tuple2<Object, Object> tuple = new Tuple2((Object)this.mutablePartitionId, (Object)this.row);
        private byte[] bytes;
        private ByteBuffer buffer;

        public PrestoSparkShuffleDeserializationStream(InputStream inputStream) {
            this.inputStream = new DataInputStream(Objects.requireNonNull(inputStream, "inputStream is null"));
        }

        public Iterator<Tuple2<Object, Object>> asKeyValueIterator() {
            return new AbstractIterator<Tuple2<Object, Object>>(){
                private Tuple2<Object, Object> next;

                public boolean hasNext() {
                    if (this.next == null) {
                        this.next = this.tryComputeNext();
                    }
                    return this.next != null;
                }

                public Tuple2<Object, Object> next() {
                    if (this.next == null) {
                        this.next = this.tryComputeNext();
                    }
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                    Tuple2<Object, Object> result = this.next;
                    this.next = null;
                    return result;
                }

                private Tuple2<Object, Object> tryComputeNext() {
                    int length;
                    try {
                        length = inputStream.readInt();
                    }
                    catch (EOFException e) {
                        return null;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    if (bytes == null || bytes.length < length) {
                        PrestoSparkShuffleDeserializationStream.access$102(this, new byte[length]);
                        buffer = ByteBuffer.wrap(bytes);
                    }
                    try {
                        inputStream.readFully(bytes, 0, length);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    buffer.position(0);
                    buffer.limit(length);
                    row.setBuffer(buffer);
                    return tuple;
                }
            };
        }

        public <T> T readKey(ClassTag<T> classTag) {
            throw new UnsupportedOperationException("this method is never used by shuffle");
        }

        public <T> T readValue(ClassTag<T> classTag) {
            throw new UnsupportedOperationException("this method is never used by shuffle");
        }

        public Iterator<Object> asIterator() {
            throw new UnsupportedOperationException("this method is never used by shuffle");
        }

        public <T> T readObject(ClassTag<T> classTag) {
            throw new UnsupportedOperationException("this method is never used by shuffle");
        }

        public void close() {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        static /* synthetic */ byte[] access$102(PrestoSparkShuffleDeserializationStream x0, byte[] x1) {
            x0.bytes = x1;
            return x1;
        }
    }

    public static class PrestoSparkShuffleSerializationStream
    extends SerializationStream {
        private final DataOutputStream outputStream;

        public PrestoSparkShuffleSerializationStream(OutputStream outputStream) {
            this.outputStream = new DataOutputStream(Objects.requireNonNull(outputStream, "outputStream is null"));
        }

        public <T> SerializationStream writeKey(T key, ClassTag<T> classTag) {
            return this;
        }

        public <T> SerializationStream writeValue(T value, ClassTag<T> classTag) {
            PrestoSparkMutableRow row = (PrestoSparkMutableRow)value;
            ByteBuffer buffer = row.getBuffer();
            int length = buffer.remaining();
            try {
                this.outputStream.writeInt(length);
                this.outputStream.write(buffer.array(), buffer.arrayOffset() + buffer.position(), length);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return this;
        }

        public void flush() {
            try {
                this.outputStream.flush();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void close() {
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public <T> SerializationStream writeObject(T tuple, ClassTag<T> classTag) {
            throw new UnsupportedOperationException("this method is never used by shuffle");
        }

        public <T> SerializationStream writeAll(Iterator<T> iterator, ClassTag<T> classTag) {
            throw new UnsupportedOperationException("this method is never used by shuffle");
        }
    }

    public static class PrestoSparkShuffleSerializerInstance
    extends SerializerInstance {
        private final PrestoSparkMutableRow row = new PrestoSparkMutableRow();
        private final Tuple2<MutablePartitionId, PrestoSparkMutableRow> tuple = new Tuple2(null, (Object)this.row);

        public SerializationStream serializeStream(OutputStream outputStream) {
            return new PrestoSparkShuffleSerializationStream(outputStream);
        }

        public DeserializationStream deserializeStream(InputStream inputStream) {
            return new PrestoSparkShuffleDeserializationStream(inputStream);
        }

        public <T> ByteBuffer serialize(T input, ClassTag<T> classTag) {
            Tuple2 tuple = (Tuple2)input;
            PrestoSparkMutableRow row = (PrestoSparkMutableRow)tuple._2;
            return row.getBuffer();
        }

        public <T> T deserialize(ByteBuffer buffer, ClassTag<T> classTag) {
            throw new UnsupportedOperationException("this method is never used by shuffle");
        }

        public <T> T deserialize(byte[] array, int offset, int length, ClassTag<T> classTag) {
            this.row.setArray(array);
            this.row.setOffset(offset);
            this.row.setLength(length);
            return (T)this.tuple;
        }

        public <T> T deserialize(ByteBuffer bytes, ClassLoader loader, ClassTag<T> classTag) {
            throw new UnsupportedOperationException("this method is never used by shuffle");
        }
    }
}

