/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.classloader_interface;

import com.facebook.presto.spark.classloader_interface.SerializedPrestoSparkTaskSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.spark.InterruptibleIterator;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.ParallelCollectionPartition;
import org.apache.spark.rdd.RDD;
import scala.collection.Iterator;
import scala.collection.JavaConversions;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

public class PrestoSparkTaskSourceRdd
extends RDD<SerializedPrestoSparkTaskSource> {
    private List<List<SerializedPrestoSparkTaskSource>> taskSourcesByPartitionId;

    public PrestoSparkTaskSourceRdd(SparkContext sparkContext, List<List<SerializedPrestoSparkTaskSource>> taskSourcesByPartitionId) {
        super(sparkContext, JavaConversions.asScalaBuffer(Collections.emptyList()).toSeq(), PrestoSparkTaskSourceRdd.fakeClassTag());
        this.taskSourcesByPartitionId = Objects.requireNonNull(taskSourcesByPartitionId, "taskSourcesByPartitionId is null").stream().map(ArrayList::new).collect(Collectors.toList());
    }

    private static <T> ClassTag<T> fakeClassTag() {
        return ClassTag$.MODULE$.apply(SerializedPrestoSparkTaskSource.class);
    }

    public Partition[] getPartitions() {
        Partition[] partitions = new Partition[this.taskSourcesByPartitionId.size()];
        for (int partitionId = 0; partitionId < this.taskSourcesByPartitionId.size(); ++partitionId) {
            partitions[partitionId] = new ParallelCollectionPartition((long)this.id(), partitionId, JavaConversions.asScalaBuffer(this.taskSourcesByPartitionId.get(partitionId)).toSeq(), PrestoSparkTaskSourceRdd.fakeClassTag());
        }
        return partitions;
    }

    public Iterator<SerializedPrestoSparkTaskSource> compute(Partition partition, TaskContext context) {
        ParallelCollectionPartition parallelCollectionPartition = PrestoSparkTaskSourceRdd.toParallelCollectionPartition(partition);
        return new InterruptibleIterator(context, parallelCollectionPartition.iterator());
    }

    private static <T> ParallelCollectionPartition<T> toParallelCollectionPartition(Partition partition) {
        return (ParallelCollectionPartition)partition;
    }

    public void clearDependencies() {
        super.clearDependencies();
        this.taskSourcesByPartitionId = null;
    }
}

