/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.classloader_interface;

import com.facebook.presto.spark.classloader_interface.PrestoSparkRow;
import com.facebook.presto.spark.classloader_interface.PrestoSparkSerializedPage;
import com.facebook.presto.spark.classloader_interface.PrestoSparkTaskExecutorFactoryProvider;
import com.facebook.presto.spark.classloader_interface.PrestoSparkTaskInputs;
import com.facebook.presto.spark.classloader_interface.SerializedPrestoSparkTaskDescriptor;
import com.facebook.presto.spark.classloader_interface.SerializedTaskStats;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.spark.TaskContext;
import org.apache.spark.api.java.function.FlatMapFunction2;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.util.CollectionAccumulator;
import scala.Tuple2;

public class TaskProcessors {
    private TaskProcessors() {
    }

    public static PairFlatMapFunction<Iterator<SerializedPrestoSparkTaskDescriptor>, Integer, PrestoSparkRow> createTaskProcessor(final PrestoSparkTaskExecutorFactoryProvider taskExecutorFactoryProvider, final CollectionAccumulator<SerializedTaskStats> taskStatsCollector, final Map<String, Broadcast<List<PrestoSparkSerializedPage>>> broadcastInputs) {
        return new PairFlatMapFunction<Iterator<SerializedPrestoSparkTaskDescriptor>, Integer, PrestoSparkRow>(){

            public Iterator<Tuple2<Integer, PrestoSparkRow>> call(Iterator<SerializedPrestoSparkTaskDescriptor> serializedTaskRequestIterator) {
                SerializedPrestoSparkTaskDescriptor serializedTaskDescriptor = serializedTaskRequestIterator.next();
                if (serializedTaskRequestIterator.hasNext()) {
                    throw new IllegalArgumentException("each partition is expected to contain an exactly one task descriptor");
                }
                int partitionId = TaskContext.get().partitionId();
                int attemptNumber = TaskContext.get().attemptNumber();
                return taskExecutorFactoryProvider.get().create(partitionId, attemptNumber, serializedTaskDescriptor, new PrestoSparkTaskInputs(Collections.emptyMap(), broadcastInputs), (CollectionAccumulator<SerializedTaskStats>)taskStatsCollector);
            }
        };
    }

    public static PairFlatMapFunction<Iterator<Tuple2<Integer, PrestoSparkRow>>, Integer, PrestoSparkRow> createTaskProcessor(final PrestoSparkTaskExecutorFactoryProvider taskExecutorFactoryProvider, final SerializedPrestoSparkTaskDescriptor serializedTaskDescriptor, final String fragmentId, final CollectionAccumulator<SerializedTaskStats> taskStatsCollector, final Map<String, Broadcast<List<PrestoSparkSerializedPage>>> broadcastInputs) {
        return new PairFlatMapFunction<Iterator<Tuple2<Integer, PrestoSparkRow>>, Integer, PrestoSparkRow>(){

            public Iterator<Tuple2<Integer, PrestoSparkRow>> call(Iterator<Tuple2<Integer, PrestoSparkRow>> input) {
                int partitionId = TaskContext.get().partitionId();
                int attemptNumber = TaskContext.get().attemptNumber();
                return taskExecutorFactoryProvider.get().create(partitionId, attemptNumber, serializedTaskDescriptor, new PrestoSparkTaskInputs(Collections.singletonMap(fragmentId, input), broadcastInputs), (CollectionAccumulator<SerializedTaskStats>)taskStatsCollector);
            }
        };
    }

    public static FlatMapFunction2<Iterator<Tuple2<Integer, PrestoSparkRow>>, Iterator<Tuple2<Integer, PrestoSparkRow>>, Tuple2<Integer, PrestoSparkRow>> createTaskProcessor(final PrestoSparkTaskExecutorFactoryProvider taskExecutorFactoryProvider, final SerializedPrestoSparkTaskDescriptor serializedTaskDescriptor, final String fragmentId1, final String fragmentId2, final CollectionAccumulator<SerializedTaskStats> taskStatsCollector, final Map<String, Broadcast<List<PrestoSparkSerializedPage>>> broadcastInputs) {
        return new FlatMapFunction2<Iterator<Tuple2<Integer, PrestoSparkRow>>, Iterator<Tuple2<Integer, PrestoSparkRow>>, Tuple2<Integer, PrestoSparkRow>>(){

            public Iterator<Tuple2<Integer, PrestoSparkRow>> call(Iterator<Tuple2<Integer, PrestoSparkRow>> input1, Iterator<Tuple2<Integer, PrestoSparkRow>> input2) {
                int partitionId = TaskContext.get().partitionId();
                int attemptNumber = TaskContext.get().attemptNumber();
                HashMap<String, Iterator<Tuple2<Integer, PrestoSparkRow>>> inputsMap = new HashMap<String, Iterator<Tuple2<Integer, PrestoSparkRow>>>();
                inputsMap.put(fragmentId1, input1);
                inputsMap.put(fragmentId2, input2);
                return taskExecutorFactoryProvider.get().create(partitionId, attemptNumber, serializedTaskDescriptor, new PrestoSparkTaskInputs(Collections.unmodifiableMap(inputsMap), broadcastInputs), (CollectionAccumulator<SerializedTaskStats>)taskStatsCollector);
            }
        };
    }
}

