/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.util;

import com.facebook.airlift.json.Codec;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.BlockUtil;
import com.facebook.presto.spark.PrestoSparkServiceWaitTimeMetrics;
import com.facebook.presto.spark.classloader_interface.PrestoSparkSerializedPage;
import com.facebook.presto.spi.page.PageCompressor;
import com.facebook.presto.spi.page.PageDecompressor;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.page.SerializedPage;
import com.github.luben.zstd.Zstd;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.Duration;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.DeflaterInputStream;
import java.util.zip.InflaterOutputStream;
import org.apache.spark.JavaFutureActionWrapper;
import org.apache.spark.SimpleFutureAction;
import org.apache.spark.SparkException;
import org.apache.spark.api.java.JavaFutureAction;
import scala.Function1;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.AbstractFunction1;

public class PrestoSparkUtils {
    private static final int COMPRESSION_LEVEL = 3;

    private PrestoSparkUtils() {
    }

    public static PrestoSparkSerializedPage toPrestoSparkSerializedPage(SerializedPage serializedPage) {
        Slice slice = serializedPage.getSlice();
        Preconditions.checkArgument((boolean)slice.hasByteArray(), (Object)"slice is expected to be based on a byte array");
        return new PrestoSparkSerializedPage(BlockUtil.compactArray((byte[])slice.byteArray(), (int)slice.byteArrayOffset(), (int)slice.length()), serializedPage.getPositionCount(), serializedPage.getUncompressedSizeInBytes(), serializedPage.getPageCodecMarkers(), serializedPage.getChecksum());
    }

    public static SerializedPage toSerializedPage(PrestoSparkSerializedPage prestoSparkSerializedPage) {
        return new SerializedPage(Slices.wrappedBuffer((byte[])prestoSparkSerializedPage.getBytes()), prestoSparkSerializedPage.getPageCodecMarkers(), Math.toIntExact(prestoSparkSerializedPage.getPositionCount()), prestoSparkSerializedPage.getUncompressedSizeInBytes(), prestoSparkSerializedPage.getChecksum());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] compress(byte[] bytes) {
        try (DeflaterInputStream decompressor = new DeflaterInputStream(new ByteArrayInputStream(bytes));){
            byte[] byArray = ByteStreams.toByteArray((InputStream)decompressor);
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static byte[] decompress(byte[] bytes) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (InflaterOutputStream compressor = new InflaterOutputStream(output);){
            compressor.write(bytes);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return output.toByteArray();
    }

    /*
     * Exception decompiling
     */
    public static <T> byte[] serializeZstdCompressed(Codec<T> codec, T instance) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static <T> T deserializeZstdCompressed(Codec<T> codec, byte[] bytes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static PagesSerde createPagesSerde(BlockEncodingManager blockEncodingManager) {
        return new PagesSerde((BlockEncodingSerde)blockEncodingManager, Optional.of(PrestoSparkUtils.createPageCompressor()), Optional.of(PrestoSparkUtils.createPageDecompressor()), Optional.empty());
    }

    private static PageCompressor createPageCompressor() {
        return new PageCompressor(){

            public int maxCompressedLength(int uncompressedSize) {
                return Math.toIntExact(Zstd.compressBound((long)uncompressedSize));
            }

            public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
                long size = Zstd.compressByteArray((byte[])output, (int)outputOffset, (int)maxOutputLength, (byte[])input, (int)inputOffset, (int)inputLength, (int)3);
                if (Zstd.isError((long)size)) {
                    throw new RuntimeException(Zstd.getErrorName((long)size));
                }
                return Math.toIntExact(size);
            }

            public void compress(ByteBuffer input, ByteBuffer output) {
                if (input.isDirect() || output.isDirect() || !input.hasArray() || !output.hasArray()) {
                    throw new IllegalArgumentException("Non-direct byte buffer backed by byte array required");
                }
                int inputOffset = input.arrayOffset() + input.position();
                int outputOffset = output.arrayOffset() + output.position();
                int written = this.compress(input.array(), inputOffset, input.remaining(), output.array(), outputOffset, output.remaining());
                ((Buffer)output).position(output.position() + written);
            }
        };
    }

    private static PageDecompressor createPageDecompressor() {
        return new PageDecompressor(){

            public int decompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
                long size = Zstd.decompressByteArray((byte[])output, (int)0, (int)maxOutputLength, (byte[])input, (int)inputOffset, (int)inputLength);
                if (Zstd.isError((long)size)) {
                    String errorName = Zstd.getErrorName((long)size);
                    throw new RuntimeException("Zstd JNI decompressor failed with " + errorName);
                }
                return Math.toIntExact(size);
            }

            public void decompress(ByteBuffer input, ByteBuffer output) {
                if (input.isDirect() || output.isDirect() || !input.hasArray() || !output.hasArray()) {
                    throw new IllegalArgumentException("Non-direct byte buffer backed by byte array required");
                }
                int inputOffset = input.arrayOffset() + input.position();
                int outputOffset = output.arrayOffset() + output.position();
                int written = this.decompress(input.array(), inputOffset, input.remaining(), output.array(), outputOffset, output.remaining());
                ((Buffer)output).position(output.position() + written);
            }
        };
    }

    public static long computeNextTimeout(long queryCompletionDeadline) {
        return queryCompletionDeadline - System.currentTimeMillis();
    }

    public static <T> T getActionResultWithTimeout(JavaFutureAction<T> action, long timeout, TimeUnit timeUnit, Set<PrestoSparkServiceWaitTimeMetrics> waitTimeMetrics) throws SparkException, TimeoutException {
        long deadline = System.currentTimeMillis() + timeUnit.toMillis(timeout);
        while (true) {
            Object object;
            long totalWaitTime = waitTimeMetrics.stream().map(PrestoSparkServiceWaitTimeMetrics::getWaitTime).mapToLong(Duration::toMillis).sum();
            long nextTimeoutInMillis = deadline + totalWaitTime - System.currentTimeMillis();
            if (nextTimeoutInMillis <= 0L) {
                throw new TimeoutException();
            }
            try {
                object = action.get(nextTimeoutInMillis, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                try {
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    Throwables.propagateIfPossible((Throwable)e.getCause(), SparkException.class);
                    Throwables.propagateIfPossible((Throwable)e.getCause(), RuntimeException.class);
                    throw new UncheckedExecutionException(e.getCause());
                }
            }
            return (T)object;
        }
        finally {
            if (!action.isDone()) {
                action.cancel(true);
            }
        }
    }

    public static <T> T getActionResultWithTimeout(SimpleFutureAction<T> action, long timeout, TimeUnit timeUnit, Set<PrestoSparkServiceWaitTimeMetrics> waitTimeMetrics) throws SparkException, TimeoutException {
        JavaFutureActionWrapper javaFutureAction = new JavaFutureActionWrapper(action, (Function1)new AbstractFunction1<T, T>(){

            public T apply(T v) {
                return v;
            }
        });
        return PrestoSparkUtils.getActionResultWithTimeout(javaFutureAction, timeout, timeUnit, waitTimeMetrics);
    }

    public static <T> ClassTag<T> classTag(Class<T> clazz) {
        return ClassTag$.MODULE$.apply(clazz);
    }

    public static <T> Iterator<T> getNullifyingIterator(final List<T> list) {
        return new AbstractIterator<T>(){
            private int index;

            protected T computeNext() {
                if (this.index >= list.size()) {
                    return this.endOfData();
                }
                Object element = list.get(this.index);
                list.set(this.index, null);
                ++this.index;
                return element;
            }
        };
    }
}

