/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.util;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.RuntimeMetric;
import com.facebook.presto.common.RuntimeUnit;
import com.facebook.presto.execution.TaskInfo;
import java.util.concurrent.TimeUnit;
import org.apache.commons.text.CaseUtils;
import org.apache.spark.TaskContext;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.util.AccumulatorV2;
import scala.Option;

public class PrestoSparkStatsCollectionUtils {
    public static final String SPARK_INTERNAL_ACCUMULATOR_PREFIX = "internal.metrics.";
    public static final String PRESTO_NATIVE_OPERATOR_STATS_SEP = "internal";
    public static final String PRESTO_NATIVE_OPERATOR_STATS_PREFIX = "velox.";
    private static final Logger log = Logger.get(PrestoSparkStatsCollectionUtils.class);

    private PrestoSparkStatsCollectionUtils() {
    }

    public static void collectMetrics(TaskInfo taskInfo) {
        if (taskInfo == null || taskInfo.getStats() == null) {
            return;
        }
        try {
            taskInfo.getStats().getRuntimeStats().getMetrics().forEach(PrestoSparkStatsCollectionUtils::incSparkInternalAccumulator);
        }
        catch (Exception e) {
            log.warn((Throwable)e, "An error occurred while updating Spark Internal metrics for task=%s", new Object[]{taskInfo});
        }
    }

    static void incSparkInternalAccumulator(String prestoKey, RuntimeMetric metric) {
        TaskContext taskContext = TaskContext.get();
        if (taskContext == null) {
            return;
        }
        TaskMetrics sparkTaskMetrics = taskContext.taskMetrics();
        if (sparkTaskMetrics == null) {
            return;
        }
        String sparkInternalAccumulatorName = PrestoSparkStatsCollectionUtils.getSparkInternalAccumulatorKey(prestoKey);
        Option accumulatorV2Optional = sparkTaskMetrics.nameToAccums().get((Object)sparkInternalAccumulatorName);
        if (accumulatorV2Optional.isEmpty()) {
            return;
        }
        AccumulatorV2 accumulatorV2 = (AccumulatorV2)accumulatorV2Optional.get();
        accumulatorV2.add((Object)PrestoSparkStatsCollectionUtils.getMetricLongValue(metric, sparkInternalAccumulatorName.contains("Ms")));
    }

    static String getSparkInternalAccumulatorKey(String prestoKey) {
        if (prestoKey.contains(SPARK_INTERNAL_ACCUMULATOR_PREFIX)) {
            int index = prestoKey.indexOf(PRESTO_NATIVE_OPERATOR_STATS_SEP);
            return prestoKey.substring(index);
        }
        String[] prestoKeyParts = prestoKey.split("\\.");
        int prestoKeyPartsLength = prestoKeyParts.length;
        if (prestoKeyPartsLength < 2) {
            log.debug("Fail to build spark internal key for %s format not supported", new Object[]{prestoKey});
            return "";
        }
        String prestoNewKey = String.format("%1$s%2$s", prestoKeyParts[0], prestoKeyParts[prestoKeyPartsLength - 1]);
        if (prestoNewKey.contains("_")) {
            prestoNewKey = CaseUtils.toCamelCase((String)prestoKey, (boolean)false, (char[])new char[]{'_'});
        }
        return String.format("%1$s%2$s%3$s", SPARK_INTERNAL_ACCUMULATOR_PREFIX, PRESTO_NATIVE_OPERATOR_STATS_PREFIX, prestoNewKey);
    }

    static long getMetricLongValue(RuntimeMetric metric, boolean isSparkUnitMs) {
        long sum = metric.getSum();
        if (metric.getUnit().equals((Object)RuntimeUnit.NANO) && isSparkUnitMs) {
            sum = TimeUnit.NANOSECONDS.toMillis(sum);
        }
        return sum;
    }
}

