/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.util;

import com.facebook.presto.Session;
import com.facebook.presto.common.ErrorCode;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.spark.PrestoSparkSessionProperties;
import com.facebook.presto.spark.SparkErrorCode;
import com.facebook.presto.spark.classloader_interface.ExecutionStrategy;
import com.facebook.presto.spark.classloader_interface.PrestoSparkFailure;
import com.facebook.presto.spi.ErrorCause;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class PrestoSparkFailureUtils {
    private PrestoSparkFailureUtils() {
    }

    public static PrestoSparkFailure toPrestoSparkFailure(Session session, ExecutionFailureInfo executionFailureInfo) {
        Objects.requireNonNull(executionFailureInfo, "executionFailureInfo is null");
        PrestoSparkFailure prestoSparkFailure = PrestoSparkFailureUtils.toPrestoSparkFailure(executionFailureInfo);
        Preconditions.checkState((prestoSparkFailure != null ? 1 : 0) != 0);
        List<ExecutionStrategy> retryExecutionStrategies = PrestoSparkFailureUtils.getRetryExecutionStrategies(session, executionFailureInfo.getErrorCode(), executionFailureInfo.getMessage(), executionFailureInfo.getErrorCause());
        return new PrestoSparkFailure(prestoSparkFailure.getMessage(), prestoSparkFailure.getCause(), prestoSparkFailure.getType(), prestoSparkFailure.getErrorCode(), retryExecutionStrategies);
    }

    @Nullable
    private static PrestoSparkFailure toPrestoSparkFailure(ExecutionFailureInfo executionFailureInfo) {
        if (executionFailureInfo == null) {
            return null;
        }
        PrestoSparkFailure prestoSparkFailure = new PrestoSparkFailure(executionFailureInfo.getMessage(), (Throwable)PrestoSparkFailureUtils.toPrestoSparkFailure(executionFailureInfo.getCause()), executionFailureInfo.getType(), executionFailureInfo.getErrorCode() == null ? "" : executionFailureInfo.getErrorCode().getName(), (List)ImmutableList.of());
        for (Object suppressed : executionFailureInfo.getSuppressed()) {
            prestoSparkFailure.addSuppressed((Throwable)Objects.requireNonNull(PrestoSparkFailureUtils.toPrestoSparkFailure((ExecutionFailureInfo)suppressed), "suppressed failure is null"));
        }
        ImmutableList.Builder stackTraceBuilder = ImmutableList.builder();
        for (String stack : executionFailureInfo.getStack()) {
            stackTraceBuilder.add((Object)ExecutionFailureInfo.toStackTraceElement((String)stack));
        }
        ImmutableList stackTrace = stackTraceBuilder.build();
        prestoSparkFailure.setStackTrace(stackTrace.toArray(new StackTraceElement[stackTrace.size()]));
        return prestoSparkFailure;
    }

    private static List<ExecutionStrategy> getRetryExecutionStrategies(Session session, ErrorCode errorCode, String message, ErrorCause errorCause) {
        if (errorCode == null || message == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder strategies = new ImmutableList.Builder();
        if (PrestoSparkSessionProperties.isRetryOnOutOfMemoryBroadcastJoinEnabled(session) && errorCode.equals((Object)StandardErrorCode.EXCEEDED_LOCAL_BROADCAST_JOIN_MEMORY_LIMIT.toErrorCode())) {
            strategies.add((Object)ExecutionStrategy.DISABLE_BROADCAST_JOIN);
        }
        if (PrestoSparkSessionProperties.isRetryOnOutOfMemoryWithIncreasedMemoryEnabled(session) && (errorCode.equals((Object)StandardErrorCode.EXCEEDED_LOCAL_MEMORY_LIMIT.toErrorCode()) || errorCode.equals((Object)SparkErrorCode.SPARK_EXECUTOR_OOM.toErrorCode()))) {
            strategies.add((Object)ExecutionStrategy.INCREASE_CONTAINER_SIZE);
        }
        if (PrestoSparkSessionProperties.isRetryOnOutOfMemoryWithHigherHashPartitionCountEnabled(session) && ErrorCause.LOW_PARTITION_COUNT == errorCause) {
            strategies.add((Object)ExecutionStrategy.INCREASE_HASH_PARTITION_COUNT);
        }
        return strategies.build();
    }
}

