/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.util;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.spark.PrestoSparkExecutionSettings;
import com.facebook.presto.spark.PrestoSparkSessionContext;
import com.facebook.presto.spark.PrestoSparkSessionProperties;
import com.facebook.presto.spark.classloader_interface.ExecutionStrategy;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class PrestoSparkExecutionUtils {
    private static final Logger log = Logger.get(PrestoSparkSessionContext.class);

    private PrestoSparkExecutionUtils() {
    }

    public static PrestoSparkExecutionSettings getExecutionSettings(List<ExecutionStrategy> executionStrategies, Session session) {
        ImmutableMap.Builder sparkConfigProperties = new ImmutableMap.Builder();
        ImmutableMap.Builder prestoSessionProperties = new ImmutableMap.Builder();
        block5: for (ExecutionStrategy strategy : executionStrategies) {
            log.info(String.format("Applying execution strategy: %s. Query Id: %s", strategy.name(), session.getQueryId().getId()));
            switch (strategy) {
                case DISABLE_BROADCAST_JOIN: {
                    prestoSessionProperties.put((Object)"join_distribution_type", (Object)FeaturesConfig.JoinDistributionType.PARTITIONED.name());
                    continue block5;
                }
                case INCREASE_CONTAINER_SIZE: {
                    sparkConfigProperties.putAll(PrestoSparkSessionProperties.getOutOfMemoryRetrySparkConfigs(session));
                    prestoSessionProperties.putAll(PrestoSparkSessionProperties.getOutOfMemoryRetryPrestoSessionProperties(session));
                    continue block5;
                }
                case INCREASE_HASH_PARTITION_COUNT: {
                    long updatedPartitionCount = Math.round((double)SystemSessionProperties.getHashPartitionCount((Session)session) * PrestoSparkSessionProperties.getHashPartitionCountScalingFactorOnOutOfMemory(session));
                    prestoSessionProperties.put((Object)"hash_partition_count", (Object)Long.toString(updatedPartitionCount));
                    continue block5;
                }
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_RETRY_EXECUTION_STRATEGY, "Execution strategy not supported: " + executionStrategies);
        }
        return new PrestoSparkExecutionSettings((Map<String, String>)sparkConfigProperties.build(), (Map<String, String>)prestoSessionProperties.build());
    }
}

