/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.planner.optimizers;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spark.PrestoSparkSessionProperties;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.JoinSwappingUtils;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import java.util.Objects;
import java.util.Optional;

public class PickJoinSides
implements Rule<JoinNode> {
    private static final Pattern<JoinNode> PATTERN = Patterns.join().matching(joinNode -> joinNode.getDistributionType().isPresent() && joinNode.getDistributionType().get() == JoinNode.DistributionType.PARTITIONED && (!joinNode.getCriteria().isEmpty() || joinNode.getType() != JoinNode.Type.LEFT && joinNode.getType() != JoinNode.Type.RIGHT));
    private Metadata metadata;
    private SqlParser sqlParser;

    public PickJoinSides(Metadata metadata, SqlParser sqlParser) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
    }

    public Pattern<JoinNode> getPattern() {
        return PATTERN;
    }

    public boolean isEnabled(Session session) {
        return PrestoSparkSessionProperties.isAdaptiveJoinSideSwitchingEnabled(session);
    }

    public Rule.Result apply(JoinNode joinNode, Captures captures, Rule.Context context) {
        StatsProvider statsProvider = context.getStatsProvider();
        double leftSize = statsProvider.getStats(joinNode.getLeft()).getOutputSizeInBytes();
        double rightSize = statsProvider.getStats(joinNode.getRight()).getOutputSizeInBytes();
        Optional rewrittenNode = Optional.empty();
        if (rightSize > leftSize || SystemSessionProperties.isSizeBasedJoinDistributionTypeEnabled((Session)context.getSession()) && (Double.isNaN(leftSize) || Double.isNaN(rightSize)) && this.isLeftSideSmall(joinNode, context)) {
            rewrittenNode = JoinSwappingUtils.createRuntimeSwappedJoinNode((JoinNode)joinNode, (Metadata)this.metadata, (SqlParser)this.sqlParser, (Lookup)context.getLookup(), (Session)context.getSession(), (VariableAllocator)context.getVariableAllocator(), (PlanNodeIdAllocator)context.getIdAllocator());
        }
        return rewrittenNode.map(Rule.Result::ofPlanNode).orElseGet(Rule.Result::empty);
    }

    private boolean isLeftSideSmall(JoinNode joinNode, Rule.Context context) {
        boolean isRightSideSmall = JoinSwappingUtils.isBelowBroadcastLimit((PlanNode)joinNode.getRight(), (Rule.Context)context);
        boolean isLeftSideSmall = JoinSwappingUtils.isBelowBroadcastLimit((PlanNode)joinNode.getLeft(), (Rule.Context)context);
        if (isLeftSideSmall && !isRightSideSmall) {
            return true;
        }
        return JoinSwappingUtils.isSmallerThanThreshold((PlanNode)joinNode.getLeft(), (PlanNode)joinNode.getRight(), (Rule.Context)context);
    }
}

