/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.planner.optimizers;

import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spark.planner.optimizers.PickJoinSides;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.OptimizerStatsRecorder;
import com.facebook.presto.sql.planner.RuleStatsRecorder;
import com.facebook.presto.sql.planner.iterative.IterativeOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.weakref.jmx.MBeanExporter;

public class AdaptivePlanOptimizers {
    private final List<PlanOptimizer> adaptiveOptimizers;
    private final RuleStatsRecorder ruleStats = new RuleStatsRecorder();
    private final OptimizerStatsRecorder optimizerStats = new OptimizerStatsRecorder();
    private final MBeanExporter exporter;

    @Inject
    public AdaptivePlanOptimizers(MBeanExporter exporter, Metadata metadata, SqlParser sqlParser, StatsCalculator statsCalculator, CostCalculator costCalculator) {
        this.exporter = exporter;
        this.adaptiveOptimizers = ImmutableList.of((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, costCalculator, (Set)ImmutableSet.of((Object)new PickJoinSides(metadata, sqlParser))));
    }

    @PostConstruct
    public void initialize() {
        this.ruleStats.export(this.exporter);
        this.optimizerStats.export(this.exporter);
    }

    @PreDestroy
    public void destroy() {
        this.ruleStats.unexport(this.exporter);
        this.optimizerStats.unexport(this.exporter);
    }

    public List<PlanOptimizer> getAdaptiveOptimizers() {
        return this.adaptiveOptimizers;
    }
}

