/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.planner;

import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.presto.cost.ComposableStatsCalculator;
import com.facebook.presto.cost.FilterStatsCalculator;
import com.facebook.presto.cost.FragmentStatsProvider;
import com.facebook.presto.cost.HistoryBasedOptimizationConfig;
import com.facebook.presto.cost.HistoryBasedPlanStatisticsManager;
import com.facebook.presto.cost.ScalarStatsCalculator;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.cost.StatsCalculatorModule;
import com.facebook.presto.cost.StatsNormalizer;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spark.planner.PrestoSparkStatsCalculator;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import javax.inject.Singleton;

public class PrestoSparkStatsCalculatorModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(ScalarStatsCalculator.class).in(Scopes.SINGLETON);
        binder.bind(StatsNormalizer.class).in(Scopes.SINGLETON);
        binder.bind(FilterStatsCalculator.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(HistoryBasedOptimizationConfig.class);
        binder.bind(HistoryBasedPlanStatisticsManager.class).in(Scopes.SINGLETON);
        binder.bind(FragmentStatsProvider.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public static StatsCalculator createNewStatsCalculator(Metadata metadata, ScalarStatsCalculator scalarStatsCalculator, StatsNormalizer normalizer, FilterStatsCalculator filterStatsCalculator, FragmentStatsProvider fragmentStatsProvider, HistoryBasedPlanStatisticsManager historyBasedPlanStatisticsManager, HistoryBasedOptimizationConfig historyBasedOptimizationConfig) {
        ComposableStatsCalculator delegate = StatsCalculatorModule.createComposableStatsCalculator((Metadata)metadata, (ScalarStatsCalculator)scalarStatsCalculator, (StatsNormalizer)normalizer, (FilterStatsCalculator)filterStatsCalculator, (FragmentStatsProvider)fragmentStatsProvider);
        return new PrestoSparkStatsCalculator(historyBasedPlanStatisticsManager.getHistoryBasedPlanStatisticsCalculator((StatsCalculator)delegate), (StatsCalculator)delegate, historyBasedOptimizationConfig);
    }
}

