/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.planner;

import com.facebook.presto.Session;
import com.facebook.presto.cost.HistoricalPlanStatisticsUtil;
import com.facebook.presto.cost.HistoryBasedOptimizationConfig;
import com.facebook.presto.cost.HistoryBasedPlanStatisticsCalculator;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.statistics.HistoryBasedSourceInfo;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import java.util.List;
import java.util.Objects;

public class PrestoSparkStatsCalculator
implements StatsCalculator {
    private final HistoryBasedPlanStatisticsCalculator historyBasedPlanStatisticsCalculator;
    private final StatsCalculator delegate;
    private final HistoryBasedOptimizationConfig historyBasedOptimizationConfig;

    public PrestoSparkStatsCalculator(HistoryBasedPlanStatisticsCalculator historyBasedPlanStatisticsCalculator, StatsCalculator delegate, HistoryBasedOptimizationConfig historyBasedOptimizationConfig) {
        this.historyBasedPlanStatisticsCalculator = Objects.requireNonNull(historyBasedPlanStatisticsCalculator, "historyBasedPlanStatisticsCalculator is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.historyBasedOptimizationConfig = Objects.requireNonNull(historyBasedOptimizationConfig, "historyBasedOptimizationConfig");
    }

    public PlanNodeStatsEstimate calculateStats(PlanNode node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types) {
        boolean shouldUseHistoricalStats = this.shouldUseHistoricalStats(node, sourceStats, lookup, session, types);
        if (shouldUseHistoricalStats) {
            return this.historyBasedPlanStatisticsCalculator.calculateStats(node, sourceStats, lookup, session, types);
        }
        return this.delegate.calculateStats(node, sourceStats, lookup, session, types);
    }

    private boolean shouldUseHistoricalStats(PlanNode node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types) {
        List remoteSourceNodes = PlanNodeSearcher.searchFrom((PlanNode)node, (Lookup)lookup).where(RemoteSourceNode.class::isInstance).findAll();
        for (RemoteSourceNode remoteSourceNode : remoteSourceNodes) {
            PlanNodeStatsEstimate historicalStats = this.historyBasedPlanStatisticsCalculator.calculateStats((PlanNode)remoteSourceNode, sourceStats, lookup, session, types);
            PlanNodeStatsEstimate runtimeStats = this.delegate.calculateStats((PlanNode)remoteSourceNode, sourceStats, lookup, session, types);
            if (runtimeStats.isTotalSizeUnknown() || historicalStats.getSourceInfo() instanceof HistoryBasedSourceInfo && HistoricalPlanStatisticsUtil.similarStats((double)historicalStats.getTotalSize(), (double)runtimeStats.getTotalSize(), (double)this.historyBasedOptimizationConfig.getHistoryMatchingThreshold())) continue;
            return false;
        }
        return true;
    }

    public boolean registerPlan(PlanNode root, Session session, long startTimeInNano, long timeoutInMilliseconds) {
        return this.historyBasedPlanStatisticsCalculator.registerPlan(root, session, startTimeInNano, timeoutInMilliseconds);
    }

    public HistoryBasedPlanStatisticsCalculator getHistoryBasedPlanStatisticsCalculator() {
        return this.historyBasedPlanStatisticsCalculator;
    }
}

