/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution.task;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.http.client.HttpStatus;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.server.RequestErrorTracker;
import com.facebook.presto.server.smile.BaseResponse;
import com.facebook.presto.spark.execution.http.PrestoSparkHttpTaskClient;
import com.facebook.presto.spark.execution.nativeprocess.HttpNativeExecutionTaskInfoFetcher;
import com.facebook.presto.spark.execution.nativeprocess.HttpNativeExecutionTaskResultFetcher;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoTransportException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.spi.security.TokenAuthenticator;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PlanFragment;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;

public class NativeExecutionTask {
    private static final Logger log = Logger.get(NativeExecutionTask.class);
    private final Session session;
    private final PlanFragment planFragment;
    private final OutputBuffers outputBuffers;
    private final PrestoSparkHttpTaskClient workerClient;
    private final TableWriteInfo tableWriteInfo;
    private final Optional<String> shuffleWriteInfo;
    private final Optional<String> broadcastBasePath;
    private final List<TaskSource> sources;
    private final Executor executor;
    private final ScheduledExecutorService errorRetryScheduledExecutor;
    private final Duration remoteTaskMaxErrorDuration;
    private final HttpNativeExecutionTaskInfoFetcher taskInfoFetcher;
    private final Optional<HttpNativeExecutionTaskResultFetcher> taskResultFetcher;
    private final Object taskFinishedOrHasResult = new Object();
    private Optional<TokenAuthenticator> tokenAuthenticator;

    public NativeExecutionTask(Session session, PrestoSparkHttpTaskClient workerClient, PlanFragment planFragment, List<TaskSource> sources, TableWriteInfo tableWriteInfo, Optional<String> shuffleWriteInfo, Optional<String> broadcastBasePath, Executor executor, ScheduledExecutorService updateScheduledExecutor, ScheduledExecutorService errorRetryScheduledExecutor, TaskManagerConfig taskManagerConfig, QueryManagerConfig queryManagerConfig) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.planFragment = Objects.requireNonNull(planFragment, "planFragment is null");
        this.tableWriteInfo = Objects.requireNonNull(tableWriteInfo, "tableWriteInfo is null");
        this.shuffleWriteInfo = Objects.requireNonNull(shuffleWriteInfo, "shuffleWriteInfo is null");
        this.broadcastBasePath = Objects.requireNonNull(broadcastBasePath, "broadcastBasePath is null");
        this.sources = Objects.requireNonNull(sources, "sources is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.errorRetryScheduledExecutor = Objects.requireNonNull(errorRetryScheduledExecutor, "errorRetryScheduledExecutor is null");
        this.workerClient = Objects.requireNonNull(workerClient, "workerClient is null");
        this.outputBuffers = OutputBuffers.createInitialEmptyOutputBuffers((PartitioningHandle)planFragment.getPartitioningScheme().getPartitioning().getHandle()).withNoMoreBufferIds();
        Objects.requireNonNull(taskManagerConfig, "taskManagerConfig is null");
        Objects.requireNonNull(updateScheduledExecutor, "updateScheduledExecutor is null");
        Objects.requireNonNull(errorRetryScheduledExecutor, "errorRetryScheduledExecutor is null");
        this.remoteTaskMaxErrorDuration = queryManagerConfig.getRemoteTaskMaxErrorDuration();
        this.taskInfoFetcher = new HttpNativeExecutionTaskInfoFetcher(updateScheduledExecutor, errorRetryScheduledExecutor, this.workerClient, this.executor, taskManagerConfig.getInfoUpdateInterval(), this.remoteTaskMaxErrorDuration, this.taskFinishedOrHasResult);
        this.taskResultFetcher = !shuffleWriteInfo.isPresent() ? Optional.of(new HttpNativeExecutionTaskResultFetcher(updateScheduledExecutor, errorRetryScheduledExecutor, this.workerClient, this.executor, this.remoteTaskMaxErrorDuration, this.taskFinishedOrHasResult)) : Optional.empty();
    }

    public Optional<TaskInfo> getTaskInfo() throws RuntimeException {
        return this.taskInfoFetcher.getTaskInfo();
    }

    public boolean isTaskDone() {
        Optional<TaskInfo> taskInfo = this.getTaskInfo();
        return taskInfo.isPresent() && taskInfo.get().getTaskStatus().getState().isDone();
    }

    public Object getTaskFinishedOrHasResult() {
        return this.taskFinishedOrHasResult;
    }

    public Optional<SerializedPage> pollResult() throws InterruptedException {
        if (!this.taskResultFetcher.isPresent()) {
            return Optional.empty();
        }
        return this.taskResultFetcher.get().pollPage();
    }

    public boolean hasResult() {
        return this.taskResultFetcher.isPresent() && this.taskResultFetcher.get().hasPage();
    }

    public TaskInfo start() {
        TaskInfo taskInfo = this.sendUpdateRequest();
        if (!ImmutableList.of((Object)TaskState.CANCELED, (Object)TaskState.FAILED, (Object)TaskState.ABORTED).contains((Object)taskInfo.getTaskStatus().getState())) {
            log.info("Starting TaskInfoFetcher and TaskResultFetcher.");
            this.taskResultFetcher.ifPresent(fetcher -> fetcher.start());
            this.taskInfoFetcher.start();
        }
        return taskInfo;
    }

    public void stop(boolean success) {
        this.taskInfoFetcher.stop();
        this.taskResultFetcher.ifPresent(fetcher -> fetcher.stop(success));
        this.workerClient.abortResults();
    }

    private TaskInfo sendUpdateRequest() {
        RequestErrorTracker errorTracker = new RequestErrorTracker((Object)"NativeExecution", this.workerClient.getLocation(), (ErrorCodeSupplier)StandardErrorCode.NATIVE_EXECUTION_TASK_ERROR, "sendUpdateRequest encountered too many errors talking to native process", this.remoteTaskMaxErrorDuration, this.errorRetryScheduledExecutor, "sending update request to native process");
        while (true) {
            MoreFutures.getFutureValue((Future)errorTracker.acquireRequestPermit());
            try {
                errorTracker.startRequest();
                BaseResponse<TaskInfo> response = this.doSendUpdateRequest();
                errorTracker.requestSucceeded();
                if (response.hasValue()) {
                    return (TaskInfo)response.getValue();
                }
                String message = String.format("Create-or-update task request didn't return a result. %s: %s", HttpStatus.fromStatusCode((int)response.getStatusCode()), response.getStatusMessage());
                throw new IllegalStateException(message);
            }
            catch (RuntimeException e) {
                errorTracker.requestFailed((Throwable)e);
                continue;
            }
            break;
        }
    }

    private BaseResponse<TaskInfo> doSendUpdateRequest() {
        return this.workerClient.updateTask(this.sources, this.planFragment, this.tableWriteInfo, this.shuffleWriteInfo, this.broadcastBasePath, this.session, this.outputBuffers);
    }

    public static boolean isNativeExecutionTaskError(RuntimeException ex) {
        return ex instanceof PrestoTransportException;
    }
}

