/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution.shuffle;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.Session;
import com.facebook.presto.spark.classloader_interface.PrestoSparkShuffleReadDescriptor;
import com.facebook.presto.spark.classloader_interface.PrestoSparkShuffleWriteDescriptor;
import com.facebook.presto.spark.execution.shuffle.PrestoSparkLocalShuffleReadInfo;
import com.facebook.presto.spark.execution.shuffle.PrestoSparkLocalShuffleWriteInfo;
import com.facebook.presto.spark.execution.shuffle.PrestoSparkShuffleInfoTranslator;
import com.facebook.presto.spark.execution.shuffle.PrestoSparkShuffleReadInfo;
import com.facebook.presto.spark.execution.shuffle.PrestoSparkShuffleWriteInfo;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;

public class PrestoSparkLocalShuffleInfoTranslator
implements PrestoSparkShuffleInfoTranslator {
    private final String localShuffleRootPath;
    private final JsonCodec<PrestoSparkLocalShuffleReadInfo> readInfoJsonCodec;
    private final JsonCodec<PrestoSparkLocalShuffleWriteInfo> writeInfoJsonCodec;

    @Inject
    public PrestoSparkLocalShuffleInfoTranslator(JsonCodec<PrestoSparkLocalShuffleReadInfo> readInfoJsonCodec, JsonCodec<PrestoSparkLocalShuffleWriteInfo> writeInfoJsonCodec) {
        try {
            this.localShuffleRootPath = Files.createTempDirectory("local_shuffle", new FileAttribute[0]).toAbsolutePath().toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error creating temporary directory 'local_shuffle'.", e);
        }
        this.readInfoJsonCodec = Objects.requireNonNull(readInfoJsonCodec, "readInfoJsonCodec is null");
        this.writeInfoJsonCodec = Objects.requireNonNull(writeInfoJsonCodec, "writeInfoJsonCodec is null");
    }

    @Override
    public PrestoSparkLocalShuffleWriteInfo createShuffleWriteInfo(Session session, PrestoSparkShuffleWriteDescriptor writeDescriptor) {
        return new PrestoSparkLocalShuffleWriteInfo(writeDescriptor.getNumPartitions(), session.getQueryId().getId(), writeDescriptor.getShuffleHandle().shuffleId(), this.localShuffleRootPath);
    }

    @Override
    public PrestoSparkLocalShuffleReadInfo createShuffleReadInfo(Session session, PrestoSparkShuffleReadDescriptor readDescriptor) {
        return new PrestoSparkLocalShuffleReadInfo(session.getQueryId().getId(), readDescriptor.getPartitionIds(), this.localShuffleRootPath);
    }

    @Override
    public String createSerializedWriteInfo(PrestoSparkShuffleWriteInfo writeInfo) {
        return this.writeInfoJsonCodec.toJson((Object)((PrestoSparkLocalShuffleWriteInfo)writeInfo));
    }

    @Override
    public String createSerializedReadInfo(PrestoSparkShuffleReadInfo readInfo) {
        return this.readInfoJsonCodec.toJson((Object)((PrestoSparkLocalShuffleReadInfo)readInfo));
    }
}

