/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution.property;

import com.facebook.airlift.configuration.Config;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.util.Map;
import java.util.Objects;

public class NativeExecutionSystemConfig {
    private static final String CONCURRENT_LIFESPANS_PER_TASK = "concurrent-lifespans-per-task";
    private static final String ENABLE_SERIALIZED_PAGE_CHECKSUM = "enable-serialized-page-checksum";
    private static final String ENABLE_VELOX_EXPRESSION_LOGGING = "enable_velox_expression_logging";
    private static final String ENABLE_VELOX_TASK_LOGGING = "enable_velox_task_logging";
    private static final String HTTP_SERVER_HTTP_PORT = "http-server.http.port";
    private static final String HTTP_SERVER_REUSE_PORT = "http-server.reuse-port";
    private static final String REGISTER_TEST_FUNCTIONS = "register-test-functions";
    private static final String HTTP_SERVER_HTTPS_PORT = "http-server.https.port";
    private static final String HTTP_SERVER_HTTPS_ENABLED = "http-server.https.enabled";
    private static final String HTTPS_CIPHERS = "https-supported-ciphers";
    private static final String HTTPS_CERT_PATH = "https-cert-path";
    private static final String HTTPS_KEY_PATH = "https-key-path";
    private static final String HTTP_EXEC_THREADS = "http_exec_threads";
    private static final String NUM_IO_THREADS = "num-io-threads";
    private static final String ASYNC_DATA_CACHE_ENABLED = "async-data-cache-enabled";
    private static final String ASYNC_CACHE_SSD_GB = "async-cache-ssd-gb";
    private static final String NUM_CONNECTOR_IO_THREADS = "num-connector-io-threads";
    private static final String PRESTO_VERSION = "presto.version";
    private static final String SHUTDOWN_ONSET_SEC = "shutdown-onset-sec";
    private static final String SYSTEM_MEMORY_GB = "system-memory-gb";
    private static final String QUERY_MEMORY_GB = "query.max-memory-per-node";
    private static final String USE_MMAP_ALLOCATOR = "use-mmap-allocator";
    private static final String MEMORY_ARBITRATOR_KIND = "memory-arbitrator-kind";
    private static final String MEMORY_ARBITRATOR_CAPACITY_GB = "query-memory-gb";
    private static final String MEMORY_POOL_INIT_CAPACITY = "memory-pool-init-capacity";
    private static final String MEMORY_POOL_TRANSFER_CAPACITY = "memory-pool-transfer-capacity";
    private static final String SPILLER_SPILL_PATH = "experimental.spiller-spill-path";
    private static final String TASK_MAX_DRIVERS_PER_TASK = "task.max-drivers-per-task";
    private static final String ENABLE_OLD_TASK_CLEANUP = "enable-old-task-cleanup";
    private static final String SHUFFLE_NAME = "shuffle.name";
    private static final String HTTP_SERVER_ACCESS_LOGS = "http-server.enable-access-log";
    private boolean enableSerializedPageChecksum = true;
    private boolean enableVeloxExpressionLogging;
    private boolean enableVeloxTaskLogging = true;
    private boolean httpServerReusePort = true;
    private int httpServerPort = 7777;
    private int httpExecThreads = 32;
    private int httpsServerPort = 7778;
    private boolean enableHttpsCommunication;
    private String httpsCiphers = "AES128-SHA,AES128-SHA256,AES256-GCM-SHA384";
    private String httpsCertPath = "";
    private String httpsKeyPath = "";
    private int numIoThreads = 30;
    private boolean asyncDataCacheEnabled;
    private int asyncCacheSsdGb;
    private int numConnectorIoThreads;
    private int shutdownOnsetSec = 10;
    private int systemMemoryGb = 10;
    private DataSize queryMemoryGb = new DataSize(8.0, DataSize.Unit.GIGABYTE);
    private boolean useMmapAllocator = true;
    private String memoryArbitratorKind = "SHARED";
    private int memoryArbitratorCapacityGb = 8;
    private long memoryPoolInitCapacity = 0x200000000L;
    private long memoryPoolTransferCapacity = 0x80000000L;
    private String spillerSpillPath = "";
    private int concurrentLifespansPerTask = 5;
    private int maxDriversPerTask = 15;
    private boolean enableOldTaskCleanUp;
    private String prestoVersion = "dummy.presto.version";
    private String shuffleName = "local";
    private boolean registerTestFunctions;
    private boolean enableHttpServerAccessLog = true;

    public Map<String, String> getAllProperties() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        return builder.put((Object)CONCURRENT_LIFESPANS_PER_TASK, (Object)String.valueOf(this.getConcurrentLifespansPerTask())).put((Object)ENABLE_SERIALIZED_PAGE_CHECKSUM, (Object)String.valueOf(this.isEnableSerializedPageChecksum())).put((Object)ENABLE_VELOX_EXPRESSION_LOGGING, (Object)String.valueOf(this.isEnableVeloxExpressionLogging())).put((Object)ENABLE_VELOX_TASK_LOGGING, (Object)String.valueOf(this.isEnableVeloxTaskLogging())).put((Object)HTTP_SERVER_HTTP_PORT, (Object)String.valueOf(this.getHttpServerPort())).put((Object)HTTP_SERVER_REUSE_PORT, (Object)String.valueOf(this.isHttpServerReusePort())).put((Object)REGISTER_TEST_FUNCTIONS, (Object)String.valueOf(this.isRegisterTestFunctions())).put((Object)HTTP_SERVER_HTTPS_PORT, (Object)String.valueOf(this.getHttpsServerPort())).put((Object)HTTP_SERVER_HTTPS_ENABLED, (Object)String.valueOf(this.isEnableHttpsCommunication())).put((Object)HTTPS_CIPHERS, (Object)String.valueOf(this.getHttpsCiphers())).put((Object)HTTPS_CERT_PATH, (Object)String.valueOf(this.getHttpsCertPath())).put((Object)HTTPS_KEY_PATH, (Object)String.valueOf(this.getHttpsKeyPath())).put((Object)HTTP_EXEC_THREADS, (Object)String.valueOf(this.getHttpExecThreads())).put((Object)NUM_IO_THREADS, (Object)String.valueOf(this.getNumIoThreads())).put((Object)ASYNC_DATA_CACHE_ENABLED, (Object)String.valueOf(this.getAsyncDataCacheEnabled())).put((Object)ASYNC_CACHE_SSD_GB, (Object)String.valueOf(this.getAsyncCacheSsdGb())).put((Object)NUM_CONNECTOR_IO_THREADS, (Object)String.valueOf(this.getNumConnectorIoThreads())).put((Object)PRESTO_VERSION, (Object)this.getPrestoVersion()).put((Object)SHUTDOWN_ONSET_SEC, (Object)String.valueOf(this.getShutdownOnsetSec())).put((Object)SYSTEM_MEMORY_GB, (Object)String.valueOf(this.getSystemMemoryGb())).put((Object)QUERY_MEMORY_GB, (Object)String.valueOf(this.getQueryMemoryGb())).put((Object)USE_MMAP_ALLOCATOR, (Object)String.valueOf(this.getUseMmapAllocator())).put((Object)MEMORY_ARBITRATOR_KIND, (Object)String.valueOf(this.getMemoryArbitratorKind())).put((Object)MEMORY_ARBITRATOR_CAPACITY_GB, (Object)String.valueOf(this.getMemoryArbitratorCapacityGb())).put((Object)MEMORY_POOL_INIT_CAPACITY, (Object)String.valueOf(this.getMemoryPoolInitCapacity())).put((Object)MEMORY_POOL_TRANSFER_CAPACITY, (Object)String.valueOf(this.getMemoryPoolTransferCapacity())).put((Object)SPILLER_SPILL_PATH, (Object)String.valueOf(this.getSpillerSpillPath())).put((Object)TASK_MAX_DRIVERS_PER_TASK, (Object)String.valueOf(this.getMaxDriversPerTask())).put((Object)ENABLE_OLD_TASK_CLEANUP, (Object)String.valueOf(this.getOldTaskCleanupMs())).put((Object)SHUFFLE_NAME, (Object)this.getShuffleName()).put((Object)HTTP_SERVER_ACCESS_LOGS, (Object)String.valueOf(this.isEnableHttpServerAccessLog())).build();
    }

    @Config(value="shuffle.name")
    public NativeExecutionSystemConfig setShuffleName(String shuffleName) {
        this.shuffleName = Objects.requireNonNull(shuffleName);
        return this;
    }

    public String getShuffleName() {
        return this.shuffleName;
    }

    @Config(value="enable-serialized-page-checksum")
    public NativeExecutionSystemConfig setEnableSerializedPageChecksum(boolean enableSerializedPageChecksum) {
        this.enableSerializedPageChecksum = enableSerializedPageChecksum;
        return this;
    }

    public boolean isEnableSerializedPageChecksum() {
        return this.enableSerializedPageChecksum;
    }

    @Config(value="enable_velox_expression_logging")
    public NativeExecutionSystemConfig setEnableVeloxExpressionLogging(boolean enableVeloxExpressionLogging) {
        this.enableVeloxExpressionLogging = enableVeloxExpressionLogging;
        return this;
    }

    public boolean isEnableVeloxExpressionLogging() {
        return this.enableVeloxExpressionLogging;
    }

    @Config(value="enable_velox_task_logging")
    public NativeExecutionSystemConfig setEnableVeloxTaskLogging(boolean enableVeloxTaskLogging) {
        this.enableVeloxTaskLogging = enableVeloxTaskLogging;
        return this;
    }

    public boolean isEnableVeloxTaskLogging() {
        return this.enableVeloxTaskLogging;
    }

    @Config(value="http-server.http.port")
    public NativeExecutionSystemConfig setHttpServerPort(int httpServerPort) {
        this.httpServerPort = httpServerPort;
        return this;
    }

    public int getHttpServerPort() {
        return this.httpServerPort;
    }

    @Config(value="http-server.reuse-port")
    public NativeExecutionSystemConfig setHttpServerReusePort(boolean httpServerReusePort) {
        this.httpServerReusePort = httpServerReusePort;
        return this;
    }

    public boolean isHttpServerReusePort() {
        return this.httpServerReusePort;
    }

    @Config(value="register-test-functions")
    public NativeExecutionSystemConfig setRegisterTestFunctions(boolean registerTestFunctions) {
        this.registerTestFunctions = registerTestFunctions;
        return this;
    }

    public boolean isRegisterTestFunctions() {
        return this.registerTestFunctions;
    }

    @Config(value="http_exec_threads")
    public NativeExecutionSystemConfig setHttpExecThreads(int httpExecThreads) {
        this.httpExecThreads = httpExecThreads;
        return this;
    }

    public int getHttpExecThreads() {
        return this.httpExecThreads;
    }

    public int getHttpsServerPort() {
        return this.httpsServerPort;
    }

    @Config(value="http-server.https.port")
    public NativeExecutionSystemConfig setHttpsServerPort(int httpsServerPort) {
        this.httpsServerPort = httpsServerPort;
        return this;
    }

    public boolean isEnableHttpsCommunication() {
        return this.enableHttpsCommunication;
    }

    @Config(value="http-server.https.enabled")
    public NativeExecutionSystemConfig setEnableHttpsCommunication(boolean enableHttpsCommunication) {
        this.enableHttpsCommunication = enableHttpsCommunication;
        return this;
    }

    public String getHttpsCiphers() {
        return this.httpsCiphers;
    }

    @Config(value="https-supported-ciphers")
    public NativeExecutionSystemConfig setHttpsCiphers(String httpsCiphers) {
        this.httpsCiphers = httpsCiphers;
        return this;
    }

    public String getHttpsCertPath() {
        return this.httpsCertPath;
    }

    @Config(value="https-cert-path")
    public NativeExecutionSystemConfig setHttpsCertPath(String httpsCertPath) {
        this.httpsCertPath = httpsCertPath;
        return this;
    }

    public String getHttpsKeyPath() {
        return this.httpsKeyPath;
    }

    @Config(value="https-key-path")
    public NativeExecutionSystemConfig setHttpsKeyPath(String httpsKeyPath) {
        this.httpsKeyPath = httpsKeyPath;
        return this;
    }

    @Config(value="num-io-threads")
    public NativeExecutionSystemConfig setNumIoThreads(int numIoThreads) {
        this.numIoThreads = numIoThreads;
        return this;
    }

    public int getNumIoThreads() {
        return this.numIoThreads;
    }

    @Config(value="async-data-cache-enabled")
    public NativeExecutionSystemConfig setAsyncDataCacheEnabled(boolean asyncDataCacheEnabled) {
        this.asyncDataCacheEnabled = asyncDataCacheEnabled;
        return this;
    }

    public boolean getAsyncDataCacheEnabled() {
        return this.asyncDataCacheEnabled;
    }

    @Config(value="async-cache-ssd-gb")
    public NativeExecutionSystemConfig setAsyncCacheSsdGb(int asyncCacheSsdGb) {
        this.asyncCacheSsdGb = asyncCacheSsdGb;
        return this;
    }

    public int getAsyncCacheSsdGb() {
        return this.asyncCacheSsdGb;
    }

    @Config(value="num-connector-io-threads")
    public NativeExecutionSystemConfig setNumConnectorIoThreads(int numConnectorIoThreads) {
        this.numConnectorIoThreads = numConnectorIoThreads;
        return this;
    }

    public int getNumConnectorIoThreads() {
        return this.numConnectorIoThreads;
    }

    @Config(value="shutdown-onset-sec")
    public NativeExecutionSystemConfig setShutdownOnsetSec(int shutdownOnsetSec) {
        this.shutdownOnsetSec = shutdownOnsetSec;
        return this;
    }

    public int getShutdownOnsetSec() {
        return this.shutdownOnsetSec;
    }

    @Config(value="system-memory-gb")
    public NativeExecutionSystemConfig setSystemMemoryGb(int systemMemoryGb) {
        this.systemMemoryGb = systemMemoryGb;
        return this;
    }

    public int getSystemMemoryGb() {
        return this.systemMemoryGb;
    }

    @Config(value="query.max-memory-per-node")
    public NativeExecutionSystemConfig setQueryMemoryGb(DataSize queryMemoryGb) {
        this.queryMemoryGb = queryMemoryGb;
        return this;
    }

    public DataSize getQueryMemoryGb() {
        return this.queryMemoryGb;
    }

    @Config(value="use-mmap-allocator")
    public NativeExecutionSystemConfig setUseMmapAllocator(boolean useMmapAllocator) {
        this.useMmapAllocator = useMmapAllocator;
        return this;
    }

    public boolean getUseMmapAllocator() {
        return this.useMmapAllocator;
    }

    @Config(value="memory-arbitrator-kind")
    public NativeExecutionSystemConfig setMemoryArbitratorKind(String memoryArbitratorKind) {
        this.memoryArbitratorKind = memoryArbitratorKind;
        return this;
    }

    public String getMemoryArbitratorKind() {
        return this.memoryArbitratorKind;
    }

    @Config(value="query-memory-gb")
    public NativeExecutionSystemConfig setMemoryArbitratorCapacityGb(int memoryArbitratorCapacityGb) {
        this.memoryArbitratorCapacityGb = memoryArbitratorCapacityGb;
        return this;
    }

    public int getMemoryArbitratorCapacityGb() {
        return this.memoryArbitratorCapacityGb;
    }

    @Config(value="memory-pool-init-capacity")
    public NativeExecutionSystemConfig setMemoryPoolInitCapacity(long memoryPoolInitCapacity) {
        this.memoryPoolInitCapacity = memoryPoolInitCapacity;
        return this;
    }

    public long getMemoryPoolInitCapacity() {
        return this.memoryPoolInitCapacity;
    }

    @Config(value="memory-pool-transfer-capacity")
    public NativeExecutionSystemConfig setMemoryPoolTransferCapacity(long memoryPoolTransferCapacity) {
        this.memoryPoolTransferCapacity = memoryPoolTransferCapacity;
        return this;
    }

    public long getMemoryPoolTransferCapacity() {
        return this.memoryPoolTransferCapacity;
    }

    @Config(value="experimental.spiller-spill-path")
    public NativeExecutionSystemConfig setSpillerSpillPath(String spillerSpillPath) {
        this.spillerSpillPath = spillerSpillPath;
        return this;
    }

    public String getSpillerSpillPath() {
        return this.spillerSpillPath;
    }

    @Config(value="concurrent-lifespans-per-task")
    public NativeExecutionSystemConfig setConcurrentLifespansPerTask(int concurrentLifespansPerTask) {
        this.concurrentLifespansPerTask = concurrentLifespansPerTask;
        return this;
    }

    public int getConcurrentLifespansPerTask() {
        return this.concurrentLifespansPerTask;
    }

    @Config(value="task.max-drivers-per-task")
    public NativeExecutionSystemConfig setMaxDriversPerTask(int maxDriversPerTask) {
        this.maxDriversPerTask = maxDriversPerTask;
        return this;
    }

    public int getMaxDriversPerTask() {
        return this.maxDriversPerTask;
    }

    public boolean getOldTaskCleanupMs() {
        return this.enableOldTaskCleanUp;
    }

    @Config(value="enable-old-task-cleanup")
    public NativeExecutionSystemConfig setOldTaskCleanupMs(boolean enableOldTaskCleanUp) {
        this.enableOldTaskCleanUp = enableOldTaskCleanUp;
        return this;
    }

    @Config(value="presto.version")
    public NativeExecutionSystemConfig setPrestoVersion(String prestoVersion) {
        this.prestoVersion = prestoVersion;
        return this;
    }

    public String getPrestoVersion() {
        return this.prestoVersion;
    }

    @Config(value="http-server.enable-access-log")
    public NativeExecutionSystemConfig setEnableHttpServerAccessLog(boolean enableHttpServerAccessLog) {
        this.enableHttpServerAccessLog = enableHttpServerAccessLog;
        return this;
    }

    public boolean isEnableHttpServerAccessLog() {
        return this.enableHttpServerAccessLog;
    }
}

