/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution.nativeprocess;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.client.ServerInfo;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.spark.execution.nativeprocess.NativeExecutionProcess;
import com.facebook.presto.spark.execution.property.WorkerProperty;
import com.facebook.presto.spark.execution.task.ForNativeExecutionTask;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import io.airlift.units.Duration;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class NativeExecutionProcessFactory {
    private static final Duration MAX_ERROR_DURATION = new Duration(2.0, TimeUnit.MINUTES);
    public static final URI DEFAULT_URI = URI.create("http://127.0.0.1");
    private final HttpClient httpClient;
    private final ExecutorService coreExecutor;
    private final ScheduledExecutorService errorRetryScheduledExecutor;
    private final JsonCodec<ServerInfo> serverInfoCodec;
    private final TaskManagerConfig taskManagerConfig;
    private final WorkerProperty<?, ?, ?, ?> workerProperty;
    private static NativeExecutionProcess process;

    @Inject
    public NativeExecutionProcessFactory(@ForNativeExecutionTask HttpClient httpClient, ExecutorService coreExecutor, ScheduledExecutorService errorRetryScheduledExecutor, JsonCodec<ServerInfo> serverInfoCodec, TaskManagerConfig taskManagerConfig, WorkerProperty<?, ?, ?, ?> workerProperty) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.coreExecutor = Objects.requireNonNull(coreExecutor, "coreExecutor is null");
        this.errorRetryScheduledExecutor = Objects.requireNonNull(errorRetryScheduledExecutor, "errorRetryScheduledExecutor is null");
        this.serverInfoCodec = Objects.requireNonNull(serverInfoCodec, "serverInfoCodec is null");
        this.taskManagerConfig = Objects.requireNonNull(taskManagerConfig, "taskManagerConfig is null");
        this.workerProperty = Objects.requireNonNull(workerProperty, "workerProperty is null");
    }

    public synchronized NativeExecutionProcess getNativeExecutionProcess(Session session, URI location) {
        if (!SystemSessionProperties.isNativeExecutionProcessReuseEnabled((Session)session) || process == null || !process.isAlive()) {
            process = this.createNativeExecutionProcess(session, location, MAX_ERROR_DURATION);
        }
        return process;
    }

    public NativeExecutionProcess createNativeExecutionProcess(Session session, URI location, Duration maxErrorDuration) {
        try {
            return new NativeExecutionProcess(session, location, this.httpClient, this.errorRetryScheduledExecutor, this.serverInfoCodec, maxErrorDuration, this.taskManagerConfig, this.workerProperty);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NATIVE_EXECUTION_PROCESS_LAUNCH_ERROR, String.format("Cannot start native process: %s", e.getMessage()), (Throwable)e);
        }
    }

    @PreDestroy
    public void stop() {
        this.coreExecutor.shutdownNow();
        this.errorRetryScheduledExecutor.shutdownNow();
        if (process != null) {
            process.close();
        }
    }
}

