/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution.nativeprocess;

import com.facebook.airlift.http.client.HttpClientBinder;
import com.facebook.presto.spark.execution.nativeprocess.DetachedNativeExecutionProcessFactory;
import com.facebook.presto.spark.execution.nativeprocess.NativeExecutionProcessFactory;
import com.facebook.presto.spark.execution.property.NativeExecutionConnectorConfig;
import com.facebook.presto.spark.execution.property.NativeExecutionNodeConfig;
import com.facebook.presto.spark.execution.property.NativeExecutionSystemConfig;
import com.facebook.presto.spark.execution.property.NativeExecutionVeloxConfig;
import com.facebook.presto.spark.execution.property.PrestoSparkWorkerProperty;
import com.facebook.presto.spark.execution.property.WorkerProperty;
import com.facebook.presto.spark.execution.shuffle.PrestoSparkLocalShuffleInfoTranslator;
import com.facebook.presto.spark.execution.shuffle.PrestoSparkShuffleInfoTranslator;
import com.facebook.presto.spark.execution.task.ForNativeExecutionTask;
import com.facebook.presto.spark.execution.task.NativeExecutionTaskFactory;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.units.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class NativeExecutionModule
implements Module {
    private Optional<NativeExecutionConnectorConfig> connectorConfig;

    public NativeExecutionModule() {
        this.connectorConfig = Optional.empty();
    }

    public NativeExecutionModule(Optional<NativeExecutionConnectorConfig> connectorConfig) {
        this.connectorConfig = connectorConfig;
    }

    public void configure(Binder binder) {
        this.bindWorkerProperties(binder);
        this.bindNativeExecutionTaskFactory(binder);
        this.bindHttpClient(binder);
        this.bindNativeExecutionProcess(binder);
        this.bindShuffle(binder);
    }

    protected void bindShuffle(Binder binder) {
        binder.bind(PrestoSparkLocalShuffleInfoTranslator.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, (TypeLiteral)new TypeLiteral<PrestoSparkShuffleInfoTranslator>(){}).setDefault().to(PrestoSparkLocalShuffleInfoTranslator.class).in(Scopes.SINGLETON);
    }

    protected void bindWorkerProperties(Binder binder) {
        OptionalBinder.newOptionalBinder((Binder)binder, (TypeLiteral)new TypeLiteral<WorkerProperty<?, ?, ?, ?>>(){}).setDefault().to(PrestoSparkWorkerProperty.class).in(Scopes.SINGLETON);
        if (this.connectorConfig.isPresent()) {
            binder.bind(PrestoSparkWorkerProperty.class).toInstance((Object)new PrestoSparkWorkerProperty(this.connectorConfig.get(), new NativeExecutionNodeConfig(), new NativeExecutionSystemConfig(), new NativeExecutionVeloxConfig()));
        } else {
            binder.bind(PrestoSparkWorkerProperty.class).in(Scopes.SINGLETON);
        }
    }

    protected void bindHttpClient(Binder binder) {
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("nativeExecution", ForNativeExecutionTask.class).withConfigDefaults(config -> {
            config.setRequestTimeout(new Duration(10.0, TimeUnit.SECONDS));
            config.setMaxConnectionsPerServer(250);
        });
    }

    protected void bindNativeExecutionTaskFactory(Binder binder) {
        binder.bind(NativeExecutionTaskFactory.class).in(Scopes.SINGLETON);
    }

    protected void bindNativeExecutionProcess(Binder binder) {
        if (System.getProperty("NATIVE_PORT") != null) {
            binder.bind(NativeExecutionProcessFactory.class).to(DetachedNativeExecutionProcessFactory.class).in(Scopes.SINGLETON);
        } else {
            binder.bind(NativeExecutionProcessFactory.class).in(Scopes.SINGLETON);
        }
    }
}

