/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution.http;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.client.ServerInfo;
import com.facebook.presto.server.RequestHelpers;
import com.facebook.presto.server.smile.AdaptingJsonResponseHandler;
import com.facebook.presto.server.smile.BaseResponse;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class PrestoSparkHttpServerClient {
    private static final Logger log = Logger.get(PrestoSparkHttpServerClient.class);
    private static final String SERVER_URI = "/v1/info";
    private final HttpClient httpClient;
    private final URI location;
    private final URI serverUri;
    private final JsonCodec<ServerInfo> serverInfoCodec;

    public PrestoSparkHttpServerClient(HttpClient httpClient, URI location, JsonCodec<ServerInfo> serverInfoCodec) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.location = Objects.requireNonNull(location, "location is null");
        this.serverInfoCodec = Objects.requireNonNull(serverInfoCodec, "serverInfoCodec is null");
        this.serverUri = this.getServerUri(location);
    }

    public ListenableFuture<BaseResponse<ServerInfo>> getServerInfo() {
        Request request = RequestHelpers.setContentTypeHeaders((boolean)false, (Request.Builder)Request.Builder.prepareGet()).setUri(this.serverUri).build();
        return this.httpClient.executeAsync(request, (ResponseHandler)AdaptingJsonResponseHandler.createAdaptingJsonResponseHandler(this.serverInfoCodec));
    }

    public URI getLocation() {
        return this.location;
    }

    private URI getServerUri(URI baseUri) {
        return HttpUriBuilder.uriBuilderFrom((URI)baseUri).appendPath(SERVER_URI).build();
    }
}

