/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution.http;

import com.facebook.presto.server.TaskUpdateRequest;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public final class BatchTaskUpdateRequest {
    private final TaskUpdateRequest taskUpdateRequest;
    private final Optional<String> shuffleWriteInfo;
    private final Optional<String> broadcastBasePath;

    @JsonCreator
    public BatchTaskUpdateRequest(@JsonProperty(value="taskUpdateRequest") TaskUpdateRequest taskUpdateRequest, @JsonProperty(value="shuffleWriteInfo") Optional<String> shuffleWriteInfo, @JsonProperty(value="broadcastBasePath") Optional<String> broadcastBasePath) {
        this.taskUpdateRequest = Objects.requireNonNull(taskUpdateRequest, "taskUpdateRequest is null");
        this.shuffleWriteInfo = Objects.requireNonNull(shuffleWriteInfo, "shuffleWriteInfo is null");
        this.broadcastBasePath = Objects.requireNonNull(broadcastBasePath, "broadcastBasePath is null");
        if (this.shuffleWriteInfo.isPresent() && this.broadcastBasePath.isPresent()) {
            throw new IllegalArgumentException("shuffleWriteInfo and broadcastBasePath can not be specified in same request");
        }
    }

    @JsonProperty
    public TaskUpdateRequest getTaskUpdateRequest() {
        return this.taskUpdateRequest;
    }

    @JsonProperty
    public Optional<String> getShuffleWriteInfo() {
        return this.shuffleWriteInfo;
    }

    @JsonProperty
    public Optional<String> getBroadcastBasePath() {
        return this.broadcastBasePath;
    }

    public String toString() {
        MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper((Object)this).add("taskUpdateRequest", (Object)this.taskUpdateRequest);
        this.shuffleWriteInfo.ifPresent(shuffleInfo -> stringHelper.add("shuffleWriteInfo", shuffleInfo));
        this.broadcastBasePath.ifPresent(basePath -> stringHelper.add("broadcastBasePath", basePath));
        return stringHelper.toString();
    }
}

