/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.presto.spark.classloader_interface.MutablePartitionId;
import com.facebook.presto.spark.classloader_interface.PrestoSparkMutableRow;
import com.facebook.presto.spark.execution.PrestoSparkBufferedResult;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SizeOf;
import io.airlift.slice.SliceOutput;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;
import scala.Tuple2;

public class PrestoSparkRowBatch
implements PrestoSparkBufferedResult {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(PrestoSparkRowBatch.class).instanceSize();
    private static final int MIN_TARGET_SIZE_IN_BYTES = 0x100000;
    private static final int MAX_TARGET_SIZE_IN_BYTES = 0xA00000;
    private static final int DEFAULT_EXPECTED_ROWS_COUNT = 10000;
    private static final int REPLICATED_ROW_PARTITION_ID = -1;
    private static final short MULTI_ROW_ENTRY_MAX_SIZE_IN_BYTES = 10240;
    private static final short MULTI_ROW_ENTRY_MAX_ROW_COUNT = 10240;
    private final int partitionCount;
    private final int rowCount;
    private final byte[] rowData;
    private final int[] rowPartitions;
    private final int[] rowOffsets;
    private final int totalSizeInBytes;
    private final long retainedSizeInBytes;

    private PrestoSparkRowBatch(int partitionCount, int rowCount, byte[] rowData, int[] rowPartitions, int[] rowOffsets, int totalSizeInBytes) {
        this.partitionCount = partitionCount;
        this.rowCount = rowCount;
        this.rowData = Objects.requireNonNull(rowData, "rowData is null");
        this.rowPartitions = Objects.requireNonNull(rowPartitions, "rowPartitions is null");
        this.rowOffsets = Objects.requireNonNull(rowOffsets, "rowOffsets is null");
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((byte[])rowData) + SizeOf.sizeOf((int[])rowPartitions) + SizeOf.sizeOf((int[])rowOffsets);
        this.totalSizeInBytes = totalSizeInBytes;
    }

    public RowTupleSupplier createRowTupleSupplier() {
        return new RowTupleSupplier(this.partitionCount, this.rowCount, this.rowData, this.rowPartitions, this.rowOffsets, this.totalSizeInBytes);
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public int getPositionCount() {
        return this.rowCount;
    }

    public static PrestoSparkRowBatchBuilder builder(int partitionCount, int targetAverageRowSizeInBytes) {
        Preconditions.checkArgument((partitionCount > 0 ? 1 : 0) != 0, (String)"partitionCount must be greater then zero: %s", (int)partitionCount);
        int targetSizeInBytes = partitionCount * targetAverageRowSizeInBytes;
        targetSizeInBytes = Math.max(targetSizeInBytes, 0x100000);
        targetSizeInBytes = Math.min(targetSizeInBytes, 0xA00000);
        targetAverageRowSizeInBytes = Math.min(targetSizeInBytes / partitionCount, targetAverageRowSizeInBytes);
        return PrestoSparkRowBatch.builder(partitionCount, targetSizeInBytes, 10000, targetAverageRowSizeInBytes, 10240, 10240);
    }

    @VisibleForTesting
    static PrestoSparkRowBatchBuilder builder(int partitionCount, int targetSizeInBytes, int expectedRowsCount, int targetAverageRowSizeInBytes, int maxEntrySizeInBytes, int maxRowsPerEntry) {
        return new PrestoSparkRowBatchBuilder(partitionCount, targetSizeInBytes, expectedRowsCount, targetAverageRowSizeInBytes, maxEntrySizeInBytes, maxRowsPerEntry);
    }

    public static class RowIndex {
        private static final int NIL = -1;
        private final int[] nextRow;
        private final int[] rowIndex;

        public static RowIndex create(int rowCount, int partitionCount, int[] partitions) {
            int[] nextRow = new int[partitionCount + 1];
            Arrays.fill(nextRow, -1);
            int[] rowIndex = new int[rowCount];
            Arrays.fill(rowIndex, -1);
            for (int row = rowCount - 1; row >= 0; --row) {
                int partition = partitions[row];
                int partitionIndex = RowIndex.getPartitionIndex(partition, nextRow);
                int currentPointer = nextRow[partitionIndex];
                nextRow[partitionIndex] = row;
                rowIndex[row] = currentPointer;
            }
            return new RowIndex(nextRow, rowIndex);
        }

        private RowIndex(int[] nextRow, int[] rowIndex) {
            this.nextRow = Objects.requireNonNull(nextRow, "nextRow is null");
            this.rowIndex = Objects.requireNonNull(rowIndex, "rowIndex is null");
        }

        public boolean hasNextRow(int partition) {
            return this.peekRow(partition) != -1;
        }

        public int peekRow(int partition) {
            return this.nextRow[RowIndex.getPartitionIndex(partition, this.nextRow)];
        }

        public int nextRow(int partition) {
            int partitionIndex = RowIndex.getPartitionIndex(partition, this.nextRow);
            int result = this.nextRow[partitionIndex];
            this.nextRow[partitionIndex] = this.rowIndex[result];
            return result;
        }

        private static int getPartitionIndex(int partition, int[] nextRow) {
            if (partition == -1) {
                return nextRow.length - 1;
            }
            return partition;
        }
    }

    public static class RowTupleSupplier {
        private final int partitionCount;
        private final int rowCount;
        private final int[] rowPartitions;
        private final int[] rowOffsets;
        private final int totalSizeInBytes;
        private int remainingReplicasCount;
        private int currentRow;
        private final ByteBuffer rowData;
        private final MutablePartitionId mutablePartitionId;
        private final PrestoSparkMutableRow row;
        private final Tuple2<MutablePartitionId, PrestoSparkMutableRow> tuple;

        private RowTupleSupplier(int partitionCount, int rowCount, byte[] rowData, int[] rowPartitions, int[] rowOffsets, int totalSizeInBytes) {
            this.partitionCount = partitionCount;
            this.rowCount = rowCount;
            this.rowPartitions = Objects.requireNonNull(rowPartitions, "rowPartitions is null");
            this.rowOffsets = Objects.requireNonNull(rowOffsets, "rowSizes is null");
            this.totalSizeInBytes = totalSizeInBytes;
            this.rowData = ByteBuffer.wrap(Objects.requireNonNull(rowData, "rowData is null"));
            this.rowData.order(ByteOrder.LITTLE_ENDIAN);
            this.mutablePartitionId = new MutablePartitionId();
            this.row = new PrestoSparkMutableRow();
            this.row.setBuffer(this.rowData);
            this.tuple = new Tuple2((Object)this.mutablePartitionId, (Object)this.row);
        }

        @Nullable
        public Tuple2<MutablePartitionId, PrestoSparkMutableRow> getNext() {
            if (this.currentRow >= this.rowCount) {
                return null;
            }
            int currentRowOffset = this.rowOffsets[this.currentRow];
            int nextRow = this.currentRow + 1;
            int nextRowOffset = nextRow < this.rowCount ? this.rowOffsets[nextRow] : this.totalSizeInBytes;
            int rowSize = nextRowOffset - currentRowOffset;
            ((Buffer)this.rowData).limit(currentRowOffset + rowSize);
            ((Buffer)this.rowData).position(currentRowOffset);
            short rowsCount = this.rowData.getShort(currentRowOffset);
            this.row.setPositionCount((int)rowsCount);
            int partition = this.rowPartitions[this.currentRow];
            if (partition == -1) {
                if (this.remainingReplicasCount == 0) {
                    this.remainingReplicasCount = this.partitionCount;
                }
                this.mutablePartitionId.setPartition(this.remainingReplicasCount - 1);
                --this.remainingReplicasCount;
                if (this.remainingReplicasCount == 0) {
                    ++this.currentRow;
                }
            } else {
                this.mutablePartitionId.setPartition(partition);
                ++this.currentRow;
            }
            return this.tuple;
        }
    }

    public static class PrestoSparkRowBatchBuilder {
        private static final int BUILDER_INSTANCE_SIZE = ClassLayout.parseClass(PrestoSparkRowBatchBuilder.class).instanceSize();
        private final int partitionCount;
        private final int targetSizeInBytes;
        private final int targetAverageRowSizeInBytes;
        private final int maxEntrySizeInBytes;
        private final int maxRowsPerEntry;
        private final DynamicSliceOutput sliceOutput;
        private int[] rowOffsets;
        private int totalSizeInBytes;
        private int[] rowPartitions;
        private int rowCount;
        private int currentRowOffset;
        private boolean openEntry;

        private PrestoSparkRowBatchBuilder(int partitionCount, int targetSizeInBytes, int expectedRowsCount, int targetAverageRowSizeInBytes, int maxEntrySizeInBytes, int maxRowsPerEntry) {
            Preconditions.checkArgument((partitionCount > 0 ? 1 : 0) != 0, (String)"partitionCount must be greater then zero: %s", (int)partitionCount);
            this.partitionCount = partitionCount;
            this.targetSizeInBytes = targetSizeInBytes;
            this.targetAverageRowSizeInBytes = targetAverageRowSizeInBytes;
            this.maxEntrySizeInBytes = maxEntrySizeInBytes;
            this.maxRowsPerEntry = maxRowsPerEntry;
            this.sliceOutput = new DynamicSliceOutput((int)((float)targetSizeInBytes * 1.2f));
            this.rowOffsets = new int[expectedRowsCount];
            this.rowPartitions = new int[expectedRowsCount];
        }

        public long getRetainedSizeInBytes() {
            return (long)BUILDER_INSTANCE_SIZE + this.sliceOutput.getRetainedSize() + SizeOf.sizeOf((int[])this.rowOffsets) + SizeOf.sizeOf((int[])this.rowPartitions);
        }

        public boolean isFull() {
            return this.sliceOutput.size() >= this.targetSizeInBytes;
        }

        public boolean isEmpty() {
            return this.rowCount == 0;
        }

        public SliceOutput beginRowEntry() {
            Preconditions.checkState((!this.openEntry ? 1 : 0) != 0, (Object)"previous entry must be closed before creating a new entry");
            this.openEntry = true;
            this.currentRowOffset = this.sliceOutput.size();
            this.sliceOutput.writeShort(1);
            return this.sliceOutput;
        }

        public void closeEntryForNonReplicatedRow(int partition) {
            this.closeEntry(partition);
        }

        public void closeEntryForReplicatedRow() {
            this.closeEntry(-1);
        }

        private void closeEntry(int partitionId) {
            Preconditions.checkState((boolean)this.openEntry, (Object)"entry must be opened first");
            this.openEntry = false;
            this.rowOffsets = PrestoSparkRowBatchBuilder.ensureCapacity(this.rowOffsets, this.rowCount + 1);
            this.rowOffsets[this.rowCount] = this.currentRowOffset;
            this.rowPartitions = PrestoSparkRowBatchBuilder.ensureCapacity(this.rowPartitions, this.rowCount + 1);
            this.rowPartitions[this.rowCount] = partitionId;
            ++this.rowCount;
            this.totalSizeInBytes += this.sliceOutput.size() - this.currentRowOffset;
        }

        private static int[] ensureCapacity(int[] array, int capacity) {
            if (array.length >= capacity) {
                return array;
            }
            return Arrays.copyOf(array, capacity * 2);
        }

        public PrestoSparkRowBatch build() {
            Preconditions.checkState((!this.openEntry ? 1 : 0) != 0, (Object)"entry must be closed before creating a row batch");
            if (this.rowCount == 0) {
                return this.createDirectRowBatch();
            }
            int averageRowSize = this.totalSizeInBytes / this.rowCount;
            if (averageRowSize < this.targetAverageRowSizeInBytes) {
                return this.createGroupedRowBatch();
            }
            return this.createDirectRowBatch();
        }

        private PrestoSparkRowBatch createDirectRowBatch() {
            return new PrestoSparkRowBatch(this.partitionCount, this.rowCount, this.sliceOutput.getUnderlyingSlice().byteArray(), this.rowPartitions, this.rowOffsets, this.totalSizeInBytes);
        }

        private PrestoSparkRowBatch createGroupedRowBatch() {
            RowIndex rowIndex = RowIndex.create(this.rowCount, this.partitionCount, this.rowPartitions);
            byte[] data = this.sliceOutput.getUnderlyingSlice().byteArray();
            DynamicSliceOutput output = new DynamicSliceOutput((int)((float)this.totalSizeInBytes * 1.2f));
            int expectedEntriesCount = (int)((float)(this.totalSizeInBytes / this.targetAverageRowSizeInBytes) * 1.2f);
            int[] entryOffsets = new int[expectedEntriesCount];
            int[] entryPartitions = new int[expectedEntriesCount];
            int entriesCount = 0;
            for (int partition = -1; partition < this.partitionCount; ++partition) {
                while (rowIndex.hasNextRow(partition)) {
                    int currentEntrySize = 0;
                    int currentEntryRowCount = 0;
                    int currentEntryOffset = output.size();
                    output.writeShort(0);
                    entryOffsets = PrestoSparkRowBatchBuilder.ensureCapacity(entryOffsets, entriesCount + 1);
                    entryOffsets[entriesCount] = currentEntryOffset;
                    entryPartitions = PrestoSparkRowBatchBuilder.ensureCapacity(entryPartitions, entriesCount + 1);
                    entryPartitions[entriesCount] = partition;
                    while (rowIndex.hasNextRow(partition)) {
                        int row = rowIndex.peekRow(partition);
                        int followingRow = row + 1;
                        int rowOffset = this.rowOffsets[row];
                        int followingRowOffset = followingRow < this.rowCount ? this.rowOffsets[followingRow] : this.totalSizeInBytes;
                        int rowSize = followingRowOffset - rowOffset;
                        Verify.verify((rowSize >= 2 ? 1 : 0) != 0, (String)"rowSize is expected to be greater than or equal to 2: %s", (int)rowSize);
                        rowOffset += 2;
                        if (currentEntryRowCount > 0 && (currentEntrySize + (rowSize -= 2) > this.maxEntrySizeInBytes || currentEntryRowCount + 1 > this.maxRowsPerEntry)) break;
                        output.writeBytes(data, rowOffset, rowSize);
                        currentEntrySize = (short)(currentEntrySize + rowSize);
                        currentEntryRowCount = (short)(currentEntryRowCount + 1);
                        rowIndex.nextRow(partition);
                    }
                    output.getUnderlyingSlice().setShort(currentEntryOffset, currentEntryRowCount);
                    ++entriesCount;
                }
            }
            return new PrestoSparkRowBatch(this.partitionCount, entriesCount, output.getUnderlyingSlice().byteArray(), entryPartitions, entryOffsets, output.size());
        }
    }
}

