/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.accesscontrol;

import com.facebook.presto.Session;
import com.facebook.presto.execution.QueryStateTimer;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spark.accesscontrol.PrestoSparkAccessControlCheckerExecution;
import com.facebook.presto.spark.classloader_interface.IPrestoSparkQueryExecution;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.analyzer.BuiltInQueryPreparer;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.parser.SqlParser;
import java.util.Objects;
import javax.inject.Inject;

public class PrestoSparkAccessControlChecker {
    private final Metadata metadata;
    private final SqlParser sqlParser;
    private final AccessControl accessControl;
    private final QueryExplainer queryExplainer;

    @Inject
    public PrestoSparkAccessControlChecker(SqlParser sqlParser, QueryExplainer queryExplainer, Metadata metadata, AccessControl accessControl) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.queryExplainer = Objects.requireNonNull(queryExplainer, "queryExplainer is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public IPrestoSparkQueryExecution createExecution(Session session, BuiltInQueryPreparer.BuiltInPreparedQuery preparedQuery, QueryStateTimer queryStateTimer, WarningCollector warningCollector) {
        return new PrestoSparkAccessControlCheckerExecution(session, this.metadata, this.sqlParser, this.accessControl, this.queryExplainer, preparedQuery, queryStateTimer, warningCollector);
    }
}

