/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spark.ExecutionStrategyValidator;
import com.facebook.presto.spark.PrestoSparkConfig;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class PrestoSparkSessionProperties {
    private static final Splitter.MapSplitter MAP_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings().withKeyValueSeparator('=');
    public static final String SPARK_PARTITION_COUNT_AUTO_TUNE_ENABLED = "spark_partition_count_auto_tune_enabled";
    public static final String MIN_SPARK_INPUT_PARTITION_COUNT_FOR_AUTO_TUNE = "min_spark_input_partition_count_for_auto_tune";
    public static final String MAX_SPARK_INPUT_PARTITION_COUNT_FOR_AUTO_TUNE = "max_spark_input_partition_count_for_auto_tune";
    public static final String SPARK_INITIAL_PARTITION_COUNT = "spark_initial_partition_count";
    public static final String MAX_SPLITS_DATA_SIZE_PER_SPARK_PARTITION = "max_splits_data_size_per_spark_partition";
    public static final String SHUFFLE_OUTPUT_TARGET_AVERAGE_ROW_SIZE = "shuffle_output_target_average_row_size";
    public static final String STORAGE_BASED_BROADCAST_JOIN_ENABLED = "storage_based_broadcast_join_enabled";
    public static final String STORAGE_BASED_BROADCAST_JOIN_WRITE_BUFFER_SIZE = "storage_based_broadcast_join_write_buffer_size";
    public static final String SPARK_BROADCAST_JOIN_MAX_MEMORY_OVERRIDE = "spark_broadcast_join_max_memory_override";
    public static final String SPARK_SPLIT_ASSIGNMENT_BATCH_SIZE = "spark_split_assignment_batch_size";
    public static final String SPARK_MEMORY_REVOKING_THRESHOLD = "spark_memory_revoking_threshold";
    public static final String SPARK_MEMORY_REVOKING_TARGET = "spark_memory_revoking_target";
    public static final String SPARK_QUERY_EXECUTION_STRATEGIES = "spark_query_execution_strategies";
    public static final String SPARK_RETRY_ON_OUT_OF_MEMORY_BROADCAST_JOIN_ENABLED = "spark_retry_on_out_of_memory_broadcast_join_enabled";
    public static final String SPARK_RETRY_ON_OUT_OF_MEMORY_WITH_INCREASED_MEMORY_SETTINGS_ENABLED = "spark_retry_on_out_of_memory_with_increased_memory_settings_enabled";
    public static final String OUT_OF_MEMORY_RETRY_PRESTO_SESSION_PROPERTIES = "out_of_memory_retry_presto_session_properties";
    public static final String OUT_OF_MEMORY_RETRY_SPARK_CONFIGS = "out_of_memory_retry_spark_configs";
    public static final String SPARK_AVERAGE_INPUT_DATA_SIZE_PER_EXECUTOR = "spark_average_input_data_size_per_executor";
    public static final String SPARK_MAX_EXECUTOR_COUNT = "spark_max_executor_count";
    public static final String SPARK_MIN_EXECUTOR_COUNT = "spark_min_executor_count";
    public static final String SPARK_AVERAGE_INPUT_DATA_SIZE_PER_PARTITION = "spark_average_input_data_size_per_partition";
    public static final String SPARK_MAX_HASH_PARTITION_COUNT = "spark_max_hash_partition_count";
    public static final String SPARK_MIN_HASH_PARTITION_COUNT = "spark_min_hash_partition_count";
    public static final String SPARK_RESOURCE_ALLOCATION_STRATEGY_ENABLED = "spark_resource_allocation_strategy_enabled";
    public static final String SPARK_EXECUTOR_ALLOCATION_STRATEGY_ENABLED = "spark_executor_allocation_strategy_enabled";
    public static final String SPARK_HASH_PARTITION_COUNT_ALLOCATION_STRATEGY_ENABLED = "spark_hash_partition_count_allocation_strategy_enabled";
    public static final String SPARK_RETRY_ON_OUT_OF_MEMORY_HIGHER_PARTITION_COUNT_ENABLED = "spark_retry_on_out_of_memory_higher_hash_partition_count_enabled";
    public static final String SPARK_HASH_PARTITION_COUNT_SCALING_FACTOR_ON_OUT_OF_MEMORY = "spark_hash_partition_count_scaling_factor_on_out_of_memory";
    public static final String SPARK_ADAPTIVE_QUERY_EXECUTION_ENABLED = "spark_adaptive_query_execution_enabled";
    public static final String ADAPTIVE_JOIN_SIDE_SWITCHING_ENABLED = "adaptive_join_side_switching_enabled";
    public static final String NATIVE_EXECUTION_BROADCAST_BASE_PATH = "native_execution_broadcast_base_path";
    public static final String NATIVE_TRIGGER_COREDUMP_WHEN_UNRESPONSIVE_ENABLED = "native_trigger_coredump_when_unresponsive_enabled";
    private final List<PropertyMetadata<?>> sessionProperties;
    private final ExecutionStrategyValidator executionStrategyValidator = new ExecutionStrategyValidator();

    public PrestoSparkSessionProperties() {
        this(new PrestoSparkConfig());
    }

    @Inject
    public PrestoSparkSessionProperties(PrestoSparkConfig prestoSparkConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)SPARK_PARTITION_COUNT_AUTO_TUNE_ENABLED, (String)"Automatic tuning of spark initial partition count based on splits size per partition", (Boolean)prestoSparkConfig.isSparkPartitionCountAutoTuneEnabled(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)MIN_SPARK_INPUT_PARTITION_COUNT_FOR_AUTO_TUNE, (String)"Minimal Spark input partition count when Spark partition auto tune is enabled", (Integer)prestoSparkConfig.getMinSparkInputPartitionCountForAutoTune(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)MAX_SPARK_INPUT_PARTITION_COUNT_FOR_AUTO_TUNE, (String)"Max Spark input partition count when Spark partition auto tune is enabled", (Integer)prestoSparkConfig.getMaxSparkInputPartitionCountForAutoTune(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)SPARK_INITIAL_PARTITION_COUNT, (String)"Initial partition count for Spark RDD when reading table", (Integer)prestoSparkConfig.getInitialSparkPartitionCount(), (boolean)false), (Object)PropertyMetadata.dataSizeProperty((String)MAX_SPLITS_DATA_SIZE_PER_SPARK_PARTITION, (String)"Maximal size in bytes for splits assigned to one partition", (DataSize)prestoSparkConfig.getMaxSplitsDataSizePerSparkPartition(), (boolean)false), (Object)PropertyMetadata.dataSizeProperty((String)SHUFFLE_OUTPUT_TARGET_AVERAGE_ROW_SIZE, (String)"Target average size for row entries produced by Presto on Spark for shuffle", (DataSize)prestoSparkConfig.getShuffleOutputTargetAverageRowSize(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)STORAGE_BASED_BROADCAST_JOIN_ENABLED, (String)"Use storage for distributing broadcast table", (Boolean)prestoSparkConfig.isStorageBasedBroadcastJoinEnabled(), (boolean)false), (Object)PropertyMetadata.dataSizeProperty((String)STORAGE_BASED_BROADCAST_JOIN_WRITE_BUFFER_SIZE, (String)"Maximum size in bytes to buffer before flushing pages to disk", (DataSize)prestoSparkConfig.getStorageBasedBroadcastJoinWriteBufferSize(), (boolean)false), (Object)PropertyMetadata.dataSizeProperty((String)SPARK_BROADCAST_JOIN_MAX_MEMORY_OVERRIDE, (String)"Maximum size of broadcast table in Presto on Spark", (DataSize)prestoSparkConfig.getSparkBroadcastJoinMaxMemoryOverride(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)SPARK_SPLIT_ASSIGNMENT_BATCH_SIZE, (String)"Number of splits are processed in a single iteration", (Integer)prestoSparkConfig.getSplitAssignmentBatchSize(), (boolean)false), (Object)PropertyMetadata.doubleProperty((String)SPARK_MEMORY_REVOKING_THRESHOLD, (String)"Revoke memory when memory pool is filled over threshold", (Double)prestoSparkConfig.getMemoryRevokingThreshold(), (boolean)false), (Object)PropertyMetadata.doubleProperty((String)SPARK_MEMORY_REVOKING_TARGET, (String)"When revoking memory, try to revoke so much that memory pool is filled below target at the end", (Double)prestoSparkConfig.getMemoryRevokingTarget(), (boolean)false), (Object[])new PropertyMetadata[]{new PropertyMetadata(SPARK_QUERY_EXECUTION_STRATEGIES, "Execution strategies to be applied while running the query", (Type)VarcharType.VARCHAR, List.class, Collections.emptyList(), false, value -> {
            List specifiedStrategies = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)value.toString());
            specifiedStrategies.forEach(strategy -> this.executionStrategyValidator.accept((String)strategy));
            return specifiedStrategies;
        }, value -> value), PropertyMetadata.booleanProperty((String)SPARK_RETRY_ON_OUT_OF_MEMORY_BROADCAST_JOIN_ENABLED, (String)"Disable broadcast join on broadcast OOM and re-submit the query again within the same spark session", (Boolean)prestoSparkConfig.isRetryOnOutOfMemoryBroadcastJoinEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)SPARK_RETRY_ON_OUT_OF_MEMORY_WITH_INCREASED_MEMORY_SETTINGS_ENABLED, (String)"Retry OOMs with increased memory settings and re-submit the query again within the same spark session", (Boolean)prestoSparkConfig.isRetryOnOutOfMemoryWithIncreasedMemorySettingsEnabled(), (boolean)false), new PropertyMetadata(OUT_OF_MEMORY_RETRY_PRESTO_SESSION_PROPERTIES, "Presto session properties to use on OOM query retry, if spark_retry_on_out_of_memory_with_increased_memory_settings_enabled", (Type)VarcharType.VARCHAR, Map.class, prestoSparkConfig.getOutOfMemoryRetryPrestoSessionProperties(), true, value -> MAP_SPLITTER.split((CharSequence)Strings.nullToEmpty((String)((String)value))), value -> value), new PropertyMetadata(OUT_OF_MEMORY_RETRY_SPARK_CONFIGS, "Spark Configs to use on OOM query retry, if spark_retry_on_out_of_memory_with_increased_memory_settings_enabled", (Type)VarcharType.VARCHAR, Map.class, prestoSparkConfig.getOutOfMemoryRetrySparkConfigs(), true, value -> MAP_SPLITTER.split((CharSequence)Strings.nullToEmpty((String)((String)value))), value -> value), PropertyMetadata.dataSizeProperty((String)SPARK_AVERAGE_INPUT_DATA_SIZE_PER_EXECUTOR, (String)"Average input data size per executor", (DataSize)prestoSparkConfig.getAverageInputDataSizePerExecutor(), (boolean)false), PropertyMetadata.integerProperty((String)SPARK_MAX_EXECUTOR_COUNT, (String)"Maximum count of executors to run a query", (Integer)prestoSparkConfig.getMaxExecutorCount(), (boolean)false), PropertyMetadata.integerProperty((String)SPARK_MIN_EXECUTOR_COUNT, (String)"Minimum count of executors to run a query", (Integer)prestoSparkConfig.getMinExecutorCount(), (boolean)false), PropertyMetadata.dataSizeProperty((String)SPARK_AVERAGE_INPUT_DATA_SIZE_PER_PARTITION, (String)"Average input data size per partition", (DataSize)prestoSparkConfig.getAverageInputDataSizePerPartition(), (boolean)false), PropertyMetadata.integerProperty((String)SPARK_MAX_HASH_PARTITION_COUNT, (String)"Maximum hash partition count required by the query", (Integer)prestoSparkConfig.getMaxHashPartitionCount(), (boolean)false), PropertyMetadata.integerProperty((String)SPARK_MIN_HASH_PARTITION_COUNT, (String)"Minimum hash partition count required by the query", (Integer)prestoSparkConfig.getMinHashPartitionCount(), (boolean)false), PropertyMetadata.booleanProperty((String)SPARK_RESOURCE_ALLOCATION_STRATEGY_ENABLED, (String)"Flag to enable optimized resource allocation strategy", (Boolean)prestoSparkConfig.isSparkResourceAllocationStrategyEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)SPARK_EXECUTOR_ALLOCATION_STRATEGY_ENABLED, (String)"Flag to enable optimized executor allocation strategy", (Boolean)prestoSparkConfig.isExecutorAllocationStrategyEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)SPARK_HASH_PARTITION_COUNT_ALLOCATION_STRATEGY_ENABLED, (String)"Flag to enable optimized hash partition count allocation strategy", (Boolean)prestoSparkConfig.isHashPartitionCountAllocationStrategyEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)SPARK_RETRY_ON_OUT_OF_MEMORY_HIGHER_PARTITION_COUNT_ENABLED, (String)"Increases hash partition count by scaling factor specified by spark.hash-partition-count-scaling-factor-on-out-of-memory if query fails due to low hash partition count", (Boolean)prestoSparkConfig.isRetryOnOutOfMemoryWithHigherHashPartitionCountEnabled(), (boolean)false), PropertyMetadata.doubleProperty((String)SPARK_HASH_PARTITION_COUNT_SCALING_FACTOR_ON_OUT_OF_MEMORY, (String)"Scaling factor for hash partition count when a query fails with out of memory error due to low hash partition count", (Double)prestoSparkConfig.getHashPartitionCountScalingFactorOnOutOfMemory(), (boolean)false), PropertyMetadata.booleanProperty((String)SPARK_ADAPTIVE_QUERY_EXECUTION_ENABLED, (String)"Flag to enable adaptive query execution", (Boolean)prestoSparkConfig.isAdaptiveQueryExecutionEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)ADAPTIVE_JOIN_SIDE_SWITCHING_ENABLED, (String)"Enables the adaptive optimizer to switch the build and probe sides of a join", (Boolean)prestoSparkConfig.isAdaptiveJoinSideSwitchingEnabled(), (boolean)false), PropertyMetadata.stringProperty((String)NATIVE_EXECUTION_BROADCAST_BASE_PATH, (String)"Base path for temporary storage of broadcast data", (String)prestoSparkConfig.getNativeExecutionBroadcastBasePath(), (boolean)false), PropertyMetadata.booleanProperty((String)NATIVE_TRIGGER_COREDUMP_WHEN_UNRESPONSIVE_ENABLED, (String)"Trigger coredump of the native execution process when it becomes unresponsive", (Boolean)prestoSparkConfig.isNativeTriggerCoredumpWhenUnresponsiveEnabled(), (boolean)false)});
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean isSparkPartitionCountAutoTuneEnabled(Session session) {
        return (Boolean)session.getSystemProperty(SPARK_PARTITION_COUNT_AUTO_TUNE_ENABLED, Boolean.class);
    }

    public static int getMinSparkInputPartitionCountForAutoTune(Session session) {
        return (Integer)session.getSystemProperty(MIN_SPARK_INPUT_PARTITION_COUNT_FOR_AUTO_TUNE, Integer.class);
    }

    public static int getMaxSparkInputPartitionCountForAutoTune(Session session) {
        return (Integer)session.getSystemProperty(MAX_SPARK_INPUT_PARTITION_COUNT_FOR_AUTO_TUNE, Integer.class);
    }

    public static int getSparkInitialPartitionCount(Session session) {
        return (Integer)session.getSystemProperty(SPARK_INITIAL_PARTITION_COUNT, Integer.class);
    }

    public static DataSize getMaxSplitsDataSizePerSparkPartition(Session session) {
        return (DataSize)session.getSystemProperty(MAX_SPLITS_DATA_SIZE_PER_SPARK_PARTITION, DataSize.class);
    }

    public static DataSize getShuffleOutputTargetAverageRowSize(Session session) {
        return (DataSize)session.getSystemProperty(SHUFFLE_OUTPUT_TARGET_AVERAGE_ROW_SIZE, DataSize.class);
    }

    public static boolean isStorageBasedBroadcastJoinEnabled(Session session) {
        return (Boolean)session.getSystemProperty(STORAGE_BASED_BROADCAST_JOIN_ENABLED, Boolean.class);
    }

    public static DataSize getStorageBasedBroadcastJoinWriteBufferSize(Session session) {
        return (DataSize)session.getSystemProperty(STORAGE_BASED_BROADCAST_JOIN_WRITE_BUFFER_SIZE, DataSize.class);
    }

    public static DataSize getSparkBroadcastJoinMaxMemoryOverride(Session session) {
        return (DataSize)session.getSystemProperty(SPARK_BROADCAST_JOIN_MAX_MEMORY_OVERRIDE, DataSize.class);
    }

    public static int getSplitAssignmentBatchSize(Session session) {
        return (Integer)session.getSystemProperty(SPARK_SPLIT_ASSIGNMENT_BATCH_SIZE, Integer.class);
    }

    public static double getMemoryRevokingThreshold(Session session) {
        return (Double)session.getSystemProperty(SPARK_MEMORY_REVOKING_THRESHOLD, Double.class);
    }

    public static double getMemoryRevokingTarget(Session session) {
        return (Double)session.getSystemProperty(SPARK_MEMORY_REVOKING_TARGET, Double.class);
    }

    public static List<String> getQueryExecutionStrategies(Session session) {
        return (List)session.getSystemProperty(SPARK_QUERY_EXECUTION_STRATEGIES, List.class);
    }

    public static boolean isRetryOnOutOfMemoryBroadcastJoinEnabled(Session session) {
        return (Boolean)session.getSystemProperty(SPARK_RETRY_ON_OUT_OF_MEMORY_BROADCAST_JOIN_ENABLED, Boolean.class);
    }

    public static boolean isRetryOnOutOfMemoryWithIncreasedMemoryEnabled(Session session) {
        return (Boolean)session.getSystemProperty(SPARK_RETRY_ON_OUT_OF_MEMORY_WITH_INCREASED_MEMORY_SETTINGS_ENABLED, Boolean.class);
    }

    public static Map<String, String> getOutOfMemoryRetryPrestoSessionProperties(Session session) {
        return (Map)session.getSystemProperty(OUT_OF_MEMORY_RETRY_PRESTO_SESSION_PROPERTIES, Map.class);
    }

    public static Map<String, String> getOutOfMemoryRetrySparkConfigs(Session session) {
        return (Map)session.getSystemProperty(OUT_OF_MEMORY_RETRY_SPARK_CONFIGS, Map.class);
    }

    public static DataSize getAverageInputDataSizePerExecutor(Session session) {
        return (DataSize)session.getSystemProperty(SPARK_AVERAGE_INPUT_DATA_SIZE_PER_EXECUTOR, DataSize.class);
    }

    public static int getMaxExecutorCount(Session session) {
        return (Integer)session.getSystemProperty(SPARK_MAX_EXECUTOR_COUNT, Integer.class);
    }

    public static int getMinExecutorCount(Session session) {
        return (Integer)session.getSystemProperty(SPARK_MIN_EXECUTOR_COUNT, Integer.class);
    }

    public static DataSize getAverageInputDataSizePerPartition(Session session) {
        return (DataSize)session.getSystemProperty(SPARK_AVERAGE_INPUT_DATA_SIZE_PER_PARTITION, DataSize.class);
    }

    public static int getMaxHashPartitionCount(Session session) {
        return (Integer)session.getSystemProperty(SPARK_MAX_HASH_PARTITION_COUNT, Integer.class);
    }

    public static int getMinHashPartitionCount(Session session) {
        return (Integer)session.getSystemProperty(SPARK_MIN_HASH_PARTITION_COUNT, Integer.class);
    }

    public static boolean isSparkResourceAllocationStrategyEnabled(Session session) {
        return (Boolean)session.getSystemProperty(SPARK_RESOURCE_ALLOCATION_STRATEGY_ENABLED, Boolean.class);
    }

    public static boolean isSparkExecutorAllocationStrategyEnabled(Session session) {
        return (Boolean)session.getSystemProperty(SPARK_EXECUTOR_ALLOCATION_STRATEGY_ENABLED, Boolean.class);
    }

    public static boolean isSparkHashPartitionCountAllocationStrategyEnabled(Session session) {
        return (Boolean)session.getSystemProperty(SPARK_HASH_PARTITION_COUNT_ALLOCATION_STRATEGY_ENABLED, Boolean.class);
    }

    public static boolean isRetryOnOutOfMemoryWithHigherHashPartitionCountEnabled(Session session) {
        return (Boolean)session.getSystemProperty(SPARK_RETRY_ON_OUT_OF_MEMORY_HIGHER_PARTITION_COUNT_ENABLED, Boolean.class);
    }

    public static double getHashPartitionCountScalingFactorOnOutOfMemory(Session session) {
        return (Double)session.getSystemProperty(SPARK_HASH_PARTITION_COUNT_SCALING_FACTOR_ON_OUT_OF_MEMORY, Double.class);
    }

    public static boolean isAdaptiveQueryExecutionEnabled(Session session) {
        return (Boolean)session.getSystemProperty(SPARK_ADAPTIVE_QUERY_EXECUTION_ENABLED, Boolean.class);
    }

    public static boolean isAdaptiveJoinSideSwitchingEnabled(Session session) {
        return (Boolean)session.getSystemProperty(ADAPTIVE_JOIN_SIDE_SWITCHING_ENABLED, Boolean.class);
    }

    public static String getNativeExecutionBroadcastBasePath(Session session) {
        return (String)session.getSystemProperty(NATIVE_EXECUTION_BROADCAST_BASE_PATH, String.class);
    }

    public static boolean isNativeTriggerCoredumpWhenUnresponsiveEnabled(Session session) {
        return (Boolean)session.getSystemProperty(NATIVE_TRIGGER_COREDUMP_WHEN_UNRESPONSIVE_ENABLED, Boolean.class);
    }
}

