/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.presto.spark.PrestoSparkQueryExecutionFactory;
import com.facebook.presto.spark.classloader_interface.IPrestoSparkQueryExecutionFactory;
import com.facebook.presto.spark.classloader_interface.IPrestoSparkService;
import com.facebook.presto.spark.classloader_interface.IPrestoSparkTaskExecutorFactory;
import com.facebook.presto.spark.execution.task.PrestoSparkNativeTaskExecutorFactory;
import com.facebook.presto.spark.execution.task.PrestoSparkTaskExecutorFactory;
import java.util.Objects;
import javax.inject.Inject;

public class PrestoSparkService
implements IPrestoSparkService {
    private final PrestoSparkQueryExecutionFactory queryExecutionFactory;
    private final PrestoSparkTaskExecutorFactory taskExecutorFactory;
    private final PrestoSparkNativeTaskExecutorFactory prestoSparkNativeTaskExecutorFactory;
    private final LifeCycleManager lifeCycleManager;

    @Inject
    public PrestoSparkService(PrestoSparkQueryExecutionFactory queryExecutionFactory, PrestoSparkTaskExecutorFactory taskExecutorFactory, PrestoSparkNativeTaskExecutorFactory prestoSparkNativeTaskExecutorFactory, LifeCycleManager lifeCycleManager) {
        this.queryExecutionFactory = Objects.requireNonNull(queryExecutionFactory, "queryExecutionFactory is null");
        this.taskExecutorFactory = Objects.requireNonNull(taskExecutorFactory, "taskExecutorFactory is null");
        this.prestoSparkNativeTaskExecutorFactory = Objects.requireNonNull(prestoSparkNativeTaskExecutorFactory, "prestoSparkNativeTaskExecutorFactory is null");
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
    }

    public IPrestoSparkQueryExecutionFactory getQueryExecutionFactory() {
        return this.queryExecutionFactory;
    }

    public IPrestoSparkTaskExecutorFactory getTaskExecutorFactory() {
        return this.taskExecutorFactory;
    }

    public IPrestoSparkTaskExecutorFactory getNativeTaskExecutorFactory() {
        return this.prestoSparkNativeTaskExecutorFactory;
    }

    public void close() {
        this.lifeCycleManager.stop();
        this.prestoSparkNativeTaskExecutorFactory.close();
        this.taskExecutorFactory.close();
    }
}

