/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.presto.ExceededMemoryLimitException;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.spark.PrestoSparkBroadcastDependency;
import com.facebook.presto.spark.PrestoSparkServiceWaitTimeMetrics;
import com.facebook.presto.spark.RddAndMore;
import com.facebook.presto.spark.classloader_interface.PrestoSparkSerializedPage;
import com.facebook.presto.spark.util.PrestoSparkUtils;
import com.facebook.presto.spi.page.PagesSerde;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.spark.SparkException;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import scala.Tuple2;

public class PrestoSparkNativeStorageBasedDependency
implements PrestoSparkBroadcastDependency<PrestoSparkSerializedPage> {
    private RddAndMore<PrestoSparkSerializedPage> broadcastDependency;
    private final DataSize maxBroadcastSize;
    private final long queryCompletionDeadline;
    private Broadcast<List<PrestoSparkSerializedPage>> broadcastVariable;
    private final Set<PrestoSparkServiceWaitTimeMetrics> waitTimeMetrics;
    private final PagesSerde pagesSerde;

    public PrestoSparkNativeStorageBasedDependency(RddAndMore<PrestoSparkSerializedPage> broadcastDependency, DataSize maxBroadcastSize, long queryCompletionDeadline, Set<PrestoSparkServiceWaitTimeMetrics> waitTimeMetrics, PagesSerde pagesSerde) {
        this.broadcastDependency = Objects.requireNonNull(broadcastDependency, "broadcastDependency cannot be null");
        this.maxBroadcastSize = Objects.requireNonNull(maxBroadcastSize, "maxBroadcastSize cannot be null");
        this.queryCompletionDeadline = queryCompletionDeadline;
        this.waitTimeMetrics = Objects.requireNonNull(waitTimeMetrics, "waitTimeMetrics cannot be null");
        this.pagesSerde = Objects.requireNonNull(pagesSerde, "pagesSerde cannot be null");
    }

    @Override
    public Broadcast<List<PrestoSparkSerializedPage>> executeBroadcast(JavaSparkContext sparkContext) throws SparkException, TimeoutException {
        List<PrestoSparkSerializedPage> broadcastValue = this.broadcastDependency.collectAndDestroyDependenciesWithTimeout(PrestoSparkUtils.computeNextTimeout(this.queryCompletionDeadline), TimeUnit.MILLISECONDS, this.waitTimeMetrics).stream().map(Tuple2::_2).collect(Collectors.toList());
        this.broadcastDependency = null;
        long maxBroadcastSizeInBytes = this.maxBroadcastSize.toBytes();
        long maxSerializedBytes = this.getNativeMaxSerializedBytes(broadcastValue, this.pagesSerde);
        if (maxSerializedBytes > maxBroadcastSizeInBytes) {
            throw ExceededMemoryLimitException.exceededLocalBroadcastMemoryLimit((DataSize)this.maxBroadcastSize, (String)String.format("Max serialized broadcast size: %s", DataSize.succinctBytes((long)maxSerializedBytes)));
        }
        this.broadcastVariable = sparkContext.broadcast(broadcastValue);
        return this.broadcastVariable;
    }

    private long getNativeMaxSerializedBytes(List<PrestoSparkSerializedPage> prestoSparkSerializedPages, PagesSerde pagesSerde) {
        return prestoSparkSerializedPages.stream().map(prestoSparkSerializedPage -> PrestoSparkUtils.toSerializedPage(prestoSparkSerializedPage)).map(serializedPage -> pagesSerde.deserialize(serializedPage)).flatMap(page -> IntStream.range(0, page.getPositionCount()).mapToObj(position -> BigintType.BIGINT.getObjectValue(null, page.getBlock(1), position))).mapToLong(Long.class::cast).sum();
    }

    @Override
    public void destroy() {
        if (this.broadcastVariable != null) {
            this.broadcastVariable.destroy();
        }
    }
}

