/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.presto.spark.classloader_interface.ExecutionStrategy;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ExecutionStrategyValidator
implements Consumer<String> {
    private static final Set<String> validStrategies = Arrays.stream(ExecutionStrategy.values()).map(strategy -> strategy.name()).collect(Collectors.toSet());

    @Override
    public void accept(String strategy) {
        if (!validStrategies.contains(strategy)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Invalid value for execution strategy [%s]. Valid values: %s", strategy, String.join((CharSequence)",", validStrategies)));
        }
    }
}

