/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.planner;

import com.facebook.presto.Session;
import com.facebook.presto.common.resourceGroups.QueryType;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.HistoryBasedPlanStatisticsManager;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.execution.Input;
import com.facebook.presto.execution.Output;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spark.PhysicalResourceSettings;
import com.facebook.presto.spark.PrestoSparkPhysicalResourceCalculator;
import com.facebook.presto.spark.PrestoSparkSourceStatsCollector;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.OutputNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.Optimizer;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.BuiltInQueryPreparer;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.analyzer.utils.ParameterUtils;
import com.facebook.presto.sql.analyzer.utils.StatementUtils;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.CanonicalPlanWithInfo;
import com.facebook.presto.sql.planner.InputExtractor;
import com.facebook.presto.sql.planner.LogicalPlanner;
import com.facebook.presto.sql.planner.OutputExtractor;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanCanonicalInfoProvider;
import com.facebook.presto.sql.planner.PlanNodeCanonicalInfo;
import com.facebook.presto.sql.planner.PlanOptimizers;
import com.facebook.presto.sql.planner.sanity.PlanChecker;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class PrestoSparkQueryPlanner {
    private final SqlParser sqlParser;
    private final PlanOptimizers optimizers;
    private final QueryExplainer queryExplainer;
    private final Metadata metadata;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private final AccessControl accessControl;
    private final PlanChecker planChecker;
    private final PlanCanonicalInfoProvider planCanonicalInfoProvider;

    @Inject
    public PrestoSparkQueryPlanner(SqlParser sqlParser, PlanOptimizers optimizers, QueryExplainer queryExplainer, Metadata metadata, StatsCalculator statsCalculator, CostCalculator costCalculator, AccessControl accessControl, PlanChecker planChecker, HistoryBasedPlanStatisticsManager historyBasedPlanStatisticsManager) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.optimizers = Objects.requireNonNull(optimizers, "optimizers is null");
        this.queryExplainer = Objects.requireNonNull(queryExplainer, "queryExplainer is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.planChecker = Objects.requireNonNull(planChecker, "planChecker is null");
        this.planCanonicalInfoProvider = Objects.requireNonNull(historyBasedPlanStatisticsManager, "historyBasedPlanStatisticsManager is null").getPlanCanonicalInfoProvider();
    }

    public PlanAndMore createQueryPlan(Session session, BuiltInQueryPreparer.BuiltInPreparedQuery preparedQuery, WarningCollector warningCollector) {
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        Analyzer analyzer = new Analyzer(session, this.metadata, this.sqlParser, this.accessControl, Optional.of(this.queryExplainer), preparedQuery.getParameters(), ParameterUtils.parameterExtractor((Statement)preparedQuery.getStatement(), (List)preparedQuery.getParameters()), warningCollector);
        Analysis analysis = analyzer.analyze(preparedQuery.getStatement());
        VariableAllocator planVariableAllocator = new VariableAllocator();
        LogicalPlanner logicalPlanner = new LogicalPlanner(session, idAllocator, this.metadata, planVariableAllocator, this.sqlParser);
        PlanNode planNode = (PlanNode)session.getRuntimeStats().profileNanos("logicalPlannerTimeNanos", () -> logicalPlanner.plan(analysis));
        Optimizer optimizer = new Optimizer(session, this.metadata, this.optimizers.getPlanningTimeOptimizers(), this.planChecker, this.sqlParser, planVariableAllocator, idAllocator, warningCollector, this.statsCalculator, this.costCalculator, false);
        Plan plan = (Plan)session.getRuntimeStats().profileNanos("optimizerTimeNanos", () -> optimizer.validateAndOptimizePlan(planNode, Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED));
        List inputs = new InputExtractor(this.metadata, session).extractInputs(plan.getRoot());
        Optional output = new OutputExtractor().extractOutput(plan.getRoot());
        Optional queryType = StatementUtils.getQueryType(preparedQuery.getStatement().getClass());
        List columnNames = ((OutputNode)plan.getRoot()).getColumnNames();
        PhysicalResourceSettings physicalResourceSettings = new PrestoSparkPhysicalResourceCalculator().calculate(plan.getRoot(), new PrestoSparkSourceStatsCollector(this.metadata, session), session);
        return new PlanAndMore(plan, Optional.ofNullable(analysis.getUpdateType()), columnNames, (Set<Input>)ImmutableSet.copyOf((Collection)inputs), output, queryType, physicalResourceSettings, PlanNodeCanonicalInfo.getCanonicalInfo((Session)session, (PlanNode)plan.getRoot(), (PlanCanonicalInfoProvider)this.planCanonicalInfoProvider));
    }

    public static class PlanAndMore {
        private final Plan plan;
        private final Optional<String> updateType;
        private final List<String> fieldNames;
        private final Set<Input> inputs;
        private final Optional<Output> output;
        private final Optional<QueryType> queryType;
        private final PhysicalResourceSettings physicalResourceSettings;
        private final List<CanonicalPlanWithInfo> planCanonicalInfo;

        public PlanAndMore(Plan plan, Optional<String> updateType, List<String> fieldNames, Set<Input> inputs, Optional<Output> output, Optional<QueryType> queryType, PhysicalResourceSettings physicalResourceSettings, List<CanonicalPlanWithInfo> planCanonicalInfo) {
            this.plan = Objects.requireNonNull(plan, "plan is null");
            this.updateType = Objects.requireNonNull(updateType, "updateType is null");
            this.fieldNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(fieldNames, "fieldNames is null"));
            this.inputs = ImmutableSet.copyOf((Collection)Objects.requireNonNull(inputs, "inputs is null"));
            this.output = Objects.requireNonNull(output, "output is null");
            this.queryType = Objects.requireNonNull(queryType, "queryType is null");
            this.physicalResourceSettings = Objects.requireNonNull(physicalResourceSettings, "physicalResourceSetting is null.");
            this.planCanonicalInfo = Objects.requireNonNull(planCanonicalInfo, "planCanonicalInfo is null");
        }

        public Plan getPlan() {
            return this.plan;
        }

        public Optional<String> getUpdateType() {
            return this.updateType;
        }

        public List<String> getFieldNames() {
            return this.fieldNames;
        }

        public Set<Input> getInputs() {
            return this.inputs;
        }

        public Optional<Output> getOutput() {
            return this.output;
        }

        public Optional<QueryType> getQueryType() {
            return this.queryType;
        }

        public PhysicalResourceSettings getPhysicalResourceSettings() {
            return this.physicalResourceSettings;
        }

        public List<CanonicalPlanWithInfo> getPlanCanonicalInfo() {
            return this.planCanonicalInfo;
        }
    }
}

