/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution.property;

import com.facebook.presto.spark.execution.property.NativeExecutionConnectorConfig;
import com.facebook.presto.spark.execution.property.NativeExecutionNodeConfig;
import com.facebook.presto.spark.execution.property.NativeExecutionSystemConfig;
import com.facebook.presto.spark.execution.property.NativeExecutionVeloxConfig;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;

public class WorkerProperty<T1 extends NativeExecutionConnectorConfig, T2 extends NativeExecutionNodeConfig, T3 extends NativeExecutionSystemConfig, T4 extends NativeExecutionVeloxConfig> {
    private final T1 connectorConfig;
    private final T2 nodeConfig;
    private final T3 systemConfig;
    private final T4 veloxConfig;

    public WorkerProperty(T1 connectorConfig, T2 nodeConfig, T3 systemConfig, T4 veloxConfig) {
        this.veloxConfig = (NativeExecutionVeloxConfig)Objects.requireNonNull(veloxConfig, "veloxConfig is null");
        this.systemConfig = (NativeExecutionSystemConfig)Objects.requireNonNull(systemConfig, "systemConfig is null");
        this.nodeConfig = (NativeExecutionNodeConfig)Objects.requireNonNull(nodeConfig, "nodeConfig is null");
        this.connectorConfig = (NativeExecutionConnectorConfig)Objects.requireNonNull(connectorConfig, "connectorConfig is null");
    }

    public T1 getConnectorConfig() {
        return this.connectorConfig;
    }

    public T2 getNodeConfig() {
        return this.nodeConfig;
    }

    public T3 getSystemConfig() {
        return this.systemConfig;
    }

    public T4 getVeloxConfig() {
        return this.veloxConfig;
    }

    public void populateAllProperties(Path veloxConfigPath, Path systemConfigPath, Path nodeConfigPath, Path connectorConfigPath) throws IOException {
        this.populateProperty(((NativeExecutionVeloxConfig)this.veloxConfig).getAllProperties(), veloxConfigPath);
        this.populateProperty(((NativeExecutionSystemConfig)this.systemConfig).getAllProperties(), systemConfigPath);
        this.populateProperty(((NativeExecutionNodeConfig)this.nodeConfig).getAllProperties(), nodeConfigPath);
        this.populateProperty(((NativeExecutionConnectorConfig)this.connectorConfig).getAllProperties(), connectorConfigPath);
    }

    private void populateProperty(Map<String, String> properties, Path path) throws IOException {
        File file = new File(path.toString());
        file.getParentFile().mkdirs();
        try {
            FileWriter fileWriter = new FileWriter(file);
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                Preconditions.checkArgument((!entry.getKey().contains("=") ? 1 : 0) != 0, (Object)String.format("Config key %s contains invalid character: =", entry.getKey()));
                fileWriter.write(entry.getKey() + "=" + entry.getValue() + "\n");
            }
            fileWriter.close();
        }
        catch (IOException e) {
            Files.deleteIfExists(path);
            throw e;
        }
    }
}

