/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.airlift.json.Codec;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.cost.HistoryBasedPlanStatisticsTracker;
import com.facebook.presto.event.QueryMonitor;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateTimer;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.memory.NodeMemoryConfig;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spark.ErrorClassifier;
import com.facebook.presto.spark.PrestoSparkMetadataStorage;
import com.facebook.presto.spark.PrestoSparkQueryData;
import com.facebook.presto.spark.PrestoSparkQueryExecutionFactory;
import com.facebook.presto.spark.PrestoSparkQueryStatusInfo;
import com.facebook.presto.spark.PrestoSparkServiceWaitTimeMetrics;
import com.facebook.presto.spark.PrestoSparkTaskDescriptor;
import com.facebook.presto.spark.RddAndMore;
import com.facebook.presto.spark.classloader_interface.MutablePartitionId;
import com.facebook.presto.spark.classloader_interface.PrestoSparkSerializedPage;
import com.facebook.presto.spark.classloader_interface.PrestoSparkShuffleStats;
import com.facebook.presto.spark.classloader_interface.PrestoSparkTaskExecutorFactoryProvider;
import com.facebook.presto.spark.classloader_interface.SerializedTaskInfo;
import com.facebook.presto.spark.execution.AbstractPrestoSparkQueryExecution;
import com.facebook.presto.spark.execution.PrestoSparkExecutionExceptionFactory;
import com.facebook.presto.spark.execution.PrestoSparkTaskExecutorFactory;
import com.facebook.presto.spark.planner.PrestoSparkPlanFragmenter;
import com.facebook.presto.spark.planner.PrestoSparkQueryPlanner;
import com.facebook.presto.spark.planner.PrestoSparkRddFactory;
import com.facebook.presto.spark.util.PrestoSparkUtils;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.storage.TempStorage;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.PartitioningProviderManager;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.planPrinter.PlanPrinter;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.spark.SparkException;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.util.CollectionAccumulator;
import scala.Tuple2;

public class PrestoSparkStaticQueryExecution
extends AbstractPrestoSparkQueryExecution {
    private static final Logger log = Logger.get(PrestoSparkStaticQueryExecution.class);

    public PrestoSparkStaticQueryExecution(JavaSparkContext sparkContext, Session session, QueryMonitor queryMonitor, CollectionAccumulator<SerializedTaskInfo> taskInfoCollector, CollectionAccumulator<PrestoSparkShuffleStats> shuffleStatsCollector, PrestoSparkTaskExecutorFactory taskExecutorFactory, PrestoSparkTaskExecutorFactoryProvider taskExecutorFactoryProvider, QueryStateTimer queryStateTimer, WarningCollector warningCollector, String query, PrestoSparkQueryPlanner.PlanAndMore planAndMore, Optional<String> sparkQueueName, Codec<TaskInfo> taskInfoCodec, JsonCodec<PrestoSparkTaskDescriptor> sparkTaskDescriptorJsonCodec, JsonCodec<PrestoSparkQueryStatusInfo> queryStatusInfoJsonCodec, JsonCodec<PrestoSparkQueryData> queryDataJsonCodec, PrestoSparkRddFactory rddFactory, TransactionManager transactionManager, PagesSerde pagesSerde, PrestoSparkExecutionExceptionFactory executionExceptionFactory, Duration queryTimeout, long queryCompletionDeadline, PrestoSparkMetadataStorage metadataStorage, Optional<String> queryStatusInfoOutputLocation, Optional<String> queryDataOutputLocation, TempStorage tempStorage, NodeMemoryConfig nodeMemoryConfig, FeaturesConfig featuresConfig, QueryManagerConfig queryManagerConfig, Set<PrestoSparkServiceWaitTimeMetrics> waitTimeMetrics, Optional<ErrorClassifier> errorClassifier, PrestoSparkPlanFragmenter planFragmenter, Metadata metadata, PartitioningProviderManager partitioningProviderManager, HistoryBasedPlanStatisticsTracker historyBasedPlanStatisticsTracker, Optional<CollectionAccumulator<Map<String, Long>>> bootstrapMetricsCollector) {
        super(sparkContext, session, queryMonitor, taskInfoCollector, shuffleStatsCollector, taskExecutorFactory, taskExecutorFactoryProvider, queryStateTimer, warningCollector, query, planAndMore, sparkQueueName, taskInfoCodec, sparkTaskDescriptorJsonCodec, queryStatusInfoJsonCodec, queryDataJsonCodec, rddFactory, transactionManager, pagesSerde, executionExceptionFactory, queryTimeout, queryCompletionDeadline, metadataStorage, queryStatusInfoOutputLocation, queryDataOutputLocation, tempStorage, nodeMemoryConfig, featuresConfig, queryManagerConfig, waitTimeMetrics, errorClassifier, planFragmenter, metadata, partitioningProviderManager, historyBasedPlanStatisticsTracker, bootstrapMetricsCollector);
    }

    @Override
    protected List<Tuple2<MutablePartitionId, PrestoSparkSerializedPage>> doExecute() throws SparkException, TimeoutException {
        SubPlan rootFragmentedPlan = this.createFragmentedPlan();
        if (this.planAndMore.getPhysicalResourceSettings().getMaxExecutorCount().isPresent()) {
            this.sparkContext.sc().conf().set("spark.dynamicAllocation.maxExecutors", Integer.toString(this.planAndMore.getPhysicalResourceSettings().getMaxExecutorCount().getAsInt()));
        }
        this.setFinalFragmentedPlan(rootFragmentedPlan);
        TableWriteInfo tableWriteInfo = this.getTableWriteInfo(this.session, rootFragmentedPlan);
        PlanFragment rootFragment = rootFragmentedPlan.getFragment();
        this.queryStateTimer.beginRunning();
        if (rootFragment.getPartitioning().equals((Object)SystemPartitioningHandle.COORDINATOR_DISTRIBUTION)) {
            HashMap<PlanFragmentId, RddAndMore<PrestoSparkSerializedPage>> inputRdds = new HashMap<PlanFragmentId, RddAndMore<PrestoSparkSerializedPage>>();
            for (SubPlan child : rootFragmentedPlan.getChildren()) {
                inputRdds.put(child.getFragment().getId(), this.createRdd(child, PrestoSparkSerializedPage.class, tableWriteInfo));
            }
            return this.collectPages(tableWriteInfo, rootFragment, inputRdds);
        }
        RddAndMore<PrestoSparkSerializedPage> rootRdd = this.createRdd(rootFragmentedPlan, PrestoSparkSerializedPage.class, tableWriteInfo);
        return rootRdd.collectAndDestroyDependenciesWithTimeout(PrestoSparkUtils.computeNextTimeout(this.queryCompletionDeadline), TimeUnit.MILLISECONDS, this.waitTimeMetrics);
    }

    @VisibleForTesting
    public SubPlan createFragmentedPlan() {
        SubPlan rootFragmentedPlan = this.planFragmenter.fragmentQueryPlan(this.session, this.planAndMore.getPlan(), this.warningCollector);
        this.queryMonitor.queryUpdatedEvent(PrestoSparkQueryExecutionFactory.createQueryInfo(this.session, this.query, QueryState.PLANNING, Optional.of(this.planAndMore), this.sparkQueueName, Optional.empty(), this.queryStateTimer, Optional.of(PrestoSparkQueryExecutionFactory.createStageInfo(this.session.getQueryId(), rootFragmentedPlan, (List<TaskInfo>)ImmutableList.of())), this.warningCollector));
        log.info(PlanPrinter.textDistributedPlan((SubPlan)rootFragmentedPlan, (FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager(), (Session)this.session, (boolean)true));
        int hashPartitionCount = this.planAndMore.getPhysicalResourceSettings().getHashPartitionCount();
        rootFragmentedPlan = this.configureOutputPartitioning(this.session, rootFragmentedPlan, hashPartitionCount);
        return rootFragmentedPlan;
    }
}

