/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.execution.QueryStateTimer;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spark.classloader_interface.IPrestoSparkQueryExecution;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.analyzer.AccessControlReferences;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.BuiltInQueryPreparer;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.analyzer.utils.ParameterUtils;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.util.AnalyzerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class PrestoSparkAccessControlCheckerExecution
implements IPrestoSparkQueryExecution {
    private final Session session;
    private final Metadata metadata;
    private final SqlParser sqlParser;
    private final AccessControl accessControl;
    private final QueryExplainer queryExplainer;
    private final BuiltInQueryPreparer.BuiltInPreparedQuery preparedQuery;
    private final QueryStateTimer queryStateTimer;
    private final WarningCollector warningCollector;

    public PrestoSparkAccessControlCheckerExecution(Session session, Metadata metadata, SqlParser sqlParser, AccessControl accessControl, QueryExplainer queryExplainer, BuiltInQueryPreparer.BuiltInPreparedQuery preparedQuery, QueryStateTimer queryStateTimer, WarningCollector warningCollector) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.queryExplainer = Objects.requireNonNull(queryExplainer, "queryExplainer is null");
        this.preparedQuery = Objects.requireNonNull(preparedQuery, "preparedQuery is null");
        this.queryStateTimer = Objects.requireNonNull(queryStateTimer, "queryStateTimer is null");
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
    }

    public List<List<Object>> execute() {
        Analyzer analyzer = new Analyzer(this.session, this.metadata, this.sqlParser, this.accessControl, Optional.of(this.queryExplainer), this.preparedQuery.getParameters(), ParameterUtils.parameterExtractor((Statement)this.preparedQuery.getStatement(), (List)this.preparedQuery.getParameters()), this.warningCollector);
        this.queryStateTimer.beginSemanticAnalyzing();
        Analysis analysis = analyzer.analyzeSemantic(this.preparedQuery.getStatement(), false);
        this.queryStateTimer.beginColumnAccessPermissionChecking();
        AnalyzerUtil.checkAccessPermissions((AccessControlReferences)analysis.getAccessControlReferences());
        this.queryStateTimer.endColumnAccessPermissionChecking();
        ArrayList<List<Object>> results = new ArrayList<List<Object>>();
        results.add(Collections.singletonList(true));
        return results;
    }

    public List<? extends Type> getOutputTypes() {
        return Collections.singletonList(BooleanType.BOOLEAN);
    }
}

