/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.airlift.http.client.HttpClientBinder;
import com.facebook.presto.spark.execution.DetachedNativeExecutionProcessFactory;
import com.facebook.presto.spark.execution.ForNativeExecutionTask;
import com.facebook.presto.spark.execution.NativeExecutionProcessFactory;
import com.facebook.presto.spark.execution.NativeExecutionTaskFactory;
import com.facebook.presto.spark.execution.property.NativeExecutionConnectorConfig;
import com.facebook.presto.spark.execution.property.NativeExecutionNodeConfig;
import com.facebook.presto.spark.execution.property.NativeExecutionSystemConfig;
import com.facebook.presto.spark.execution.property.NativeExecutionVeloxConfig;
import com.facebook.presto.spark.execution.property.PrestoSparkWorkerProperty;
import com.facebook.presto.spark.execution.property.WorkerProperty;
import com.facebook.presto.spark.execution.shuffle.PrestoSparkLocalShuffleInfoTranslator;
import com.facebook.presto.spark.execution.shuffle.PrestoSparkShuffleInfoTranslator;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.units.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class NativeExecutionModule
implements Module {
    private Optional<NativeExecutionConnectorConfig> connectorConfig;

    public NativeExecutionModule() {
        this.connectorConfig = Optional.empty();
    }

    public NativeExecutionModule(Optional<NativeExecutionConnectorConfig> connectorConfig) {
        this.connectorConfig = connectorConfig;
    }

    public void configure(Binder binder) {
        binder.bind(PrestoSparkLocalShuffleInfoTranslator.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, (TypeLiteral)new TypeLiteral<WorkerProperty<?, ?, ?, ?>>(){}).setDefault().to(PrestoSparkWorkerProperty.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, (TypeLiteral)new TypeLiteral<PrestoSparkShuffleInfoTranslator>(){}).setDefault().to(PrestoSparkLocalShuffleInfoTranslator.class).in(Scopes.SINGLETON);
        binder.bind(NativeExecutionTaskFactory.class).in(Scopes.SINGLETON);
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("nativeExecution", ForNativeExecutionTask.class).withConfigDefaults(config -> {
            config.setRequestTimeout(new Duration(10.0, TimeUnit.SECONDS));
            config.setMaxConnectionsPerServer(250);
        });
        if (this.connectorConfig.isPresent()) {
            binder.bind(PrestoSparkWorkerProperty.class).toInstance((Object)new PrestoSparkWorkerProperty(this.connectorConfig.get(), new NativeExecutionNodeConfig(), new NativeExecutionSystemConfig(), new NativeExecutionVeloxConfig()));
        } else {
            binder.bind(PrestoSparkWorkerProperty.class).in(Scopes.SINGLETON);
        }
        if (System.getProperty("NATIVE_PORT") != null) {
            binder.bind(NativeExecutionProcessFactory.class).to(DetachedNativeExecutionProcessFactory.class).in(Scopes.SINGLETON);
        } else {
            binder.bind(NativeExecutionProcessFactory.class).in(Scopes.SINGLETON);
        }
    }
}

