/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.airlift.json.Codec;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.stats.Distribution;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.client.Column;
import com.facebook.presto.client.QueryError;
import com.facebook.presto.client.StatementStats;
import com.facebook.presto.common.ErrorCode;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.resourceGroups.QueryType;
import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.HistoryBasedPlanStatisticsManager;
import com.facebook.presto.cost.HistoryBasedPlanStatisticsTracker;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.event.QueryMonitor;
import com.facebook.presto.execution.DDLDefinitionTask;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.QueryIdGenerator;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateTimer;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.execution.StageExecutionId;
import com.facebook.presto.execution.StageExecutionInfo;
import com.facebook.presto.execution.StageExecutionState;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.warnings.WarningCollectorFactory;
import com.facebook.presto.memory.NodeMemoryConfig;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControlUtils;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.QuerySessionSupplier;
import com.facebook.presto.server.SessionContext;
import com.facebook.presto.server.SessionPropertyDefaults;
import com.facebook.presto.server.protocol.QueryResourceUtil;
import com.facebook.presto.server.security.SecurityConfig;
import com.facebook.presto.spark.ErrorClassifier;
import com.facebook.presto.spark.PrestoSparkAccessControlChecker;
import com.facebook.presto.spark.PrestoSparkAuthenticatorProvider;
import com.facebook.presto.spark.PrestoSparkConfig;
import com.facebook.presto.spark.PrestoSparkCredentialsProvider;
import com.facebook.presto.spark.PrestoSparkMetadataStorage;
import com.facebook.presto.spark.PrestoSparkQueryData;
import com.facebook.presto.spark.PrestoSparkQueryStatusInfo;
import com.facebook.presto.spark.PrestoSparkRetryExecutionSettings;
import com.facebook.presto.spark.PrestoSparkServiceWaitTimeMetrics;
import com.facebook.presto.spark.PrestoSparkSessionContext;
import com.facebook.presto.spark.PrestoSparkSessionProperties;
import com.facebook.presto.spark.PrestoSparkSettingsRequirements;
import com.facebook.presto.spark.PrestoSparkTaskDescriptor;
import com.facebook.presto.spark.SparkErrorCode;
import com.facebook.presto.spark.classloader_interface.IPrestoSparkQueryExecution;
import com.facebook.presto.spark.classloader_interface.IPrestoSparkQueryExecutionFactory;
import com.facebook.presto.spark.classloader_interface.PrestoSparkConfInitializer;
import com.facebook.presto.spark.classloader_interface.PrestoSparkExecutionException;
import com.facebook.presto.spark.classloader_interface.PrestoSparkFatalException;
import com.facebook.presto.spark.classloader_interface.PrestoSparkSession;
import com.facebook.presto.spark.classloader_interface.PrestoSparkShuffleStats;
import com.facebook.presto.spark.classloader_interface.PrestoSparkTaskExecutorFactoryProvider;
import com.facebook.presto.spark.classloader_interface.RetryExecutionStrategy;
import com.facebook.presto.spark.classloader_interface.SerializedTaskInfo;
import com.facebook.presto.spark.execution.PrestoSparkAdaptiveQueryExecution;
import com.facebook.presto.spark.execution.PrestoSparkDataDefinitionExecution;
import com.facebook.presto.spark.execution.PrestoSparkExecutionExceptionFactory;
import com.facebook.presto.spark.execution.PrestoSparkStaticQueryExecution;
import com.facebook.presto.spark.execution.PrestoSparkTaskExecutorFactory;
import com.facebook.presto.spark.planner.PrestoSparkPlanFragmenter;
import com.facebook.presto.spark.planner.PrestoSparkQueryPlanner;
import com.facebook.presto.spark.planner.PrestoSparkRddFactory;
import com.facebook.presto.spark.util.PrestoSparkFailureUtils;
import com.facebook.presto.spark.util.PrestoSparkRetryExecutionUtils;
import com.facebook.presto.spark.util.PrestoSparkTransactionUtils;
import com.facebook.presto.spark.util.PrestoSparkUtils;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.analyzer.AnalyzerOptions;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.storage.TempStorage;
import com.facebook.presto.sql.analyzer.BuiltInQueryPreparer;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.utils.StatementUtils;
import com.facebook.presto.sql.planner.PartitioningProviderManager;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.storage.TempStorageManager;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.util.AnalyzerUtil;
import com.facebook.presto.util.Failures;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.base.Verify;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.io.BaseEncoding;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.api.java.JavaFutureAction;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.util.CollectionAccumulator;
import org.joda.time.DateTime;
import scala.Option;

public class PrestoSparkQueryExecutionFactory
implements IPrestoSparkQueryExecutionFactory {
    private static final Logger log = Logger.get(PrestoSparkQueryExecutionFactory.class);
    public static final String PRESTO_QUERY_ID_CONFIG = "presto_query_id";
    private final QueryIdGenerator queryIdGenerator;
    private final QuerySessionSupplier sessionSupplier;
    private final BuiltInQueryPreparer queryPreparer;
    private final PrestoSparkQueryPlanner queryPlanner;
    private final PrestoSparkAccessControlChecker accessControlChecker;
    private final PrestoSparkPlanFragmenter planFragmenter;
    private final PrestoSparkRddFactory rddFactory;
    private final PrestoSparkMetadataStorage metadataStorage;
    private final QueryMonitor queryMonitor;
    private final Codec<TaskInfo> taskInfoCodec;
    private final JsonCodec<PrestoSparkTaskDescriptor> sparkTaskDescriptorJsonCodec;
    private final JsonCodec<PrestoSparkQueryStatusInfo> queryStatusInfoJsonCodec;
    private final JsonCodec<PrestoSparkQueryData> queryDataJsonCodec;
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private final Metadata metadata;
    private final BlockEncodingManager blockEncodingManager;
    private final PrestoSparkSettingsRequirements settingsRequirements;
    private final PrestoSparkExecutionExceptionFactory executionExceptionFactory;
    private final PrestoSparkTaskExecutorFactory prestoSparkTaskExecutorFactory;
    private final SessionPropertyDefaults sessionPropertyDefaults;
    private final WarningCollectorFactory warningCollectorFactory;
    private final PartitioningProviderManager partitioningProviderManager;
    private final Set<PrestoSparkCredentialsProvider> credentialsProviders;
    private final Set<PrestoSparkAuthenticatorProvider> authenticatorProviders;
    private final TempStorageManager tempStorageManager;
    private final String storageBasedBroadcastJoinStorage;
    private final NodeMemoryConfig nodeMemoryConfig;
    private final FeaturesConfig featuresConfig;
    private final QueryManagerConfig queryManagerConfig;
    private final SecurityConfig securityConfig;
    private final Set<PrestoSparkServiceWaitTimeMetrics> waitTimeMetrics;
    private final Map<Class<? extends Statement>, DataDefinitionTask<?>> ddlTasks;
    private final Optional<ErrorClassifier> errorClassifier;
    private final HistoryBasedPlanStatisticsTracker historyBasedPlanStatisticsTracker;

    @Inject
    public PrestoSparkQueryExecutionFactory(QueryIdGenerator queryIdGenerator, QuerySessionSupplier sessionSupplier, BuiltInQueryPreparer queryPreparer, PrestoSparkQueryPlanner queryPlanner, PrestoSparkAccessControlChecker accessControlChecker, PrestoSparkPlanFragmenter planFragmenter, PrestoSparkRddFactory rddFactory, PrestoSparkMetadataStorage metadataStorage, QueryMonitor queryMonitor, Codec<TaskInfo> taskInfoCodec, JsonCodec<PrestoSparkTaskDescriptor> sparkTaskDescriptorJsonCodec, JsonCodec<PrestoSparkQueryStatusInfo> queryStatusInfoJsonCodec, JsonCodec<PrestoSparkQueryData> queryDataJsonCodec, TransactionManager transactionManager, AccessControl accessControl, Metadata metadata, BlockEncodingManager blockEncodingManager, PrestoSparkSettingsRequirements settingsRequirements, PrestoSparkExecutionExceptionFactory executionExceptionFactory, PrestoSparkTaskExecutorFactory prestoSparkTaskExecutorFactory, SessionPropertyDefaults sessionPropertyDefaults, WarningCollectorFactory warningCollectorFactory, PartitioningProviderManager partitioningProviderManager, Set<PrestoSparkCredentialsProvider> credentialsProviders, Set<PrestoSparkAuthenticatorProvider> authenticatorProviders, TempStorageManager tempStorageManager, PrestoSparkConfig prestoSparkConfig, NodeMemoryConfig nodeMemoryConfig, FeaturesConfig featuresConfig, QueryManagerConfig queryManagerConfig, SecurityConfig securityConfig, Set<PrestoSparkServiceWaitTimeMetrics> waitTimeMetrics, Map<Class<? extends Statement>, DataDefinitionTask<?>> ddlTasks, Optional<ErrorClassifier> errorClassifier, HistoryBasedPlanStatisticsManager historyBasedPlanStatisticsManager) {
        this.queryIdGenerator = Objects.requireNonNull(queryIdGenerator, "queryIdGenerator is null");
        this.sessionSupplier = Objects.requireNonNull(sessionSupplier, "sessionSupplier is null");
        this.queryPreparer = Objects.requireNonNull(queryPreparer, "queryPreparer is null");
        this.queryPlanner = Objects.requireNonNull(queryPlanner, "queryPlanner is null");
        this.accessControlChecker = Objects.requireNonNull(accessControlChecker, "accessControlChecker is null");
        this.planFragmenter = Objects.requireNonNull(planFragmenter, "planFragmenter is null");
        this.rddFactory = Objects.requireNonNull(rddFactory, "rddFactory is null");
        this.metadataStorage = Objects.requireNonNull(metadataStorage, "metadataStorage is null");
        this.queryMonitor = Objects.requireNonNull(queryMonitor, "queryMonitor is null");
        this.taskInfoCodec = Objects.requireNonNull(taskInfoCodec, "taskInfoCodec is null");
        this.sparkTaskDescriptorJsonCodec = Objects.requireNonNull(sparkTaskDescriptorJsonCodec, "sparkTaskDescriptorJsonCodec is null");
        this.queryStatusInfoJsonCodec = Objects.requireNonNull(queryStatusInfoJsonCodec, "queryStatusInfoJsonCodec is null");
        this.queryDataJsonCodec = Objects.requireNonNull(queryDataJsonCodec, "queryDataJsonCodec is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.blockEncodingManager = Objects.requireNonNull(blockEncodingManager, "blockEncodingManager is null");
        this.settingsRequirements = Objects.requireNonNull(settingsRequirements, "settingsRequirements is null");
        this.executionExceptionFactory = Objects.requireNonNull(executionExceptionFactory, "executionExceptionFactory is null");
        this.prestoSparkTaskExecutorFactory = Objects.requireNonNull(prestoSparkTaskExecutorFactory, "prestoSparkTaskExecutorFactory is null");
        this.sessionPropertyDefaults = Objects.requireNonNull(sessionPropertyDefaults, "sessionPropertyDefaults is null");
        this.warningCollectorFactory = Objects.requireNonNull(warningCollectorFactory, "warningCollectorFactory is null");
        this.partitioningProviderManager = Objects.requireNonNull(partitioningProviderManager, "partitioningProviderManager is null");
        this.credentialsProviders = ImmutableSet.copyOf((Collection)Objects.requireNonNull(credentialsProviders, "credentialsProviders is null"));
        this.authenticatorProviders = ImmutableSet.copyOf((Collection)Objects.requireNonNull(authenticatorProviders, "authenticatorProviders is null"));
        this.tempStorageManager = Objects.requireNonNull(tempStorageManager, "tempStorageManager is null");
        this.storageBasedBroadcastJoinStorage = Objects.requireNonNull(prestoSparkConfig, "prestoSparkConfig is null").getStorageBasedBroadcastJoinStorage();
        this.nodeMemoryConfig = Objects.requireNonNull(nodeMemoryConfig, "nodeMemoryConfig is null");
        this.featuresConfig = Objects.requireNonNull(featuresConfig, "featuresConfig is null");
        this.queryManagerConfig = Objects.requireNonNull(queryManagerConfig, "queryManagerConfig is null");
        this.securityConfig = Objects.requireNonNull(securityConfig, "securityConfig is null");
        this.waitTimeMetrics = ImmutableSet.copyOf((Collection)Objects.requireNonNull(waitTimeMetrics, "waitTimeMetrics is null"));
        this.ddlTasks = ImmutableMap.copyOf(Objects.requireNonNull(ddlTasks, "ddlTasks is null"));
        this.errorClassifier = Objects.requireNonNull(errorClassifier, "errorClassifier is null");
        this.historyBasedPlanStatisticsTracker = Objects.requireNonNull(historyBasedPlanStatisticsManager, "historyBasedPlanStatisticsManager is null").getHistoryBasedPlanStatisticsTracker();
    }

    public static QueryInfo createQueryInfo(Session session, String query, QueryState queryState, Optional<PrestoSparkQueryPlanner.PlanAndMore> planAndMore, Optional<String> sparkQueueName, Optional<ExecutionFailureInfo> failureInfo, QueryStateTimer queryStateTimer, Optional<StageInfo> rootStage, WarningCollector warningCollector) {
        Preconditions.checkArgument((failureInfo.isPresent() || queryState != QueryState.FAILED ? 1 : 0) != 0, (String)"unexpected query state: %s", (Object)queryState);
        int peakRunningTasks = 0;
        long peakUserMemoryReservationInBytes = 0L;
        long peakTotalMemoryReservationInBytes = 0L;
        long peakTaskUserMemoryInBytes = 0L;
        long peakTaskTotalMemoryInBytes = 0L;
        long peakNodeTotalMemoryInBytes = 0L;
        List allStages = StageInfo.getAllStages(rootStage);
        for (StageInfo stageInfo : allStages) {
            StageExecutionInfo stageExecutionInfo = stageInfo.getLatestAttemptExecutionInfo();
            for (TaskInfo taskInfo : stageExecutionInfo.getTasks()) {
                ++peakRunningTasks;
                long taskPeakUserMemoryInBytes = taskInfo.getStats().getPeakUserMemoryInBytes();
                long taskPeakTotalMemoryInBytes = taskInfo.getStats().getPeakTotalMemoryInBytes();
                peakUserMemoryReservationInBytes += taskPeakUserMemoryInBytes;
                peakTotalMemoryReservationInBytes += taskPeakTotalMemoryInBytes;
                peakTaskUserMemoryInBytes = Math.max(peakTaskUserMemoryInBytes, taskPeakUserMemoryInBytes);
                peakTaskTotalMemoryInBytes = Math.max(peakTaskTotalMemoryInBytes, taskPeakTotalMemoryInBytes);
                peakNodeTotalMemoryInBytes = Math.max(taskInfo.getStats().getPeakNodeTotalMemoryInBytes(), peakNodeTotalMemoryInBytes);
            }
        }
        QueryStats queryStats = QueryStats.create((QueryStateTimer)queryStateTimer, rootStage, (List)allStages, (int)peakRunningTasks, (DataSize)DataSize.succinctBytes((long)peakUserMemoryReservationInBytes), (DataSize)DataSize.succinctBytes((long)peakTotalMemoryReservationInBytes), (DataSize)DataSize.succinctBytes((long)peakTaskUserMemoryInBytes), (DataSize)DataSize.succinctBytes((long)peakTaskTotalMemoryInBytes), (DataSize)DataSize.succinctBytes((long)peakNodeTotalMemoryInBytes), (RuntimeStats)session.getRuntimeStats());
        return new QueryInfo(session.getQueryId(), session.toSessionRepresentation(), queryState, new MemoryPoolId("spark-memory-pool"), queryStats.isScheduled(), URI.create("http://fake.invalid/query/" + session.getQueryId()), planAndMore.map(PrestoSparkQueryPlanner.PlanAndMore::getFieldNames).orElse((List)ImmutableList.of()), query, Optional.empty(), Optional.empty(), queryStats, Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), (Set)ImmutableSet.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Set)ImmutableSet.of(), Optional.empty(), false, (String)planAndMore.flatMap(PrestoSparkQueryPlanner.PlanAndMore::getUpdateType).orElse(null), rootStage, (ExecutionFailureInfo)failureInfo.orElse(null), (ErrorCode)failureInfo.map(ExecutionFailureInfo::getErrorCode).orElse(null), warningCollector.getWarnings(), planAndMore.map(PrestoSparkQueryPlanner.PlanAndMore::getInputs).orElse((Set)ImmutableSet.of()), planAndMore.flatMap(PrestoSparkQueryPlanner.PlanAndMore::getOutput), queryState.isDone(), sparkQueueName.map(ResourceGroupId::new), planAndMore.flatMap(PrestoSparkQueryPlanner.PlanAndMore::getQueryType), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), (Set)ImmutableSet.of(), planAndMore.map(PrestoSparkQueryPlanner.PlanAndMore::getPlan).map(Plan::getStatsAndCosts).orElseGet(StatsAndCosts::empty), (List)ImmutableList.of(), (Set)ImmutableSet.of(), (Set)ImmutableSet.of(), (Set)ImmutableSet.of(), planAndMore.map(PrestoSparkQueryPlanner.PlanAndMore::getPlanCanonicalInfo).orElseGet(ImmutableList::of));
    }

    public static StageInfo createStageInfo(QueryId queryId, SubPlan plan, List<TaskInfo> taskInfos) {
        ArrayListMultimap taskInfoMap = ArrayListMultimap.create();
        for (TaskInfo taskInfo : taskInfos) {
            PlanFragmentId fragmentId = new PlanFragmentId(taskInfo.getTaskId().getStageExecutionId().getStageId().getId());
            taskInfoMap.put((Object)fragmentId, (Object)taskInfo);
        }
        return PrestoSparkQueryExecutionFactory.createStageInfo(queryId, plan, (ListMultimap<PlanFragmentId, TaskInfo>)taskInfoMap);
    }

    public static StageInfo createStageInfo(QueryId queryId, SubPlan plan, ListMultimap<PlanFragmentId, TaskInfo> taskInfoMap) {
        PlanFragmentId planFragmentId = plan.getFragment().getId();
        StageId stageId = new StageId(queryId, planFragmentId.getId());
        List taskInfos = taskInfoMap.get((Object)planFragmentId);
        long peakUserMemoryReservationInBytes = 0L;
        long peakNodeTotalMemoryReservationInBytes = 0L;
        for (TaskInfo taskInfo : taskInfos) {
            long taskPeakUserMemoryInBytes = taskInfo.getStats().getUserMemoryReservationInBytes();
            peakUserMemoryReservationInBytes += taskPeakUserMemoryInBytes;
            peakNodeTotalMemoryReservationInBytes = Math.max(taskInfo.getStats().getPeakNodeTotalMemoryInBytes(), peakNodeTotalMemoryReservationInBytes);
        }
        StageExecutionInfo stageExecutionInfo = StageExecutionInfo.create((StageExecutionId)new StageExecutionId(stageId, 0), (StageExecutionState)StageExecutionState.FINISHED, Optional.empty(), (List)taskInfos, (DateTime)DateTime.now(), (Distribution.DistributionSnapshot)new Distribution().snapshot(), (DataSize)DataSize.succinctBytes((long)peakUserMemoryReservationInBytes), (DataSize)DataSize.succinctBytes((long)peakNodeTotalMemoryReservationInBytes), (int)1, (int)1);
        return new StageInfo(stageId, URI.create("http://fake.invalid/stage/" + stageId), Optional.of(plan.getFragment()), stageExecutionInfo, (List)ImmutableList.of(), (List)plan.getChildren().stream().map(child -> PrestoSparkQueryExecutionFactory.createStageInfo(queryId, child, taskInfoMap)).collect(ImmutableList.toImmutableList()), false);
    }

    public static PrestoSparkQueryStatusInfo createPrestoSparkQueryInfo(QueryInfo queryInfo, Optional<PrestoSparkQueryPlanner.PlanAndMore> planAndMore, WarningCollector warningCollector, OptionalLong updateCount) {
        StatementStats stats = QueryResourceUtil.toStatementStats((QueryInfo)queryInfo);
        stats = new StatementStats(stats.getState(), stats.isWaitingForPrerequisites(), stats.isQueued(), stats.isScheduled(), stats.getNodes(), stats.getTotalSplits(), stats.getQueuedSplits(), stats.getRunningSplits(), stats.getCompletedSplits(), stats.getCpuTimeMillis(), stats.getWallTimeMillis(), stats.getWaitingForPrerequisitesTimeMillis(), stats.getQueuedTimeMillis(), stats.getElapsedTimeMillis(), stats.getProcessedRows(), stats.getProcessedBytes(), stats.getPeakMemoryBytes(), stats.getPeakTotalMemoryBytes(), stats.getPeakTaskTotalMemoryBytes(), stats.getSpilledBytes(), null, null);
        return new PrestoSparkQueryStatusInfo(queryInfo.getQueryId().getId(), planAndMore.map(PrestoSparkQueryExecutionFactory::getOutputColumns), stats, Optional.ofNullable(queryInfo.getFailureInfo()).map(PrestoSparkQueryExecutionFactory::toQueryError), warningCollector.getWarnings(), planAndMore.flatMap(PrestoSparkQueryPlanner.PlanAndMore::getUpdateType), updateCount);
    }

    public static List<Column> getOutputColumns(PrestoSparkQueryPlanner.PlanAndMore planAndMore) {
        ImmutableList.Builder result = ImmutableList.builder();
        List<String> columnNames = planAndMore.getFieldNames();
        List columnTypes = (List)planAndMore.getPlan().getRoot().getOutputVariables().stream().map(VariableReferenceExpression::getType).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (String)"Column names and types size mismatch: %s != %s", (int)columnNames.size(), (int)columnTypes.size());
        for (int i = 0; i < columnNames.size(); ++i) {
            result.add((Object)new Column(columnNames.get(i), (Type)columnTypes.get(i)));
        }
        return result.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void waitForActionsCompletionWithTimeout(Collection<JavaFutureAction<T>> actions, long timeout, TimeUnit timeUnit, Set<PrestoSparkServiceWaitTimeMetrics> waitTimeMetrics) throws SparkException, TimeoutException {
        long deadline = System.currentTimeMillis() + timeUnit.toMillis(timeout);
        try {
            for (JavaFutureAction<T> action : actions) {
                long nextTimeoutInMillis = deadline - System.currentTimeMillis();
                if (nextTimeoutInMillis <= 0L) {
                    throw new TimeoutException();
                }
                PrestoSparkUtils.getActionResultWithTimeout(action, nextTimeoutInMillis, TimeUnit.MILLISECONDS, waitTimeMetrics);
            }
        }
        finally {
            for (JavaFutureAction<T> action : actions) {
                if (action.isDone()) continue;
                action.cancel(true);
            }
        }
    }

    private static QueryError toQueryError(ExecutionFailureInfo executionFailureInfo) {
        ErrorCode errorCode = executionFailureInfo.getErrorCode() != null ? executionFailureInfo.getErrorCode() : StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode();
        return new QueryError((String)MoreObjects.firstNonNull((Object)executionFailureInfo.getMessage(), (Object)"Internal error"), null, errorCode.getCode(), errorCode.getName(), errorCode.getType().toString(), errorCode.isRetriable(), executionFailureInfo.getErrorLocation(), executionFailureInfo.toFailureInfo());
    }

    public IPrestoSparkQueryExecution create(SparkContext sparkContext, PrestoSparkSession prestoSparkSession, Optional<String> sqlText, Optional<String> sqlLocation, Optional<String> sqlFileHexHash, Optional<String> sqlFileSizeInBytes, Optional<String> sparkQueueName, PrestoSparkTaskExecutorFactoryProvider executorFactoryProvider, Optional<String> queryStatusInfoOutputLocation, Optional<String> queryDataOutputLocation, Optional<RetryExecutionStrategy> retryExecutionStrategy, Optional<CollectionAccumulator<Map<String, Long>>> bootstrapMetricsCollector) {
        String sql;
        PrestoSparkConfInitializer.checkInitialized((SparkContext)sparkContext);
        if (sqlText.isPresent()) {
            Preconditions.checkArgument((!sqlLocation.isPresent() ? 1 : 0) != 0, (Object)"sqlText and sqlLocation should not be set at the same time");
            sql = sqlText.get();
        } else {
            Preconditions.checkArgument((boolean)sqlLocation.isPresent(), (Object)"sqlText or sqlLocation must be present");
            byte[] sqlFileBytes = this.metadataStorage.read(sqlLocation.get());
            if (sqlFileSizeInBytes.isPresent() && Integer.valueOf(sqlFileSizeInBytes.get()) != sqlFileBytes.length) {
                throw new PrestoException((ErrorCodeSupplier)SparkErrorCode.MALFORMED_QUERY_FILE, String.format("sql file size %s is different from expected sqlFileSizeInBytes %s", sqlFileBytes.length, sqlFileSizeInBytes.get()));
            }
            if (sqlFileHexHash.isPresent()) {
                try {
                    MessageDigest md = MessageDigest.getInstance("SHA-512");
                    String actualHexHashCode = BaseEncoding.base16().lowerCase().encode(md.digest(sqlFileBytes));
                    if (!sqlFileHexHash.get().equals(actualHexHashCode)) {
                        throw new PrestoException((ErrorCodeSupplier)SparkErrorCode.MALFORMED_QUERY_FILE, String.format("actual hash code %s is different from expected sqlFileHexHash %s", actualHexHashCode, sqlFileHexHash.get()));
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "unsupported hash algorithm", (Throwable)e);
                }
            }
            sql = new String(sqlFileBytes, StandardCharsets.UTF_8);
        }
        log.info("Query: %s", new Object[]{sql});
        QueryStateTimer queryStateTimer = new QueryStateTimer(Ticker.systemTicker());
        queryStateTimer.beginPlanning();
        QueryId queryId = this.queryIdGenerator.createNextQueryId();
        log.info("Starting execution for presto query: %s", new Object[]{queryId});
        System.out.printf("Query id: %s\n", queryId);
        sparkContext.conf().set(PRESTO_QUERY_ID_CONFIG, queryId.getId());
        PrestoSparkSessionContext sessionContext = PrestoSparkSessionContext.createFromSessionInfo(prestoSparkSession, this.credentialsProviders, this.authenticatorProviders);
        AccessControlUtils.checkPermissions((AccessControl)this.accessControl, (SecurityConfig)this.securityConfig, (QueryId)queryId, (SessionContext)sessionContext);
        Optional authorizedIdentity = AccessControlUtils.getAuthorizedIdentity((AccessControl)this.accessControl, (SecurityConfig)this.securityConfig, (QueryId)queryId, (SessionContext)sessionContext);
        Session session = this.sessionSupplier.createSession(queryId, (SessionContext)sessionContext, this.warningCollectorFactory, authorizedIdentity);
        session = this.sessionPropertyDefaults.newSessionWithDefaultProperties(session, Optional.empty(), Optional.empty());
        if (retryExecutionStrategy.isPresent()) {
            PrestoSparkRetryExecutionSettings prestoSparkRetryExecutionSettings = PrestoSparkRetryExecutionUtils.getRetryExecutionSettings(retryExecutionStrategy.get(), session);
            prestoSparkRetryExecutionSettings.getSparkSettings().forEach((arg_0, arg_1) -> ((SparkConf)sparkContext.conf()).set(arg_0, arg_1));
            Session.SessionBuilder sessionBuilder = Session.builder((Session)session);
            prestoSparkRetryExecutionSettings.getPrestoSettings().forEach((arg_0, arg_1) -> ((Session.SessionBuilder)sessionBuilder).setSystemProperty(arg_0, arg_1));
            HashSet<String> clientTags = new HashSet<String>(session.getClientTags());
            clientTags.add(retryExecutionStrategy.get().name());
            sessionBuilder.setClientTags(clientTags);
            session = sessionBuilder.build();
        }
        WarningCollector warningCollector = session.getWarningCollector();
        PrestoSparkQueryPlanner.PlanAndMore planAndMore = null;
        try {
            TransactionId transactionId = this.transactionManager.beginTransaction(true);
            session = session.beginTransactionId(transactionId, this.transactionManager, this.accessControl);
            this.queryMonitor.queryCreatedEvent(new BasicQueryInfo(PrestoSparkQueryExecutionFactory.createQueryInfo(session, sql, QueryState.PLANNING, Optional.empty(), sparkQueueName, Optional.empty(), queryStateTimer, Optional.empty(), warningCollector)));
            Duration queryMaxRunTime = SystemSessionProperties.getQueryMaxRunTime((Session)session);
            Duration queryMaxExecutionTime = SystemSessionProperties.getQueryMaxExecutionTime((Session)session);
            Duration queryTimeout = queryMaxRunTime.compareTo(queryMaxExecutionTime) < 0 ? queryMaxRunTime : queryMaxExecutionTime;
            long queryCompletionDeadline = System.currentTimeMillis() + queryTimeout.toMillis();
            this.settingsRequirements.verify(sparkContext, session);
            queryStateTimer.beginAnalyzing();
            AnalyzerOptions analyzerOptions = AnalyzerUtil.createAnalyzerOptions((Session)session, (WarningCollector)warningCollector);
            BuiltInQueryPreparer.BuiltInPreparedQuery preparedQuery = this.queryPreparer.prepareQuery(analyzerOptions, sql, session.getPreparedStatements(), warningCollector);
            Optional queryType = StatementUtils.getQueryType(preparedQuery.getStatement().getClass());
            if (queryType.isPresent() && (queryType.get() == QueryType.DATA_DEFINITION || queryType.get() == QueryType.CONTROL)) {
                queryStateTimer.endAnalysis();
                DDLDefinitionTask task = (DDLDefinitionTask)this.ddlTasks.get(preparedQuery.getStatement().getClass());
                return new PrestoSparkDataDefinitionExecution<Statement>(task, preparedQuery.getStatement(), this.transactionManager, this.accessControl, this.metadata, session, queryStateTimer, warningCollector);
            }
            if (preparedQuery.isExplainTypeValidate()) {
                return this.accessControlChecker.createExecution(session, preparedQuery, queryStateTimer, warningCollector);
            }
            planAndMore = this.queryPlanner.createQueryPlan(session, preparedQuery, warningCollector);
            JavaSparkContext javaSparkContext = new JavaSparkContext(sparkContext);
            CollectionAccumulator taskInfoCollector = new CollectionAccumulator();
            taskInfoCollector.register(sparkContext, Option.empty(), false);
            CollectionAccumulator shuffleStatsCollector = new CollectionAccumulator();
            shuffleStatsCollector.register(sparkContext, Option.empty(), false);
            TempStorage tempStorage = this.tempStorageManager.getTempStorage(this.storageBasedBroadcastJoinStorage);
            queryStateTimer.endAnalysis();
            if (!PrestoSparkSessionProperties.isAdaptiveQueryExecutionEnabled(session)) {
                return new PrestoSparkStaticQueryExecution(javaSparkContext, session, this.queryMonitor, (CollectionAccumulator<SerializedTaskInfo>)taskInfoCollector, (CollectionAccumulator<PrestoSparkShuffleStats>)shuffleStatsCollector, this.prestoSparkTaskExecutorFactory, executorFactoryProvider, queryStateTimer, warningCollector, sql, planAndMore, sparkQueueName, this.taskInfoCodec, this.sparkTaskDescriptorJsonCodec, this.queryStatusInfoJsonCodec, this.queryDataJsonCodec, this.rddFactory, this.transactionManager, PrestoSparkUtils.createPagesSerde(this.blockEncodingManager), this.executionExceptionFactory, queryTimeout, queryCompletionDeadline, this.metadataStorage, queryStatusInfoOutputLocation, queryDataOutputLocation, tempStorage, this.nodeMemoryConfig, this.featuresConfig, this.queryManagerConfig, this.waitTimeMetrics, this.errorClassifier, this.planFragmenter, this.metadata, this.partitioningProviderManager, this.historyBasedPlanStatisticsTracker, bootstrapMetricsCollector);
            }
            return new PrestoSparkAdaptiveQueryExecution(javaSparkContext, session, this.queryMonitor, (CollectionAccumulator<SerializedTaskInfo>)taskInfoCollector, (CollectionAccumulator<PrestoSparkShuffleStats>)shuffleStatsCollector, this.prestoSparkTaskExecutorFactory, executorFactoryProvider, queryStateTimer, warningCollector, sql, planAndMore, sparkQueueName, this.taskInfoCodec, this.sparkTaskDescriptorJsonCodec, this.queryStatusInfoJsonCodec, this.queryDataJsonCodec, this.rddFactory, this.transactionManager, PrestoSparkUtils.createPagesSerde(this.blockEncodingManager), this.executionExceptionFactory, queryTimeout, queryCompletionDeadline, this.metadataStorage, queryStatusInfoOutputLocation, queryDataOutputLocation, tempStorage, this.nodeMemoryConfig, this.featuresConfig, this.queryManagerConfig, this.waitTimeMetrics, this.errorClassifier, this.planFragmenter, this.metadata, this.partitioningProviderManager, this.historyBasedPlanStatisticsTracker, bootstrapMetricsCollector);
        }
        catch (Throwable executionFailure) {
            queryStateTimer.beginFinishing();
            try {
                PrestoSparkTransactionUtils.rollback(session, this.transactionManager);
            }
            catch (RuntimeException rollbackFailure) {
                log.error((Throwable)rollbackFailure, "Encountered error when performing rollback");
            }
            queryStateTimer.endQuery();
            Optional<ExecutionFailureInfo> failureInfo = Optional.empty();
            if (executionFailure instanceof PrestoSparkExecutionException) {
                failureInfo = this.executionExceptionFactory.extractExecutionFailureInfo((PrestoSparkExecutionException)executionFailure);
                Verify.verify((boolean)failureInfo.isPresent());
            }
            if (!failureInfo.isPresent()) {
                failureInfo = Optional.of(Failures.toFailure((Throwable)executionFailure));
            }
            try {
                QueryInfo queryInfo = PrestoSparkQueryExecutionFactory.createQueryInfo(session, sql, QueryState.FAILED, Optional.ofNullable(planAndMore), sparkQueueName, failureInfo, queryStateTimer, Optional.empty(), warningCollector);
                this.queryMonitor.queryCompletedEvent(queryInfo);
                if (queryStatusInfoOutputLocation.isPresent()) {
                    PrestoSparkQueryStatusInfo prestoSparkQueryStatusInfo = PrestoSparkQueryExecutionFactory.createPrestoSparkQueryInfo(queryInfo, Optional.ofNullable(planAndMore), warningCollector, OptionalLong.empty());
                    this.metadataStorage.write(queryStatusInfoOutputLocation.get(), this.queryStatusInfoJsonCodec.toJsonBytes((Object)prestoSparkQueryStatusInfo));
                }
            }
            catch (RuntimeException eventFailure) {
                log.error((Throwable)eventFailure, "Error publishing query immediate failure event");
            }
            if (this.isFatalException(executionFailure)) {
                throw executionFailure;
            }
            throw PrestoSparkFailureUtils.toPrestoSparkFailure(session, failureInfo.get());
        }
    }

    private boolean isFatalException(Throwable t) {
        return t instanceof PrestoSparkFatalException;
    }
}

