/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.spark.PhysicalResourceSettings;
import com.facebook.presto.spark.PrestoSparkSessionProperties;
import com.facebook.presto.spark.PrestoSparkSourceStatsCollector;
import com.facebook.presto.spi.plan.PlanNode;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import java.util.OptionalInt;

public class PrestoSparkPhysicalResourceCalculator {
    private static final Logger log = Logger.get(PrestoSparkPhysicalResourceCalculator.class);

    public PhysicalResourceSettings calculate(PlanNode plan, PrestoSparkSourceStatsCollector prestoSparkSourceStatsCollector, Session session) {
        int hashPartitionCount = SystemSessionProperties.getHashPartitionCount((Session)session);
        OptionalInt maxExecutorCount = OptionalInt.empty();
        PhysicalResourceSettings defaultResourceSettings = new PhysicalResourceSettings(hashPartitionCount, maxExecutorCount);
        if (!PrestoSparkPhysicalResourceCalculator.anyAllocationStrategyEnabled(session)) {
            log.info(String.format("ResourceAllocationStrategy disabled. Executing query %s with %s", session.getQueryId(), defaultResourceSettings));
            return defaultResourceSettings;
        }
        double inputDataInBytes = prestoSparkSourceStatsCollector.collectSourceStats(plan);
        DataSize inputSize = new DataSize(inputDataInBytes, DataSize.Unit.BYTE);
        if (inputDataInBytes < 0.0) {
            log.warn(String.format("Input data statistics missing, inputDataInBytes=%.2f skipping automatic resource tuning. Executing query %s with %s", inputDataInBytes, session.getQueryId(), defaultResourceSettings));
            return defaultResourceSettings;
        }
        if (Double.isNaN(inputDataInBytes)) {
            log.warn(String.format("Failed to retrieve correct size, inputDataInBytes=%.2f skipping automatic resource tuning. Executing query %s with %s", inputDataInBytes, session.getQueryId(), defaultResourceSettings));
            return defaultResourceSettings;
        }
        if (PrestoSparkSessionProperties.isSparkResourceAllocationStrategyEnabled(session) || PrestoSparkSessionProperties.isSparkHashPartitionCountAllocationStrategyEnabled(session)) {
            hashPartitionCount = PrestoSparkPhysicalResourceCalculator.calculateHashPartitionCount(session, inputSize);
        }
        if (PrestoSparkSessionProperties.isSparkResourceAllocationStrategyEnabled(session) || PrestoSparkSessionProperties.isSparkExecutorAllocationStrategyEnabled(session)) {
            maxExecutorCount = OptionalInt.of(PrestoSparkPhysicalResourceCalculator.calculateExecutorCount(session, inputSize));
        }
        PhysicalResourceSettings finalResourceSettings = new PhysicalResourceSettings(hashPartitionCount, maxExecutorCount);
        log.info(String.format("Executing query %s with %s based on resource allocation strategy", session.getQueryId(), finalResourceSettings));
        return finalResourceSettings;
    }

    private static boolean anyAllocationStrategyEnabled(Session session) {
        return PrestoSparkSessionProperties.isSparkResourceAllocationStrategyEnabled(session) || PrestoSparkSessionProperties.isSparkExecutorAllocationStrategyEnabled(session) || PrestoSparkSessionProperties.isSparkHashPartitionCountAllocationStrategyEnabled(session);
    }

    private static int calculateExecutorCount(Session session, DataSize inputData) {
        int minExecutorCount = PrestoSparkSessionProperties.getMinExecutorCount(session);
        int maxExecutorCount = PrestoSparkSessionProperties.getMaxExecutorCount(session);
        Preconditions.checkState((maxExecutorCount >= minExecutorCount && minExecutorCount > 0 ? 1 : 0) != 0, (Object)String.format("maxExecutorCount: %d needs to greater than or equal to maxExecutorCount : %d", maxExecutorCount, maxExecutorCount));
        long averageInputDataSizePerExecutorInBytes = PrestoSparkSessionProperties.getAverageInputDataSizePerExecutor(session).toBytes();
        int calculatedNumberOfExecutors = (int)(inputData.toBytes() / averageInputDataSizePerExecutorInBytes);
        return Math.max(minExecutorCount, Math.min(maxExecutorCount, calculatedNumberOfExecutors));
    }

    private static int calculateHashPartitionCount(Session session, DataSize inputDataInGB) {
        int minHashPartitionCount;
        int maxHashPartitionCount = PrestoSparkSessionProperties.getMaxHashPartitionCount(session);
        Preconditions.checkState((maxHashPartitionCount >= (minHashPartitionCount = PrestoSparkSessionProperties.getMinHashPartitionCount(session)) && minHashPartitionCount > 0 ? 1 : 0) != 0, (Object)String.format("maxHashPartitionCount : %d needs to greater than  or equal to minHashPartitionCount : %d", maxHashPartitionCount, minHashPartitionCount));
        long averageInputDataSizePerPartitionInBytes = PrestoSparkSessionProperties.getAverageInputDataSizePerPartition(session).toBytes();
        int calculatedNumberOfPartitions = (int)(inputDataInGB.toBytes() / averageInputDataSizePerPartitionInBytes);
        return Math.max(minHashPartitionCount, Math.min(maxHashPartitionCount, calculatedNumberOfPartitions));
    }
}

