/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.OptionalInt;

public class PhysicalResourceSettings {
    private final OptionalInt maxExecutorCount;
    private final int hashPartitionCount;

    public PhysicalResourceSettings(int hashPartitionCount, OptionalInt maxExecutorCount) {
        Preconditions.checkArgument((maxExecutorCount.orElse(0) >= 0 && hashPartitionCount >= 0 ? 1 : 0) != 0, (Object)"executorCount and hashPartitionCount should be positive");
        this.maxExecutorCount = maxExecutorCount;
        this.hashPartitionCount = hashPartitionCount;
    }

    public int getHashPartitionCount() {
        return this.hashPartitionCount;
    }

    public OptionalInt getMaxExecutorCount() {
        return this.maxExecutorCount;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("maxExecutorCount", (Object)this.maxExecutorCount).add("hashPartitionCount", this.hashPartitionCount).toString();
    }
}

