/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.planner;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.BasePlanFragmenter;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanFragmenterUtils;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.sanity.PlanChecker;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class IterativePlanFragmenter {
    private final Function<PlanFragmentId, Boolean> isFragmentFinished;
    private final Plan originalPlan;
    private final Metadata metadata;
    private final PlanChecker planChecker;
    private final SqlParser sqlParser;
    private final PlanNodeIdAllocator idAllocator;
    private final PlanVariableAllocator variableAllocator;
    private final NodePartitioningManager nodePartitioningManager;
    private final QueryManagerConfig queryManagerConfig;
    private final Session session;
    private final WarningCollector warningCollector;
    private final boolean forceSingleNode;
    private int nextFragmentId = 1;
    private final Map<PlanFragmentId, SubPlan> subPlanByFragmentId = new HashMap<PlanFragmentId, SubPlan>();

    public IterativePlanFragmenter(Plan originalPlan, Function<PlanFragmentId, Boolean> isFragmentFinished, Metadata metadata, PlanChecker planChecker, SqlParser sqlParser, PlanNodeIdAllocator idAllocator, NodePartitioningManager nodePartitioningManager, QueryManagerConfig queryManagerConfig, Session session, WarningCollector warningCollector, boolean forceSingleNode) {
        this.originalPlan = Objects.requireNonNull(originalPlan, "originalPlan is null");
        this.isFragmentFinished = Objects.requireNonNull(isFragmentFinished, "isSourceReady is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.planChecker = Objects.requireNonNull(planChecker, "planChecker is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        this.variableAllocator = new PlanVariableAllocator((Collection)originalPlan.getTypes().allVariables());
        this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
        this.queryManagerConfig = Objects.requireNonNull(queryManagerConfig, "queryManagerConfig is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        this.forceSingleNode = forceSingleNode;
    }

    public PlanAndFragments createReadySubPlans(PlanNode plan) {
        Optional<Object> remainingPlan;
        List subPlans;
        PlanNode planRoot;
        IterativeFragmenter iterativeFragmenter = new IterativeFragmenter(this.session, this.metadata, this.originalPlan.getStatsAndCosts(), this.planChecker, this.warningCollector, this.sqlParser, this.idAllocator, this.variableAllocator, PlanFragmenterUtils.getTableWriterNodeIds((PlanNode)plan));
        BasePlanFragmenter.FragmentProperties properties = new BasePlanFragmenter.FragmentProperties(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (Collection)ImmutableList.of()), plan.getOutputVariables()));
        if (this.forceSingleNode || SystemSessionProperties.isForceSingleNodeOutput((Session)this.session)) {
            properties = properties.setSingleNodeDistribution();
        }
        if (this.isFragmentReadyForExecution(planRoot = SimplePlanRewriter.rewriteWith((SimplePlanRewriter)iterativeFragmenter, (PlanNode)plan, (Object)properties))) {
            subPlans = ImmutableList.of((Object)iterativeFragmenter.buildRootFragment(planRoot, properties));
            remainingPlan = Optional.empty();
        } else {
            subPlans = properties.getChildren();
            remainingPlan = Optional.of(planRoot);
        }
        subPlans = (List)subPlans.stream().filter(subPlan -> !this.subPlanByFragmentId.containsKey(subPlan.getFragment().getId())).collect(ImmutableList.toImmutableList());
        subPlans.forEach(subPlan -> this.subPlanByFragmentId.putIfAbsent(subPlan.getFragment().getId(), (SubPlan)subPlan));
        subPlans = (List)subPlans.stream().map(subPlan -> PlanFragmenterUtils.finalizeSubPlan((SubPlan)subPlan, (QueryManagerConfig)this.queryManagerConfig, (Metadata)this.metadata, (NodePartitioningManager)this.nodePartitioningManager, (Session)this.session, (boolean)this.forceSingleNode, (WarningCollector)this.warningCollector)).collect(ImmutableList.toImmutableList());
        return new PlanAndFragments(remainingPlan, subPlans);
    }

    private boolean isFragmentReadyForExecution(PlanNode node) {
        return node.getSources().stream().allMatch(source -> (Boolean)source.accept((PlanVisitor)new ExecutionReadinessChecker(), null));
    }

    public static class PlanAndFragments {
        private final Optional<PlanNode> remainingPlan;
        private final List<SubPlan> readyFragments;

        private PlanAndFragments(Optional<PlanNode> remainingPlan, List<SubPlan> readyFragments) {
            this.remainingPlan = Objects.requireNonNull(remainingPlan, "remainingPlan is null");
            this.readyFragments = ImmutableList.copyOf((Collection)Objects.requireNonNull(readyFragments, "readyFragments is null"));
        }

        public Optional<PlanNode> getRemainingPlan() {
            return this.remainingPlan;
        }

        public List<SubPlan> getReadyFragments() {
            return this.readyFragments;
        }

        public int hashCode() {
            return Objects.hash(this.remainingPlan, this.readyFragments);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            PlanAndFragments other = (PlanAndFragments)obj;
            return Objects.equals(this.remainingPlan, other.remainingPlan) && Objects.equals(this.readyFragments, other.readyFragments);
        }
    }

    private class IterativeFragmenter
    extends BasePlanFragmenter {
        public IterativeFragmenter(Session session, Metadata metadata, StatsAndCosts statsAndCosts, PlanChecker planChecker, WarningCollector warningCollector, SqlParser sqlParser, PlanNodeIdAllocator idAllocator, PlanVariableAllocator variableAllocator, Set<PlanNodeId> outputTableWriterNodeIds) {
            super(session, metadata, statsAndCosts, planChecker, warningCollector, sqlParser, idAllocator, variableAllocator, outputTableWriterNodeIds);
        }

        public PlanNode visitExchange(ExchangeNode node, SimplePlanRewriter.RewriteContext<BasePlanFragmenter.FragmentProperties> context) {
            if (IterativePlanFragmenter.this.isFragmentReadyForExecution((PlanNode)node)) {
                return super.visitExchange(node, context);
            }
            return context.defaultRewrite((PlanNode)node, context.get());
        }

        public PlanNode visitRemoteSource(RemoteSourceNode node, SimplePlanRewriter.RewriteContext<BasePlanFragmenter.FragmentProperties> context) {
            List childSubPlans = (List)node.getSourceFragmentIds().stream().map(id -> (SubPlan)IterativePlanFragmenter.this.subPlanByFragmentId.get(id)).collect(ImmutableList.toImmutableList());
            ((BasePlanFragmenter.FragmentProperties)context.get()).addChildren(childSubPlans);
            return (PlanNode)super.visitRemoteSource(node, context);
        }

        public PlanFragmentId nextFragmentId() {
            return new PlanFragmentId(IterativePlanFragmenter.this.nextFragmentId++);
        }
    }

    private class ExecutionReadinessChecker
    extends InternalPlanVisitor<Boolean, Void> {
        private ExecutionReadinessChecker() {
        }

        public Boolean visitPlan(PlanNode node, Void context) {
            return node.getSources().stream().allMatch(source -> (Boolean)source.accept((PlanVisitor)this, (Object)context));
        }

        public Boolean visitExchange(ExchangeNode node, Void context) {
            if (node.getScope() != ExchangeNode.Scope.LOCAL) {
                return false;
            }
            return this.visitPlan((PlanNode)node, context);
        }

        public Boolean visitRemoteSource(RemoteSourceNode node, Void context) {
            return node.getSourceFragmentIds().stream().allMatch(IterativePlanFragmenter.this.isFragmentFinished::apply);
        }
    }
}

