/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution.property;

import com.facebook.airlift.configuration.Config;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class NativeExecutionSystemConfig {
    private static final String CONCURRENT_LIFESPANS_PER_TASK = "concurrent-lifespans-per-task";
    private static final String ENABLE_SERIALIZED_PAGE_CHECKSUM = "enable-serialized-page-checksum";
    private static final String ENABLE_VELOX_EXPRESSION_LOGGING = "enable_velox_expression_logging";
    private static final String ENABLE_VELOX_TASK_LOGGING = "enable_velox_task_logging";
    private static final String HTTP_SERVER_HTTP_PORT = "http-server.http.port";
    private static final String HTTP_EXEC_THREADS = "http_exec_threads";
    private static final String NUM_IO_THREADS = "num-io-threads";
    private static final String PRESTO_VERSION = "presto.version";
    private static final String SHUTDOWN_ONSET_SEC = "shutdown-onset-sec";
    private static final String SYSTEM_MEMORY_GB = "system-memory-gb";
    private static final String TASK_MAX_DRIVERS_PER_TASK = "task.max-drivers-per-task";
    private static final String DISCOVERY_URI = "discovery.uri";
    private boolean enableSerializedPageChecksum = true;
    private boolean enableVeloxExpressionLogging;
    private boolean enableVeloxTaskLogging = true;
    private int httpServerPort = 7777;
    private int httpExecThreads = 32;
    private int numIoThreads = 30;
    private int shutdownOnsetSec = 10;
    private int systemMemoryGb = 10;
    private int concurrentLifespansPerTask = 5;
    private int maxDriversPerTask = 15;
    private String prestoVersion = "dummy.presto.version";
    private String discoveryUri = "http://127.0.0.1";

    public Map<String, String> getAllProperties() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        return builder.put((Object)CONCURRENT_LIFESPANS_PER_TASK, (Object)String.valueOf(this.getConcurrentLifespansPerTask())).put((Object)ENABLE_SERIALIZED_PAGE_CHECKSUM, (Object)String.valueOf(this.isEnableSerializedPageChecksum())).put((Object)ENABLE_VELOX_EXPRESSION_LOGGING, (Object)String.valueOf(this.isEnableVeloxExpressionLogging())).put((Object)ENABLE_VELOX_TASK_LOGGING, (Object)String.valueOf(this.isEnableVeloxTaskLogging())).put((Object)HTTP_SERVER_HTTP_PORT, (Object)String.valueOf(this.getHttpServerPort())).put((Object)HTTP_EXEC_THREADS, (Object)String.valueOf(this.getHttpExecThreads())).put((Object)NUM_IO_THREADS, (Object)String.valueOf(this.getNumIoThreads())).put((Object)PRESTO_VERSION, (Object)this.getPrestoVersion()).put((Object)SHUTDOWN_ONSET_SEC, (Object)String.valueOf(this.getShutdownOnsetSec())).put((Object)SYSTEM_MEMORY_GB, (Object)String.valueOf(this.getSystemMemoryGb())).put((Object)TASK_MAX_DRIVERS_PER_TASK, (Object)String.valueOf(this.getMaxDriversPerTask())).put((Object)DISCOVERY_URI, (Object)this.getDiscoveryUri()).build();
    }

    @Config(value="enable-serialized-page-checksum")
    public NativeExecutionSystemConfig setEnableSerializedPageChecksum(boolean enableSerializedPageChecksum) {
        this.enableSerializedPageChecksum = enableSerializedPageChecksum;
        return this;
    }

    public boolean isEnableSerializedPageChecksum() {
        return this.enableSerializedPageChecksum;
    }

    @Config(value="enable_velox_expression_logging")
    public NativeExecutionSystemConfig setEnableVeloxExpressionLogging(boolean enableVeloxExpressionLogging) {
        this.enableVeloxExpressionLogging = enableVeloxExpressionLogging;
        return this;
    }

    public boolean isEnableVeloxExpressionLogging() {
        return this.enableVeloxExpressionLogging;
    }

    @Config(value="enable_velox_task_logging")
    public NativeExecutionSystemConfig setEnableVeloxTaskLogging(boolean enableVeloxTaskLogging) {
        this.enableVeloxTaskLogging = enableVeloxTaskLogging;
        return this;
    }

    public boolean isEnableVeloxTaskLogging() {
        return this.enableVeloxTaskLogging;
    }

    @Config(value="http-server.http.port")
    public NativeExecutionSystemConfig setHttpServerPort(int httpServerPort) {
        this.httpServerPort = httpServerPort;
        return this;
    }

    public int getHttpServerPort() {
        return this.httpServerPort;
    }

    @Config(value="http_exec_threads")
    public NativeExecutionSystemConfig setHttpExecThreads(int httpExecThreads) {
        this.httpExecThreads = httpExecThreads;
        return this;
    }

    public int getHttpExecThreads() {
        return this.httpExecThreads;
    }

    @Config(value="num-io-threads")
    public NativeExecutionSystemConfig setNumIoThreads(int numIoThreads) {
        this.numIoThreads = numIoThreads;
        return this;
    }

    public int getNumIoThreads() {
        return this.numIoThreads;
    }

    @Config(value="shutdown-onset-sec")
    public NativeExecutionSystemConfig setShutdownOnsetSec(int shutdownOnsetSec) {
        this.shutdownOnsetSec = shutdownOnsetSec;
        return this;
    }

    public int getShutdownOnsetSec() {
        return this.shutdownOnsetSec;
    }

    @Config(value="system-memory-gb")
    public NativeExecutionSystemConfig setSystemMemoryGb(int systemMemoryGb) {
        this.systemMemoryGb = systemMemoryGb;
        return this;
    }

    public int getSystemMemoryGb() {
        return this.systemMemoryGb;
    }

    @Config(value="discovery.uri")
    public NativeExecutionSystemConfig setDiscoveryUri(String discoveryUri) {
        this.discoveryUri = discoveryUri;
        return this;
    }

    public String getDiscoveryUri() {
        return this.discoveryUri;
    }

    @Config(value="concurrent-lifespans-per-task")
    public NativeExecutionSystemConfig setConcurrentLifespansPerTask(int concurrentLifespansPerTask) {
        this.concurrentLifespansPerTask = concurrentLifespansPerTask;
        return this;
    }

    public int getConcurrentLifespansPerTask() {
        return this.concurrentLifespansPerTask;
    }

    @Config(value="task.max-drivers-per-task")
    public NativeExecutionSystemConfig setMaxDriversPerTask(int maxDriversPerTask) {
        this.maxDriversPerTask = maxDriversPerTask;
        return this;
    }

    public int getMaxDriversPerTask() {
        return this.maxDriversPerTask;
    }

    @Config(value="presto.version")
    public NativeExecutionSystemConfig setPrestoVersion(String prestoVersion) {
        this.prestoVersion = prestoVersion;
        return this;
    }

    public String getPrestoVersion() {
        return this.prestoVersion;
    }
}

