/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution.operator;

import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.execution.ScheduledSplit;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PipelineExecutionStrategy;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.operator.SplitOperatorInfo;
import com.facebook.presto.spark.execution.NativeExecutionProcess;
import com.facebook.presto.spark.execution.NativeExecutionProcessFactory;
import com.facebook.presto.spark.execution.NativeExecutionTask;
import com.facebook.presto.spark.execution.NativeExecutionTaskFactory;
import com.facebook.presto.spi.UpdatablePageSource;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.NativeExecutionNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;

public class NativeExecutionOperator
implements SourceOperator {
    private static final Logger log = Logger.get(NativeExecutionOperator.class);
    private static final String NATIVE_EXECUTION_SERVER_URI = "http://127.0.0.1";
    private final PlanNodeId sourceId;
    private final OperatorContext operatorContext;
    private final LocalMemoryContext systemMemoryContext;
    private final PlanFragment planFragment;
    private final TableWriteInfo tableWriteInfo;
    private final PagesSerde serde;
    private final NativeExecutionProcessFactory processFactory;
    private final NativeExecutionTaskFactory taskFactory;
    private NativeExecutionProcess process;
    private NativeExecutionTask task;
    private CompletableFuture<Void> taskStatusFuture;
    private TaskSource taskSource;
    private boolean finished;

    public NativeExecutionOperator(PlanNodeId sourceId, OperatorContext operatorContext, PlanFragment planFragment, TableWriteInfo tableWriteInfo, PagesSerde serde, NativeExecutionProcessFactory processFactory, NativeExecutionTaskFactory taskFactory) {
        this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.systemMemoryContext = operatorContext.localSystemMemoryContext();
        this.planFragment = Objects.requireNonNull(planFragment, "planFragment is null");
        this.tableWriteInfo = Objects.requireNonNull(tableWriteInfo, "tableWriteInfo is null");
        this.serde = Objects.requireNonNull(serde, "serde is null");
        this.processFactory = Objects.requireNonNull(processFactory, "processFactory is null");
        this.taskFactory = Objects.requireNonNull(taskFactory, "taskFactory is null");
    }

    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    public boolean needsInput() {
        return false;
    }

    public void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    public Page getOutput() {
        if (this.finished) {
            return null;
        }
        if (this.process == null) {
            this.createProcess();
            Preconditions.checkState((this.process != null ? 1 : 0) != 0, (Object)"process is null");
            this.createTask();
            Preconditions.checkState((this.task != null ? 1 : 0) != 0, (Object)"task is null");
            this.taskStatusFuture = this.task.start();
        }
        try {
            if (this.taskStatusFuture.isDone()) {
                this.taskStatusFuture.get();
                Optional<TaskInfo> taskInfo = this.task.getTaskInfo();
                taskInfo.ifPresent(info -> info.getTaskStatus().getFailures().forEach(e -> log.error((Throwable)e.toException())));
                Optional<SerializedPage> page = this.task.pollResult();
                if (page.isPresent()) {
                    return this.processResult(page.get());
                }
                this.finished = true;
                return null;
            }
            Optional<SerializedPage> page = this.task.pollResult();
            return page.map(this::processResult).orElse(null);
        }
        catch (InterruptedException | ExecutionException e) {
            log.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void createProcess() {
        try {
            this.process = this.processFactory.createNativeExecutionProcess(this.operatorContext.getSession(), URI.create(NATIVE_EXECUTION_SERVER_URI));
            this.process.start();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private void createTask() {
        Preconditions.checkState((this.taskSource != null ? 1 : 0) != 0, (Object)"taskSource is null");
        Preconditions.checkState((this.taskStatusFuture == null ? 1 : 0) != 0, (Object)"taskStatusFuture has already been set");
        Preconditions.checkState((this.task == null ? 1 : 0) != 0, (Object)"task has already been set");
        Preconditions.checkState((this.process != null ? 1 : 0) != 0, (Object)"process is null");
        this.task = this.taskFactory.createNativeExecutionTask(this.operatorContext.getSession(), HttpUriBuilder.uriBuilderFrom((URI)URI.create(NATIVE_EXECUTION_SERVER_URI)).port(this.process.getPort()).build(), this.operatorContext.getDriverContext().getTaskId(), this.planFragment, (List<TaskSource>)ImmutableList.of((Object)this.taskSource), this.tableWriteInfo);
    }

    private Page processResult(SerializedPage page) {
        this.operatorContext.recordRawInput((long)page.getSizeInBytes(), (long)page.getPositionCount());
        Page deserializedPage = this.serde.deserialize(page);
        this.operatorContext.recordProcessedInput(deserializedPage.getSizeInBytes(), (long)page.getPositionCount());
        return deserializedPage;
    }

    public void finish() {
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    public Supplier<Optional<UpdatablePageSource>> addSplit(ScheduledSplit split) {
        Objects.requireNonNull(split, "split is null");
        Preconditions.checkState((this.taskSource == null ? 1 : 0) != 0, (Object)"NativeEngine operator split already set");
        if (this.finished) {
            return Optional::empty;
        }
        this.taskSource = new TaskSource(split.getPlanNodeId(), (Set)ImmutableSet.of((Object)split), true);
        Object splitInfo = split.getSplit().getInfo();
        Map infoMap = split.getSplit().getInfoMap();
        if (infoMap != null && !infoMap.isEmpty()) {
            this.operatorContext.setInfoSupplier((Supplier)Suppliers.ofInstance((Object)new SplitOperatorInfo(infoMap)));
        } else if (splitInfo != null) {
            this.operatorContext.setInfoSupplier((Supplier)Suppliers.ofInstance((Object)new SplitOperatorInfo(splitInfo)));
        }
        return Optional::empty;
    }

    public void noMoreSplits() {
    }

    public void close() {
        this.systemMemoryContext.setBytes(0L);
        if (this.task != null) {
            this.task.stop();
        }
        if (this.process != null) {
            this.process.close();
        }
    }

    public static class NativeExecutionOperatorTranslator
    extends LocalExecutionPlanner.CustomPlanTranslator {
        private final PlanFragment fragment;
        private final Session session;
        private final BlockEncodingSerde blockEncodingSerde;
        private final NativeExecutionProcessFactory processFactory;
        private final NativeExecutionTaskFactory taskFactory;

        public NativeExecutionOperatorTranslator(Session session, PlanFragment fragment, BlockEncodingSerde blockEncodingSerde, NativeExecutionProcessFactory processFactory, NativeExecutionTaskFactory taskFactory) {
            this.fragment = Objects.requireNonNull(fragment, "fragment is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
            this.processFactory = Objects.requireNonNull(processFactory, "processFactory is null");
            this.taskFactory = Objects.requireNonNull(taskFactory, "taskFactory is null");
        }

        public Optional<LocalExecutionPlanner.PhysicalOperation> translate(PlanNode node, LocalExecutionPlanner.LocalExecutionPlanContext context, InternalPlanVisitor<LocalExecutionPlanner.PhysicalOperation, LocalExecutionPlanner.LocalExecutionPlanContext> visitor) {
            if (node instanceof NativeExecutionNode) {
                NativeExecutionOperatorFactory operatorFactory = new NativeExecutionOperatorFactory(context.getNextOperatorId(), node.getId(), this.fragment.withSubPlan(((NativeExecutionNode)node).getSubPlan()), context.getTableWriteInfo(), new PagesSerdeFactory(this.blockEncodingSerde, SystemSessionProperties.isExchangeCompressionEnabled((Session)this.session), SystemSessionProperties.isExchangeChecksumEnabled((Session)this.session)), this.processFactory, this.taskFactory);
                return Optional.of(new LocalExecutionPlanner.PhysicalOperation((OperatorFactory)operatorFactory, (Map)this.makeLayout(node), context, PipelineExecutionStrategy.UNGROUPED_EXECUTION));
            }
            return Optional.empty();
        }
    }

    public static class NativeExecutionOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final PlanFragment planFragment;
        private final TableWriteInfo tableWriteInfo;
        private final PagesSerdeFactory serdeFactory;
        private final NativeExecutionProcessFactory processFactory;
        private final NativeExecutionTaskFactory taskFactory;
        private boolean closed;

        public NativeExecutionOperatorFactory(int operatorId, PlanNodeId planNodeId, PlanFragment planFragment, TableWriteInfo tableWriteInfo, PagesSerdeFactory serdeFactory, NativeExecutionProcessFactory processFactory, NativeExecutionTaskFactory taskFactory) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.planFragment = Objects.requireNonNull(planFragment, "planFragment is null");
            this.tableWriteInfo = Objects.requireNonNull(tableWriteInfo, "tableWriteInfo is null");
            this.serdeFactory = Objects.requireNonNull(serdeFactory, "serdeFactory is null");
            this.processFactory = Objects.requireNonNull(processFactory, "processFactory is null");
            this.taskFactory = Objects.requireNonNull(taskFactory, "taskFactory is null");
        }

        public PlanNodeId getSourceId() {
            return this.planNodeId;
        }

        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"operator factory is closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, NativeExecutionOperator.class.getSimpleName());
            return new NativeExecutionOperator(this.planNodeId, operatorContext, this.planFragment, this.tableWriteInfo, this.serdeFactory.createPagesSerde(), this.processFactory, this.taskFactory);
        }

        public void noMoreOperators() {
            this.closed = true;
        }

        public PlanFragment getPlanFragment() {
            return this.planFragment;
        }
    }
}

