/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution.http;

import com.facebook.airlift.http.client.BodyGenerator;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpStatus;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.Response;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.http.client.StaticBodyGenerator;
import com.facebook.airlift.http.client.StatusResponseHandler;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.operator.HttpRpcShuffleClient;
import com.facebook.presto.operator.PageBufferClient;
import com.facebook.presto.operator.RpcShuffleClient;
import com.facebook.presto.server.RequestHelpers;
import com.facebook.presto.server.TaskUpdateRequest;
import com.facebook.presto.server.smile.AdaptingJsonResponseHandler;
import com.facebook.presto.server.smile.BaseResponse;
import com.facebook.presto.sql.planner.PlanFragment;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class PrestoSparkHttpTaskClient
implements RpcShuffleClient {
    private static final Logger log = Logger.get(PrestoSparkHttpTaskClient.class);
    private static final String TASK_URI = "/v1/task/";
    private final HttpClient httpClient;
    private final URI location;
    private final URI taskUri;
    private final TaskId taskId;
    private final JsonCodec<TaskInfo> taskInfoCodec;
    private final JsonCodec<PlanFragment> planFragmentCodec;
    private final JsonCodec<TaskUpdateRequest> taskUpdateRequestCodec;
    private final Duration infoRefreshMaxWait;

    public PrestoSparkHttpTaskClient(HttpClient httpClient, TaskId taskId, URI location, JsonCodec<TaskInfo> taskInfoCodec, JsonCodec<PlanFragment> planFragmentCodec, JsonCodec<TaskUpdateRequest> taskUpdateRequestCodec, Duration infoRefreshMaxWait) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.taskId = Objects.requireNonNull(taskId, "taskId is null");
        this.location = Objects.requireNonNull(location, "location is null");
        this.taskInfoCodec = Objects.requireNonNull(taskInfoCodec, "taskInfoCodec is null");
        this.planFragmentCodec = Objects.requireNonNull(planFragmentCodec, "planFragmentCodec is null");
        this.taskUpdateRequestCodec = Objects.requireNonNull(taskUpdateRequestCodec, "taskUpdateRequestCodec is null");
        this.taskUri = this.getTaskUri(location, taskId);
        this.infoRefreshMaxWait = Objects.requireNonNull(infoRefreshMaxWait, "infoRefreshMaxWait is null");
    }

    public ListenableFuture<PageBufferClient.PagesResponse> getResults(long token, DataSize maxResponseSize) {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.taskUri).appendPath("/results/0").appendPath(String.valueOf(token)).build();
        return this.httpClient.executeAsync(Request.Builder.prepareGet().setHeader("X-Presto-Max-Size", maxResponseSize.toString()).setUri(uri).build(), (ResponseHandler)new HttpRpcShuffleClient.PageResponseHandler());
    }

    public void acknowledgeResultsAsync(long nextToken) {
        final URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.taskUri).appendPath("/results/0").appendPath(String.valueOf(nextToken)).appendPath("acknowledge").build();
        this.httpClient.executeAsync(Request.Builder.prepareGet().setUri(uri).build(), (ResponseHandler)new ResponseHandler<Void, RuntimeException>(){

            public Void handleException(Request request, Exception exception) {
                log.debug((Throwable)exception, "Acknowledge request failed: %s", new Object[]{uri});
                return null;
            }

            public Void handle(Request request, Response response) {
                if (HttpStatus.familyForStatusCode((int)response.getStatusCode()) != HttpStatus.Family.SUCCESSFUL) {
                    log.debug("Unexpected acknowledge response code: %s", new Object[]{response.getStatusCode()});
                }
                return null;
            }
        });
    }

    public ListenableFuture<?> abortResults() {
        return this.httpClient.executeAsync(Request.Builder.prepareDelete().setUri(this.taskUri).build(), (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
    }

    public Throwable rewriteException(Throwable throwable) {
        return null;
    }

    public ListenableFuture<BaseResponse<TaskInfo>> getTaskInfo() {
        Request request = RequestHelpers.setContentTypeHeaders((boolean)false, (Request.Builder)Request.Builder.prepareGet()).setHeader("X-Presto-Max-Wait", this.infoRefreshMaxWait.toString()).setUri(this.taskUri).build();
        AdaptingJsonResponseHandler responseHandler = AdaptingJsonResponseHandler.createAdaptingJsonResponseHandler(this.taskInfoCodec);
        return this.httpClient.executeAsync(request, (ResponseHandler)responseHandler);
    }

    public ListenableFuture<BaseResponse<TaskInfo>> updateTask(List<TaskSource> sources, PlanFragment planFragment, TableWriteInfo tableWriteInfo, Session session, OutputBuffers outputBuffers) {
        Optional<byte[]> fragment = Optional.of(planFragment.toBytes(this.planFragmentCodec));
        Optional<TableWriteInfo> writeInfo = Optional.of(tableWriteInfo);
        TaskUpdateRequest updateRequest = new TaskUpdateRequest(session.toSessionRepresentation(), session.getIdentity().getExtraCredentials(), fragment, sources, outputBuffers, writeInfo);
        return this.httpClient.executeAsync(RequestHelpers.setContentTypeHeaders((boolean)false, (Request.Builder)Request.Builder.preparePost()).setUri(this.taskUri).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((byte[])this.taskUpdateRequestCodec.toBytes((Object)updateRequest))).build(), (ResponseHandler)AdaptingJsonResponseHandler.createAdaptingJsonResponseHandler(this.taskInfoCodec));
    }

    public URI getLocation() {
        return this.location;
    }

    private URI getTaskUri(URI baseUri, TaskId taskId) {
        return HttpUriBuilder.uriBuilderFrom((URI)baseUri).appendPath(TASK_URI).appendPath(taskId.toString()).build();
    }
}

