/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.airlift.concurrent.BoundedExecutor;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.Session;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.server.TaskUpdateRequest;
import com.facebook.presto.spark.execution.ForNativeExecutionTask;
import com.facebook.presto.spark.execution.NativeExecutionTask;
import com.facebook.presto.sql.planner.PlanFragment;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class NativeExecutionTaskFactory {
    private static final int MAX_THREADS = 1000;
    private final HttpClient httpClient;
    private final ExecutorService coreExecutor;
    private final Executor executor;
    private final ScheduledExecutorService updateScheduledExecutor;
    private final JsonCodec<TaskInfo> taskInfoCodec;
    private final JsonCodec<PlanFragment> planFragmentCodec;
    private final JsonCodec<TaskUpdateRequest> taskUpdateRequestCodec;
    private final TaskManagerConfig taskManagerConfig;

    @Inject
    public NativeExecutionTaskFactory(@ForNativeExecutionTask HttpClient httpClient, ExecutorService coreExecutor, ScheduledExecutorService updateScheduledExecutor, JsonCodec<TaskInfo> taskInfoCodec, JsonCodec<PlanFragment> planFragmentCodec, JsonCodec<TaskUpdateRequest> taskUpdateRequestCodec, TaskManagerConfig taskManagerConfig) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.coreExecutor = Objects.requireNonNull(coreExecutor, "coreExecutor is null");
        this.executor = new BoundedExecutor((Executor)coreExecutor, 1000);
        this.updateScheduledExecutor = Objects.requireNonNull(updateScheduledExecutor, "updateScheduledExecutor is null");
        this.taskInfoCodec = Objects.requireNonNull(taskInfoCodec, "taskInfoCodec is null");
        this.planFragmentCodec = Objects.requireNonNull(planFragmentCodec, "planFragmentCodec is null");
        this.taskUpdateRequestCodec = Objects.requireNonNull(taskUpdateRequestCodec, "taskUpdateRequestCodec is null");
        this.taskManagerConfig = Objects.requireNonNull(taskManagerConfig, "taskManagerConfig is null");
    }

    public NativeExecutionTask createNativeExecutionTask(Session session, URI location, TaskId taskId, PlanFragment fragment, List<TaskSource> sources, TableWriteInfo tableWriteInfo) {
        return new NativeExecutionTask(session, location, taskId, fragment, sources, this.httpClient, tableWriteInfo, this.executor, this.updateScheduledExecutor, this.taskInfoCodec, this.planFragmentCodec, this.taskUpdateRequestCodec, this.taskManagerConfig);
    }

    @PreDestroy
    public void stop() {
        this.coreExecutor.shutdownNow();
        this.updateScheduledExecutor.shutdownNow();
    }
}

