/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.server.TaskUpdateRequest;
import com.facebook.presto.server.smile.BaseResponse;
import com.facebook.presto.spark.execution.HttpNativeExecutionTaskInfoFetcher;
import com.facebook.presto.spark.execution.HttpNativeExecutionTaskResultFetcher;
import com.facebook.presto.spark.execution.http.PrestoSparkHttpTaskClient;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.sql.planner.PlanFragment;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

public class NativeExecutionTask {
    private static final Logger log = Logger.get(NativeExecutionTask.class);
    private final Session session;
    private final PlanFragment planFragment;
    private final OutputBuffers outputBuffers;
    private final PrestoSparkHttpTaskClient workerClient;
    private final TableWriteInfo tableWriteInfo;
    private final List<TaskSource> sources;
    private final Executor executor;
    private final HttpNativeExecutionTaskInfoFetcher taskInfoFetcher;
    private final HttpNativeExecutionTaskResultFetcher taskResultFetcher;

    public NativeExecutionTask(Session session, URI location, TaskId taskId, PlanFragment planFragment, List<TaskSource> sources, HttpClient httpClient, TableWriteInfo tableWriteInfo, Executor executor, ScheduledExecutorService updateScheduledExecutor, JsonCodec<TaskInfo> taskInfoCodec, JsonCodec<PlanFragment> planFragmentCodec, JsonCodec<TaskUpdateRequest> taskUpdateRequestCodec, TaskManagerConfig taskManagerConfig) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.planFragment = Objects.requireNonNull(planFragment, "planFragment is null");
        this.tableWriteInfo = Objects.requireNonNull(tableWriteInfo, "tableWriteInfo is null");
        this.sources = Objects.requireNonNull(sources, "sources is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.outputBuffers = OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED);
        Objects.requireNonNull(taskManagerConfig, "taskManagerConfig is null");
        this.workerClient = new PrestoSparkHttpTaskClient(Objects.requireNonNull(httpClient, "httpClient is null"), taskId, location, taskInfoCodec, planFragmentCodec, taskUpdateRequestCodec, taskManagerConfig.getInfoRefreshMaxWait());
        Objects.requireNonNull(updateScheduledExecutor, "updateScheduledExecutor is null");
        this.taskInfoFetcher = new HttpNativeExecutionTaskInfoFetcher(updateScheduledExecutor, this.workerClient, this.executor, taskManagerConfig.getInfoUpdateInterval());
        this.taskResultFetcher = new HttpNativeExecutionTaskResultFetcher(updateScheduledExecutor, this.workerClient);
    }

    public Optional<TaskInfo> getTaskInfo() {
        return this.taskInfoFetcher.getTaskInfo();
    }

    public Optional<SerializedPage> pollResult() throws InterruptedException {
        return this.taskResultFetcher.pollPage();
    }

    public CompletableFuture<Void> start() {
        CompletionStage updateFuture = this.sendUpdateRequest().handle((result, t) -> {
            if (t != null) {
                throw new CompletionException(t.getCause());
            }
            this.taskInfoFetcher.start();
            return null;
        });
        return ((CompletableFuture)updateFuture).thenCombine(this.taskResultFetcher.start(), (r1, r2) -> null);
    }

    public void stop() {
        this.taskInfoFetcher.stop();
        this.taskResultFetcher.stop();
    }

    private CompletableFuture<Void> sendUpdateRequest() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Futures.addCallback(this.workerClient.updateTask(this.sources, this.planFragment, this.tableWriteInfo, this.session, this.outputBuffers), (FutureCallback)new UpdateResponseHandler(future), (Executor)this.executor);
        return future;
    }

    private class UpdateResponseHandler
    implements FutureCallback<BaseResponse<TaskInfo>> {
        private final CompletableFuture<Void> future;

        public UpdateResponseHandler(CompletableFuture<Void> future) {
            this.future = Objects.requireNonNull(future, "future is null");
        }

        public void onSuccess(BaseResponse<TaskInfo> result) {
            TaskInfo value = (TaskInfo)result.getValue();
            log.debug("success %s", new Object[]{value.getTaskId()});
            this.future.complete(null);
        }

        public void onFailure(Throwable t) {
            log.error("failed %s", new Object[]{t});
            this.future.completeExceptionally(t);
        }
    }
}

