/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.server.smile.BaseResponse;
import com.facebook.presto.spark.execution.http.PrestoSparkHttpTaskClient;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;

public class HttpNativeExecutionTaskInfoFetcher {
    private static final Logger log = Logger.get(HttpNativeExecutionTaskInfoFetcher.class);
    private final PrestoSparkHttpTaskClient workerClient;
    private final ScheduledExecutorService updateScheduledExecutor;
    private final AtomicReference<TaskInfo> taskInfo = new AtomicReference();
    private final Executor executor;
    private final Duration infoFetchInterval;
    @GuardedBy(value="this")
    private ScheduledFuture<?> scheduledFuture;

    public HttpNativeExecutionTaskInfoFetcher(ScheduledExecutorService updateScheduledExecutor, PrestoSparkHttpTaskClient workerClient, Executor executor, Duration infoFetchInterval) {
        this.workerClient = Objects.requireNonNull(workerClient, "workerClient is null");
        this.updateScheduledExecutor = Objects.requireNonNull(updateScheduledExecutor, "updateScheduledExecutor is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.infoFetchInterval = Objects.requireNonNull(infoFetchInterval, "infoFetchInterval is null");
    }

    public void start() {
        this.scheduledFuture = this.updateScheduledExecutor.scheduleWithFixedDelay(() -> {
            ListenableFuture<BaseResponse<TaskInfo>> taskInfoFuture = this.workerClient.getTaskInfo();
            Futures.addCallback(taskInfoFuture, (FutureCallback)new FutureCallback<BaseResponse<TaskInfo>>(){

                public void onSuccess(BaseResponse<TaskInfo> result) {
                    log.debug("TaskInfoCallback success %s", new Object[]{((TaskInfo)result.getValue()).getTaskId()});
                    HttpNativeExecutionTaskInfoFetcher.this.taskInfo.set(result.getValue());
                }

                public void onFailure(Throwable t) {
                    log.error("TaskInfoCallback failed %s", new Object[]{t});
                }
            }, (Executor)this.executor);
        }, 0L, (long)this.infoFetchInterval.getValue(), this.infoFetchInterval.getUnit());
    }

    public void stop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
    }

    public Optional<TaskInfo> getTaskInfo() {
        TaskInfo info = this.taskInfo.get();
        return info == null ? Optional.empty() : Optional.of(info);
    }
}

