/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.json.JsonModule;
import com.facebook.airlift.json.smile.SmileModule;
import com.facebook.presto.eventlistener.EventListenerManager;
import com.facebook.presto.eventlistener.EventListenerModule;
import com.facebook.presto.execution.resourceGroups.ResourceGroupManager;
import com.facebook.presto.execution.warnings.WarningCollectorModule;
import com.facebook.presto.metadata.StaticCatalogStore;
import com.facebook.presto.metadata.StaticFunctionNamespaceStore;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.security.AccessControlManager;
import com.facebook.presto.security.AccessControlModule;
import com.facebook.presto.server.PluginManager;
import com.facebook.presto.server.PrestoSystemRequirements;
import com.facebook.presto.server.SessionPropertyDefaults;
import com.facebook.presto.server.security.PasswordAuthenticatorManager;
import com.facebook.presto.spark.PrestoSparkModule;
import com.facebook.presto.spark.PrestoSparkServiceWaitTimeMetrics;
import com.facebook.presto.spark.PrestoSparkTestingServiceWaitTimeMetrics;
import com.facebook.presto.spark.classloader_interface.SparkProcessType;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.facebook.presto.storage.TempStorageManager;
import com.facebook.presto.storage.TempStorageModule;
import com.facebook.presto.testing.TestingAccessControlManager;
import com.facebook.presto.testing.TestingTempStorageManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PrestoSparkInjectorFactory {
    private final SparkProcessType sparkProcessType;
    private final Map<String, String> configProperties;
    private final Map<String, Map<String, String>> catalogProperties;
    private final Optional<Map<String, String>> eventListenerProperties;
    private final Optional<Map<String, String>> accessControlProperties;
    private final Optional<Map<String, String>> sessionPropertyConfigurationProperties;
    private final Optional<Map<String, Map<String, String>>> functionNamespaceProperties;
    private final Optional<Map<String, Map<String, String>>> tempStorageProperties;
    private final SqlParserOptions sqlParserOptions;
    private final List<Module> additionalModules;
    private final boolean isForTesting;

    public PrestoSparkInjectorFactory(SparkProcessType sparkProcessType, Map<String, String> configProperties, Map<String, Map<String, String>> catalogProperties, Optional<Map<String, String>> eventListenerProperties, Optional<Map<String, String>> accessControlProperties, Optional<Map<String, String>> sessionPropertyConfigurationProperties, Optional<Map<String, Map<String, String>>> functionNamespaceProperties, Optional<Map<String, Map<String, String>>> tempStorageProperties, SqlParserOptions sqlParserOptions, List<Module> additionalModules) {
        this(sparkProcessType, configProperties, catalogProperties, eventListenerProperties, accessControlProperties, sessionPropertyConfigurationProperties, functionNamespaceProperties, tempStorageProperties, sqlParserOptions, additionalModules, false);
    }

    public PrestoSparkInjectorFactory(SparkProcessType sparkProcessType, Map<String, String> configProperties, Map<String, Map<String, String>> catalogProperties, Optional<Map<String, String>> eventListenerProperties, Optional<Map<String, String>> accessControlProperties, Optional<Map<String, String>> sessionPropertyConfigurationProperties, Optional<Map<String, Map<String, String>>> functionNamespaceProperties, Optional<Map<String, Map<String, String>>> tempStorageProperties, SqlParserOptions sqlParserOptions, List<Module> additionalModules, boolean isForTesting) {
        this.sparkProcessType = Objects.requireNonNull(sparkProcessType, "sparkProcessType is null");
        this.configProperties = ImmutableMap.copyOf(Objects.requireNonNull(configProperties, "configProperties is null"));
        this.catalogProperties = (Map)Objects.requireNonNull(catalogProperties, "catalogProperties is null").entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ImmutableMap.copyOf((Map)((Map)entry.getValue()))));
        this.eventListenerProperties = Objects.requireNonNull(eventListenerProperties, "eventListenerProperties is null").map(ImmutableMap::copyOf);
        this.accessControlProperties = Objects.requireNonNull(accessControlProperties, "accessControlProperties is null").map(ImmutableMap::copyOf);
        this.sessionPropertyConfigurationProperties = Objects.requireNonNull(sessionPropertyConfigurationProperties, "sessionPropertyConfigurationProperties is null").map(ImmutableMap::copyOf);
        this.functionNamespaceProperties = Objects.requireNonNull(functionNamespaceProperties, "functionNamespaceProperties is null").map(map -> (ImmutableMap)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ImmutableMap.copyOf((Map)((Map)entry.getValue())))));
        this.tempStorageProperties = Objects.requireNonNull(tempStorageProperties, "tempStorageProperties is null").map(map -> (ImmutableMap)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ImmutableMap.copyOf((Map)((Map)entry.getValue())))));
        this.sqlParserOptions = Objects.requireNonNull(sqlParserOptions, "sqlParserOptions is null");
        this.additionalModules = ImmutableList.copyOf((Collection)Objects.requireNonNull(additionalModules, "additionalModules is null"));
        this.isForTesting = isForTesting;
    }

    public Injector create() {
        PrestoSystemRequirements.verifySystemTimeIsReasonable();
        ImmutableList.Builder modules = ImmutableList.builder();
        modules.add((Object[])new Module[]{new JsonModule(), new SmileModule(), new EventListenerModule(), new PrestoSparkModule(this.sparkProcessType, this.sqlParserOptions), new WarningCollectorModule()});
        if (this.isForTesting) {
            modules.add(binder -> {
                binder.bind(TestingAccessControlManager.class).in(Scopes.SINGLETON);
                binder.bind(AccessControlManager.class).to(TestingAccessControlManager.class).in(Scopes.SINGLETON);
                binder.bind(AccessControl.class).to(AccessControlManager.class).in(Scopes.SINGLETON);
                binder.bind(TestingTempStorageManager.class).in(Scopes.SINGLETON);
                binder.bind(TempStorageManager.class).to(TestingTempStorageManager.class).in(Scopes.SINGLETON);
                Multibinder.newSetBinder((Binder)binder, PrestoSparkServiceWaitTimeMetrics.class).addBinding().to(PrestoSparkTestingServiceWaitTimeMetrics.class).in(Scopes.SINGLETON);
            });
        } else {
            modules.add((Object)new AccessControlModule());
            modules.add((Object)new TempStorageModule());
        }
        modules.addAll(this.additionalModules);
        Bootstrap app = new Bootstrap((Iterable)modules.build());
        app.doNotInitializeLogging();
        HashMap<String, String> requiredProperties = new HashMap<String, String>();
        requiredProperties.put("node.environment", "spark");
        requiredProperties.putAll(this.configProperties);
        app.setRequiredConfigurationProperties((Map)ImmutableMap.copyOf(requiredProperties));
        Injector injector = app.initialize();
        try {
            ((PluginManager)injector.getInstance(PluginManager.class)).loadPlugins();
            ((StaticCatalogStore)injector.getInstance(StaticCatalogStore.class)).loadCatalogs(this.catalogProperties);
            ((ResourceGroupManager)injector.getInstance(ResourceGroupManager.class)).loadConfigurationManager();
            ((PasswordAuthenticatorManager)injector.getInstance(PasswordAuthenticatorManager.class)).loadPasswordAuthenticator();
            this.eventListenerProperties.ifPresent(properties -> ((EventListenerManager)injector.getInstance(EventListenerManager.class)).loadConfiguredEventListener(properties));
            if (!this.isForTesting) {
                if (this.accessControlProperties.isPresent()) {
                    ((AccessControlManager)injector.getInstance(AccessControlManager.class)).loadSystemAccessControl(this.accessControlProperties.get());
                } else {
                    ((AccessControlManager)injector.getInstance(AccessControlManager.class)).loadSystemAccessControl();
                }
                if (this.tempStorageProperties.isPresent()) {
                    ((TempStorageManager)injector.getInstance(TempStorageManager.class)).loadTempStorages(this.tempStorageProperties.get());
                } else {
                    ((TempStorageManager)injector.getInstance(TempStorageManager.class)).loadTempStorages();
                }
            }
            if (this.sparkProcessType.equals((Object)SparkProcessType.DRIVER)) {
                if (this.sessionPropertyConfigurationProperties.isPresent()) {
                    ((SessionPropertyDefaults)injector.getInstance(SessionPropertyDefaults.class)).loadConfigurationManager(this.sessionPropertyConfigurationProperties.get());
                } else {
                    ((SessionPropertyDefaults)injector.getInstance(SessionPropertyDefaults.class)).loadConfigurationManager();
                }
            }
            if (this.sparkProcessType.equals((Object)SparkProcessType.DRIVER) || !((FeaturesConfig)injector.getInstance(FeaturesConfig.class)).isInlineSqlFunctions()) {
                if (this.functionNamespaceProperties.isPresent()) {
                    ((StaticFunctionNamespaceStore)injector.getInstance(StaticFunctionNamespaceStore.class)).loadFunctionNamespaceManagers(this.functionNamespaceProperties.get());
                } else {
                    ((StaticFunctionNamespaceStore)injector.getInstance(StaticFunctionNamespaceStore.class)).loadFunctionNamespaceManagers();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return injector;
    }
}

